/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.forms;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.configuration.UserProfile;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@PublicApiRef
@ShowOnlyPublicApiMembers
public class UserAccount {
    private String username;
    private boolean external;
    private String profileId;
    private String email;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String password;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String previousPassword;
    private String fullName;
    private boolean loginAllowed;
    private String dateFormat;
    private String timeFormat;
    private Integer firstDayOfWeek;
    private Date lastActive;

    @PublicApiMember
    public UserAccount() {
    }

    public UserAccount(String username, UserProfile profile, boolean isInternal) {
        this.username = username;
        boolean bl = this.external = !isInternal;
        if (profile != null) {
            this.profileId = profile.getId();
            this.email = profile.getEmail();
            this.fullName = profile.getFullName();
            this.loginAllowed = profile.isLoginAllowed();
            this.dateFormat = profile.getDateFormat();
            this.timeFormat = profile.getTimeFormat();
            this.firstDayOfWeek = profile.getFirstDayOfWeek();
            this.lastActive = profile.getLastActive();
        }
    }

    public UserProfile toUserProfile() {
        UserProfile profile = new UserProfile(this.username, this.email, this.fullName, this.loginAllowed, this.lastActive);
        profile.setDateFormat(this.dateFormat);
        profile.setTimeFormat(this.timeFormat);
        profile.setFirstDayOfWeek(this.firstDayOfWeek);
        return profile;
    }

    @PublicApiMember
    public String getUsername() {
        return this.username;
    }

    @PublicApiMember
    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isExternal() {
        return this.external;
    }

    public String getProfileId() {
        return this.profileId;
    }

    @PublicApiMember
    public String getEmail() {
        return this.email;
    }

    @PublicApiMember
    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return this.password;
    }

    @PublicApiMember
    public void setPassword(String password) {
        this.password = password;
    }

    public boolean hasPassword() {
        return this.password != null && !this.password.isEmpty();
    }

    public String getPreviousPassword() {
        return this.previousPassword;
    }

    public void setPreviousPassword(String previousPassword) {
        this.previousPassword = previousPassword;
    }

    @PublicApiMember
    public String getFullName() {
        return this.fullName;
    }

    @PublicApiMember
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @PublicApiMember
    public boolean isLoginAllowed() {
        return this.loginAllowed;
    }

    @PublicApiMember
    public void setLoginAllowed(boolean loginAllowed) {
        this.loginAllowed = loginAllowed;
    }

    @PublicApiMember
    public String getDateFormat() {
        return this.dateFormat;
    }

    @PublicApiMember
    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    @PublicApiMember
    public Integer getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    @PublicApiMember
    public void setFirstDayOfWeek(Integer firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
    }

    @PublicApiMember
    public String getTimeFormat() {
        return this.timeFormat;
    }

    @PublicApiMember
    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    @PublicApiMember
    public Date getLastActive() {
        return this.lastActive;
    }

    @PublicApiMember
    public void setLastActive(Date lastActive) {
        this.lastActive = lastActive;
    }

    public void validate() {
        Checks.checkArgument((!Strings.isBlank((String)this.username) ? 1 : 0) != 0, (String)"User name cannot be empty.", (Object[])new Object[0]);
        Checks.checkArgument((!Strings.isBlank((String)this.password) ? 1 : 0) != 0, (String)"Password is required when creating a user.", (Object[])new Object[0]);
        if (!this.isExternal()) {
            Pattern pattern = Pattern.compile("^(?![\\.\\-_])(?!.*[\\.\\-_]{2})[\\w\\.\\-_]*[^\\W_]$", 256);
            Matcher matcher = pattern.matcher(this.username);
            Checks.checkArgument((boolean)matcher.matches(), (String)"All the alphanumeric characters and the special characters dash (-), underscore (_), and dot (.) are allowed. The special characters cannot be repeated more than once in a row. The username must not start or end with a special character.", (Object[])new Object[0]);
        }
    }
}

