/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.deployit.plumbing.id.IdType;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PhaseVersion;
import com.xebialabs.xlrelease.repository.ReleaseTriggerRepository;
import com.xebialabs.xlrelease.search.PlanItemSearchResult;
import com.xebialabs.xlrelease.search.ReleaseCountResults;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TaskAccessService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.service.UserInfoResolver;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.views.BulkActionResultView;
import com.xebialabs.xlrelease.views.MovementIndexes;
import com.xebialabs.xlrelease.views.PhaseFullView;
import com.xebialabs.xlrelease.views.PlanItemSearchView;
import com.xebialabs.xlrelease.views.ReleaseForm;
import com.xebialabs.xlrelease.views.ReleaseFullView;
import com.xebialabs.xlrelease.views.ReleasePermissionsView;
import com.xebialabs.xlrelease.views.ReleaseSearchView;
import com.xebialabs.xlrelease.views.ReleaseTriggerView;
import com.xebialabs.xlrelease.views.TaskFullView;
import com.xebialabs.xlrelease.views.TemplateFilters;
import com.xebialabs.xlrelease.views.converters.PhaseViewConverter;
import com.xebialabs.xlrelease.views.converters.PlanItemViewConverter;
import com.xebialabs.xlrelease.views.converters.ReleaseFormConverter;
import com.xebialabs.xlrelease.views.converters.ReleaseTriggerViewConverter;
import com.xebialabs.xlrelease.views.converters.ReleaseViewConverter;
import com.xebialabs.xlrelease.views.converters.TasksViewConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.spi.BadRequestException;
import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/releases")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class ReleaseResource {
    private ReleaseTriggerRepository releaseTriggerRepository;
    private ReleaseService releaseService;
    private PermissionChecker permissions;
    private ReleaseSearchService releasesSearch;
    private ReleaseActorService releaseActorService;
    private TaskAccessService taskAccessService;
    private ReleaseViewConverter releaseViewConverter;
    private PhaseViewConverter phaseViewConverter;
    private TasksViewConverter tasksViewConverter;
    private PlanItemViewConverter planItemViewConverter;
    private UserInfoResolver userInfoResolver;
    private ReleaseTriggerViewConverter releaseTriggerViewConverter;
    private TeamService teamService;
    private ReleaseFormConverter releaseFormConverter;

    @Autowired
    public ReleaseResource(ReleaseService releaseService, ReleaseTriggerRepository releaseTriggerRepository, PermissionChecker permissions, ReleaseSearchService releasesSearch, ReleaseActorService releaseActorService, TaskAccessService taskAccessService, UserInfoResolver userInfoResolver, ReleaseViewConverter releaseViewConverter, PhaseViewConverter phaseViewConverter, TasksViewConverter tasksViewConverter, PlanItemViewConverter planItemViewConverter, ReleaseTriggerViewConverter releaseTriggerViewConverter, TeamService teamService, ReleaseFormConverter releaseFormConverter) {
        this.releaseService = releaseService;
        this.releaseTriggerRepository = releaseTriggerRepository;
        this.permissions = permissions;
        this.releasesSearch = releasesSearch;
        this.releaseActorService = releaseActorService;
        this.taskAccessService = taskAccessService;
        this.planItemViewConverter = planItemViewConverter;
        this.userInfoResolver = userInfoResolver;
        this.releaseViewConverter = releaseViewConverter;
        this.phaseViewConverter = phaseViewConverter;
        this.tasksViewConverter = tasksViewConverter;
        this.releaseTriggerViewConverter = releaseTriggerViewConverter;
        this.teamService = teamService;
        this.releaseFormConverter = releaseFormConverter;
    }

    @POST
    @Timed
    @Path(value="templates/search")
    public ReleaseSearchView getTemplates(@QueryParam(value="page") Long page, @QueryParam(value="numberbypage") Long numberByPage, @QueryParam(value="depth") Integer depth, TemplateFilters templateFilters) {
        Integer loadDepth = Optional.ofNullable(depth).orElse(this.releasesSearch.DEFAULT_RELEASE_LOAD_DEPTH());
        ReleaseSearchResult searchResult = this.releasesSearch.searchTemplates(templateFilters, page != null ? page : 0L, Optional.ofNullable(numberByPage).orElse(this.releasesSearch.DEFAULT_NUMBER_OF_RELEASES_PER_PAGE()), loadDepth);
        return this.releaseViewConverter.toSearchView(searchResult, this.taskAccessService.getAllowedTaskTypesForAuthenticatedUser(), Collections.singletonList("riskProfile"), loadDepth, Collections.emptyList());
    }

    @GET
    @Timed
    @Path(value="templates/search")
    public PlanItemSearchView getAllTemplateIds(@QueryParam(value="page") Long page, @QueryParam(value="numberbypage") Long numberByPage) {
        PlanItemSearchResult searchResult = this.releasesSearch.findAllTemplateIdsAndTitles(page != null ? page : 0L, numberByPage);
        return this.planItemViewConverter.toSearchView(searchResult);
    }

    @POST
    @Timed
    @Path(value="templates")
    public ReleaseFullView createTemplate(ReleaseForm releaseForm) {
        if (releaseForm.getParentId() == null || Ids.ROOT_FOLDER_ID.equals(releaseForm.getParentId())) {
            this.permissions.check(XLReleasePermissions.CREATE_TEMPLATE);
        } else {
            this.permissions.check(XLReleasePermissions.EDIT_TEMPLATE, releaseForm.getParentId());
        }
        Preconditions.checkArgument((boolean)releaseForm.hasTitle(), (Object)"Template title is mandatory");
        Preconditions.checkArgument((boolean)releaseForm.hasValidDates(), (Object)"Dates are not valid");
        Release release = releaseForm.getTemplateId() == null ? this.releaseService.createTemplate(this.releaseFormConverter.toRelease(releaseForm), releaseForm.getParentId()) : this.releaseService.copyTemplate(releaseForm.getTemplateId(), this.releaseFormConverter.toRelease(releaseForm));
        return this.getReleaseFullView(release);
    }

    @DELETE
    @Timed
    @Path(value="templates/{templateId:.*Release[^/-]*}")
    public Response deleteTemplate(@PathParam(value="templateId") @IdParam String templateId) {
        if (Ids.isInFolder((String)templateId)) {
            this.permissions.check(XLReleasePermissions.EDIT_TEMPLATE, Ids.getParentId((String)templateId));
        } else {
            this.permissions.check(XLReleasePermissions.CREATE_TEMPLATE);
        }
        this.releaseActorService.deleteTemplate(templateId);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @PUT
    @Timed
    @Path(value="templates/{templateId:.*Release[^/-]*}")
    public ReleaseFullView updateTemplate(@PathParam(value="templateId") @IdParam String templateId, ReleaseForm releaseForm) {
        this.permissions.check(XLReleasePermissions.EDIT_TEMPLATE, templateId);
        return this.getReleaseFullView(this.releaseActorService.updateTemplateAndResumeTrigger(templateId, this.releaseFormConverter.toRelease(releaseForm)));
    }

    @POST
    @Timed
    @Path(value="search")
    public ReleaseSearchView searchReleases(@QueryParam(value="page") Long page, @QueryParam(value="numberbypage") Long numberByPage, @QueryParam(value="depth") Integer depth, @QueryParam(value="properties") List<String> properties, @QueryParam(value="extensions") List<String> extensions, ReleasesFilters releasesFilters) {
        int RELEASE_WITH_VARIABLES_AND_PHASES_DEPTH = 2;
        Integer loadDepth = Optional.ofNullable(depth).orElse(2);
        ReleaseSearchResult searchResult = this.releasesSearch.search(releasesFilters, page != null ? page : 0L, Optional.ofNullable(numberByPage).orElse(this.releasesSearch.DEFAULT_NUMBER_OF_RELEASES_PER_PAGE()), loadDepth);
        return this.releaseViewConverter.toSearchView(searchResult, this.taskAccessService.getAllowedTaskTypesForAuthenticatedUser(), properties, loadDepth, extensions);
    }

    @POST
    @Timed
    @Path(value="count")
    public ReleaseCountResults countReleases(ReleasesFilters releasesFilters) {
        return this.releasesSearch.count(releasesFilters);
    }

    @POST
    public ReleaseFullView createRelease(ReleaseForm releaseForm) {
        Release release;
        Preconditions.checkArgument((boolean)releaseForm.hasTitle(), (Object)"Release title is mandatory");
        if (!releaseForm.hasValidDates()) {
            throw new BadRequestException("Scheduled start date must be before due date");
        }
        if (releaseForm.isFromTemplate()) {
            this.permissions.checkIsAllowedToCreateReleaseFromTemplate(releaseForm.getTemplateId());
            release = this.releaseService.createFromTemplate(releaseForm.getTemplateId(), this.releaseFormConverter.toRelease(releaseForm), releaseForm.getParentId());
        } else {
            this.permissions.checkIsAllowedToCreateReleaseInFolder(releaseForm.getParentId());
            release = this.releaseService.createWithoutTemplate(this.releaseFormConverter.toRelease(releaseForm), releaseForm.getParentId());
        }
        return this.getReleaseFullView(release);
    }

    @PUT
    @Timed
    @Path(value="{releaseId:((?!templates).)*Release[^/-]*}")
    public ReleaseFullView updateRelease(@PathParam(value="releaseId") @IdParam String releaseId, ReleaseForm releaseForm) {
        this.permissions.check(XLReleasePermissions.EDIT_RELEASE, releaseId);
        return this.getReleaseFullViewWithProperties(this.releaseActorService.updateRelease(releaseId, this.releaseFormConverter.toRelease(releaseForm)), Collections.singletonList("riskProfile"));
    }

    @GET
    @Timed
    @Path(value="templates/{templateId:.*Release[^/-]*}/duration")
    public Integer getTemplateDuration(@PathParam(value="templateId") @IdParam String templateId) {
        Release template = this.releaseService.findByIdIncludingArchived(templateId);
        if (!template.isTemplate()) {
            throw new BadRequestException("templateId does not belong to a template");
        }
        this.permissions.checkView(template);
        Duration duration = this.releaseService.getDurationOf(template);
        return duration.toStandardSeconds().getSeconds();
    }

    @POST
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/start")
    public ReleaseFullView startRelease(@PathParam(value="releaseId") @IdParam String releaseId) {
        this.permissions.check(XLReleasePermissions.START_RELEASE, releaseId);
        return this.getReleaseFullView(this.releaseActorService.startRelease(releaseId, User.AUTHENTICATED_USER));
    }

    @POST
    @Path(value="start")
    public BulkActionResultView startReleases(List<String> releaseIds) {
        List<String> allowedReleaseIds = this.permissions.filterStartableReleases(releaseIds);
        if (allowedReleaseIds.isEmpty()) {
            return new BulkActionResultView(allowedReleaseIds);
        }
        return new BulkActionResultView(this.releaseActorService.startReleases(allowedReleaseIds, User.AUTHENTICATED_USER).stream().map(IdType.DOMAIN::convertToViewId).collect(Collectors.toList()));
    }

    @POST
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/abort")
    public ReleaseFullView abortRelease(@PathParam(value="releaseId") @IdParam String releaseId) {
        this.permissions.check(XLReleasePermissions.ABORT_RELEASE, releaseId);
        return this.getReleaseFullView(this.releaseActorService.abortRelease(releaseId));
    }

    @POST
    @Path(value="abort")
    public BulkActionResultView abortReleases(List<String> releaseIds) {
        List<String> allowedReleaseIds = this.permissions.filterAbortableReleases(releaseIds);
        if (allowedReleaseIds.isEmpty()) {
            return new BulkActionResultView(allowedReleaseIds);
        }
        return new BulkActionResultView(this.releaseActorService.abortReleases(allowedReleaseIds).stream().map(IdType.DOMAIN::convertToViewId).collect(Collectors.toList()));
    }

    @GET
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}")
    public ReleaseFullView getRelease(@PathParam(value="releaseId") @IdParam String releaseId) {
        Release release = this.releaseService.findByIdIncludingArchived(releaseId);
        this.permissions.checkView(release);
        return this.getReleaseFullViewWithProperties(release, Collections.singletonList("riskProfile"));
    }

    @POST
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/phases/move")
    public PhaseFullView movePhase(@PathParam(value="releaseId") @IdParam String releaseId, MovementIndexes movementIndexes) {
        this.permissions.checkEdit(releaseId);
        return this.getPhaseFullView(this.releaseActorService.movePhase(releaseId, movementIndexes));
    }

    @POST
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/tasks/move")
    public TaskFullView moveTask(@PathParam(value="releaseId") @IdParam String releaseId, MovementIndexes movementIndexes) {
        this.permissions.checkEdit(releaseId);
        return this.getTaskFullView(this.releaseActorService.moveTask(releaseId, movementIndexes));
    }

    @POST
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/phases/add")
    public PhaseFullView addPhase(@PathParam(value="releaseId") @IdParam String releaseId) {
        this.permissions.checkEdit(releaseId);
        Phase phase = this.releaseActorService.addPhase(releaseId);
        return this.getPhaseFullView(phase);
    }

    @PUT
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/tasks/duplicate/{taskId:.*Task[^/-]*}")
    public TaskFullView duplicateTask(@PathParam(value="releaseId") @IdParam String releaseId, @PathParam(value="taskId") @IdParam String originTaskId) {
        this.permissions.checkEdit(releaseId);
        return this.getTaskFullView(this.releaseActorService.duplicateTask(releaseId, originTaskId));
    }

    @PUT
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/phases/duplicate/{phaseId:.*Phase[^/-]*}")
    public PhaseFullView duplicatePhase(@PathParam(value="releaseId") @IdParam String releaseId, @PathParam(value="phaseId") @IdParam String originPhaseId) {
        this.permissions.checkEdit(releaseId);
        return this.getPhaseFullView(this.releaseActorService.duplicatePhase(releaseId, originPhaseId));
    }

    @GET
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/permissions")
    public ReleasePermissionsView getPermissions(@PathParam(value="releaseId") @IdParam String releaseId) {
        this.permissions.checkEditSecurity(releaseId);
        Release release = this.releaseService.findByIdIncludingArchived(releaseId);
        List permissions = release.isTemplate() ? XLReleasePermissions.getTemplatePermissions() : XLReleasePermissions.getReleasePermissions();
        return new ReleasePermissionsView(permissions, release, this.userInfoResolver);
    }

    @POST
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/restartPhases")
    public ReleaseFullView restartPhases(@PathParam(value="releaseId") @IdParam String releaseId, @QueryParam(value="fromPhaseId") @IdParam String phaseId, @QueryParam(value="fromTaskId") @IdParam String taskId, @QueryParam(value="phaseVersion") PhaseVersion phaseVersion) {
        this.permissions.check(XLReleasePermissions.EDIT_RELEASE, releaseId);
        return this.getReleaseFullView(this.releaseActorService.restartPhase(releaseId, phaseId, taskId, phaseVersion));
    }

    @POST
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/resume")
    public ReleaseFullView resume(@PathParam(value="releaseId") @IdParam String releaseId) {
        this.permissions.check(XLReleasePermissions.EDIT_RELEASE, releaseId);
        return this.getReleaseFullView(this.releaseActorService.resume(releaseId));
    }

    @DELETE
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/attachments/{attachmentId:.*Attachment[^/-]*}")
    public void deleteAttachment(@PathParam(value="releaseId") @IdParam String releaseId, @PathParam(value="attachmentId") @IdParam String attachmentId) {
        this.permissions.check(XLReleasePermissions.EDIT_RELEASE, releaseId);
        this.releaseActorService.deleteAttachment(releaseId, attachmentId);
    }

    @DELETE
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/{taskId:.*Task[^/-]*}/attachments/{attachmentId:.*Attachment[^/-]*}")
    public void deleteAttachmentFromTask(@PathParam(value="releaseId") @IdParam String releaseId, @PathParam(value="taskId") @IdParam String taskId, @PathParam(value="attachmentId") @IdParam String attachmentId) {
        this.permissions.check(XLReleasePermissions.EDIT_RELEASE_TASK, releaseId);
        this.releaseActorService.deleteAttachmentFromTask(releaseId, taskId, attachmentId);
    }

    @GET
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/teams/assignable")
    public Collection<Team> getAssignableTeams(@PathParam(value="releaseId") @IdParam String releaseId) {
        this.permissions.checkEditOrReassignTask(releaseId);
        List<Team> teamsIncludingInherited = this.teamService.getEffectiveTeams(releaseId);
        Predicate<Team> withoutTemplateOwner = team -> !team.getTeamName().equals("Template Owner");
        return teamsIncludingInherited.stream().filter(withoutTemplateOwner).collect(Collectors.toList());
    }

    @POST
    @Timed
    @Path(value="{templateId:.*Release[^/-]*}/triggers")
    public void addTrigger(@PathParam(value="templateId") @IdParam String templateId, ReleaseTriggerView releaseTriggerView) {
        Release release = this.releaseService.findByIdIncludingArchived(templateId);
        Preconditions.checkArgument((boolean)release.isTemplate(), (Object)"Triggers can only be added to templates");
        this.permissions.check(XLReleasePermissions.CREATE_RELEASE_FROM_TEMPLATE, release);
        this.permissions.check(XLReleasePermissions.EDIT_TRIGGERS, release);
        Preconditions.checkArgument((boolean)releaseTriggerView.hasValidPeriodicity(), (Object)"Interval value is not valid for the selected type");
        Preconditions.checkArgument((!release.isArchived() ? 1 : 0) != 0, (Object)"Cannot add a trigger to an archived release");
        this.releaseActorService.addTrigger(templateId, this.releaseTriggerViewConverter.fromView(releaseTriggerView));
    }

    @GET
    @Timed
    @Path(value="{templateId:.*Release[^/-]*}/triggers")
    public List<ReleaseTriggerView> getTriggers(@PathParam(value="templateId") @IdParam String templateId) {
        Release template = this.releaseService.findById(templateId);
        this.permissions.check(XLReleasePermissions.EDIT_TRIGGERS, template);
        return template.getReleaseTriggers().stream().map(this.releaseTriggerViewConverter::toView).collect(Collectors.toList());
    }

    @GET
    @Timed
    @Path(value="{templateId:.*Release[^/-]*}/triggers/{triggerId:.*Trigger[^/-]*}")
    public ReleaseTriggerView getTrigger(@PathParam(value="templateId") @IdParam String templateId, @PathParam(value="triggerId") @IdParam String triggerId) {
        ReleaseTrigger releaseTrigger = this.releaseTriggerRepository.find(triggerId);
        this.permissions.check(XLReleasePermissions.EDIT_TRIGGERS, releaseTrigger.getTemplate());
        return this.releaseTriggerViewConverter.toView(releaseTrigger);
    }

    @DELETE
    @Timed
    @Path(value="{templateId:.*Release[^/-]*}/triggers/{triggerId:.*Trigger[^/-]*}")
    public void removeTrigger(@PathParam(value="templateId") @IdParam String templateId, @PathParam(value="triggerId") @IdParam String triggerId) {
        this.permissions.check(XLReleasePermissions.EDIT_TRIGGERS, templateId);
        this.releaseActorService.deleteTrigger(templateId, triggerId);
    }

    @PUT
    @Timed
    @Path(value="{templateId:.*Release[^/-]*}/triggers/{triggerId:.*Trigger[^/-]*}")
    public void updateTrigger(@PathParam(value="templateId") @IdParam String templateId, @PathParam(value="triggerId") @IdParam String triggerId, ReleaseTriggerView releaseTriggerView) {
        this.permissions.check(XLReleasePermissions.EDIT_TRIGGERS, templateId);
        Preconditions.checkArgument((boolean)releaseTriggerView.hasValidPeriodicity(), (Object)"Interval value is not valid for the selected type");
        this.releaseActorService.updateTrigger(templateId, this.releaseTriggerViewConverter.fromView(releaseTriggerView));
    }

    @GET
    @Path(value="tags")
    public Set<String> getAllTags() {
        return this.releaseService.getAllTags(500);
    }

    @GET
    @Path(value="tags/archived")
    public Set<String> getAllArchivedTags() {
        return this.releaseService.getAllArchivedTags(500);
    }

    private ReleaseFullView getReleaseFullView(Release release) {
        return this.getReleaseFullViewWithProperties(release, Collections.emptyList());
    }

    private ReleaseFullView getReleaseFullViewWithProperties(Release release, List<String> properties) {
        return this.releaseViewConverter.toFullView(release, this.taskAccessService.getAllowedTaskTypesForAuthenticatedUser(), properties, Collections.singletonList("progress"), Integer.MAX_VALUE);
    }

    private PhaseFullView getPhaseFullView(Phase phase) {
        return this.phaseViewConverter.toFullView(phase, this.taskAccessService.getAllowedTaskTypesForAuthenticatedUser());
    }

    private TaskFullView getTaskFullView(Task task) {
        return this.tasksViewConverter.toFullView(task, this.taskAccessService.getAllowedTaskTypesForAuthenticatedUser());
    }
}

