/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.utils;

import com.xebialabs.xlrelease.utils.TableAttributeProvider;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.commonmark.Extension;
import org.commonmark.ext.autolink.AutolinkExtension;
import org.commonmark.ext.gfm.strikethrough.StrikethroughExtension;
import org.commonmark.ext.gfm.tables.TablesExtension;
import org.commonmark.ext.ins.InsExtension;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;

public class MarkdownProcessor {
    private static final List<Extension> EXTENSIONS = Arrays.asList(AutolinkExtension.create(), StrikethroughExtension.create(), TablesExtension.create(), InsExtension.create());
    private static final Parser PARSER = Parser.builder().extensions(EXTENSIONS).build();
    private static final HtmlRenderer HTML_RENDERER = HtmlRenderer.builder().attributeProviderFactory(context -> new TableAttributeProvider()).escapeHtml(true).extensions(EXTENSIONS).build();

    public static Optional<String> process(String input) {
        if (input == null) {
            return Optional.empty();
        }
        Node node = PARSER.parse(input);
        String output = HTML_RENDERER.render(node);
        return Optional.of(output);
    }
}

