/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.config.ArchivingSettingsManager;
import com.xebialabs.xlrelease.service.ArchivingService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PreDestroy;
import org.joda.time.LocalDateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001B\u000b\u0017\u0001}A\u0001B\f\u0001\u0003\u0006\u0004%\ta\f\u0005\ti\u0001\u0011\t\u0011)A\u0005a!AQ\u0007\u0001BC\u0002\u0013\u0005a\u0007\u0003\u0005>\u0001\t\u0005\t\u0015!\u00038\u0011\u0015q\u0004\u0001\"\u0001@\u0011\u001d\u0011\u0006A1A\u0005\nMCa\u0001\u0019\u0001!\u0002\u0013!\u0006bB1\u0001\u0005\u0004%IA\u0019\u0005\u0007S\u0002\u0001\u000b\u0011B2\t\u000b)\u0004A\u0011A6\t\u000b]\u0004A\u0011\u0001=\t\r]\u0004A\u0011AA\f\u0011\u001d\tY\u0002\u0001C\u0005\u0003;Aq!!\u0010\u0001\t\u0013\ty\u0004C\u0004\u0002v\u0001!I!a\u001e\t\u000f\u0005\u001d\u0005\u0001\"\u0003\u0002\n\"9\u00111\u0012\u0001\u0005\n\u0005]\u0001bBAG\u0001\u0011%\u0011q\u0012\u0005\b\u0003'\u0003A\u0011BA\f\u0011\u001d\t)\n\u0001C\u0005\u0003/\u0011\u0001$\u0011:dQ&4\u0018N\\4TG\",G-\u001e7f'\u0016\u0014h/[2f\u0015\t9\u0002$A\u0004tKJ4\u0018nY3\u000b\u0005eQ\u0012!\u0003=me\u0016dW-Y:f\u0015\tYB$A\u0005yK\nL\u0017\r\\1cg*\tQ$A\u0002d_6\u001c\u0001aE\u0002\u0001A\u0019\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0007CA\u0014-\u001b\u0005A#BA\u0015+\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005Y\u0013\u0001C4sSjTH.\u001a3\n\u00055B#a\u0002'pO\u001eLgnZ\u0001\u0011CJ\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016,\u0012\u0001\r\t\u0003cIj\u0011AF\u0005\u0003gY\u0011\u0001#\u0011:dQ&4\u0018N\\4TKJ4\u0018nY3\u0002#\u0005\u00148\r[5wS:<7+\u001a:wS\u000e,\u0007%A\bbe\u000eD\u0017N^5oO\u000e{gNZ5h+\u00059\u0004C\u0001\u001d<\u001b\u0005I$B\u0001\u001e\u0019\u0003\u0019\u0019wN\u001c4jO&\u0011A(\u000f\u0002\u0019\u0003J\u001c\u0007.\u001b<j]\u001e\u001cV\r\u001e;j]\u001e\u001cX*\u00198bO\u0016\u0014\u0018\u0001E1sG\"Lg/\u001b8h\u0007>tg-[4!\u0003\u0019a\u0014N\\5u}Q\u0019\u0001)\u0011\"\u0011\u0005E\u0002\u0001\"\u0002\u0018\u0006\u0001\u0004\u0001\u0004\"B\u001b\u0006\u0001\u00049\u0004FA\u0003E!\t)\u0005+D\u0001G\u0015\t9\u0005*\u0001\u0006b]:|G/\u0019;j_:T!!\u0013&\u0002\u000f\u0019\f7\r^8ss*\u00111\nT\u0001\u0006E\u0016\fgn\u001d\u0006\u0003\u001b:\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002\u001f\u0006\u0019qN]4\n\u0005E3%!C!vi><\u0018N]3e\u0003EI7oQ1oG\u0016d'+Z9vKN$X\rZ\u000b\u0002)B\u0011QKX\u0007\u0002-*\u0011q\u000bW\u0001\u0007CR|W.[2\u000b\u0005eS\u0016AC2p]\u000e,(O]3oi*\u00111\fX\u0001\u0005kRLGNC\u0001^\u0003\u0011Q\u0017M^1\n\u0005}3&!D!u_6L7MQ8pY\u0016\fg.\u0001\njg\u000e\u000bgnY3m%\u0016\fX/Z:uK\u0012\u0004\u0013!F1sG\"Lg/Z%o!J|wM]3tg2{7m[\u000b\u0002GB\u0011AmZ\u0007\u0002K*\u0011a\rX\u0001\u0005Y\u0006tw-\u0003\u0002iK\n1qJ\u00196fGR\fa#\u0019:dQ&4X-\u00138Qe><'/Z:t\u0019>\u001c7\u000eI\u0001\u001cO\u0016$\u0018I]2iSZLgn\u001a&pE\u000e\u0013xN\\*dQ\u0016$W\u000f\\3\u0016\u00031\u0004\"!\u001c;\u000f\u00059\u0014\bCA8#\u001b\u0005\u0001(BA9\u001f\u0003\u0019a$o\\8u}%\u00111OI\u0001\u0007!J,G-\u001a4\n\u0005U4(AB*ue&twM\u0003\u0002tE\u00051\u0012M]2iSZ,W\t\u001f9je\u0016$'+\u001a7fCN,7\u000f\u0006\u0002zyB\u0011\u0011E_\u0005\u0003w\n\u0012A!\u00168ji\")Qp\u0003a\u0001}\u0006\u0019\"/\u001a7fCN,\u0017iZ3U_\u0006\u00138\r[5wKB\u0011Am`\u0005\u0004\u0003\u0003)'aB%oi\u0016<WM\u001d\u0015\u0004\u0017\u0005\u0015\u0001\u0003BA\u0004\u0003'i!!!\u0003\u000b\u0007\u001d\u000bYA\u0003\u0003\u0002\u000e\u0005=\u0011aB7fiJL7m\u001d\u0006\u0004\u0003#a\u0012\u0001C2pI\u0006D\u0017\r\\3\n\t\u0005U\u0011\u0011\u0002\u0002\u0006)&lW\r\u001a\u000b\u0002s\"\u001aA\"!\u0002\u0002A\u0019Lg\u000eZ!oIB\u0013xnY3tg\u0006\u00138\r[5wC\ndWMU3mK\u0006\u001cXm\u001d\u000b\u0005\u0003?\t\t\u0004\u0006\u0003\u0002\"\u0005\u001d\u0002cA\u0011\u0002$%\u0019\u0011Q\u0005\u0012\u0003\u0007%sG\u000fC\u0004\u0002*5\u0001\r!a\u000b\u0002\r\u0005\u001cG/[8o!\u0015\t\u0013Q\u00067z\u0013\r\tyC\t\u0002\n\rVt7\r^5p]FBq!a\r\u000e\u0001\u0004\t)$\u0001\u0003eCR,\u0007\u0003BA\u001c\u0003si\u0011AW\u0005\u0004\u0003wQ&\u0001\u0002#bi\u0016\fq\u0002\u001d:pG\u0016\u001c8OU3mK\u0006\u001cXm\u001d\u000b\t\u0003\u0003\nY%!\u0019\u0002lQ!\u00111IA%!\r\t\u0013QI\u0005\u0004\u0003\u000f\u0012#a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003Sq\u0001\u0019AA\u0016\u0011\u001d\tiE\u0004a\u0001\u0003\u001f\n!B]3mK\u0006\u001cX-\u00133t!\u0015\t\t&a\u0017m\u001d\u0011\t\u0019&a\u0016\u000f\u0007=\f)&C\u0001$\u0013\r\tIFI\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti&a\u0018\u0003\u0011%#XM]1cY\u0016T1!!\u0017#\u0011\u001d\t\u0019G\u0004a\u0001\u0003K\nQaY8v]R\u00042!VA4\u0013\r\tIG\u0016\u0002\u000e\u0003R|W.[2J]R,w-\u001a:\t\u000f\u00055d\u00021\u0001\u0002p\u0005\u0011\"/\u001e8Ti\u0006\u0014H\u000fV5nK6KG\u000e\\5t!\r\t\u0013\u0011O\u0005\u0004\u0003g\u0012#\u0001\u0002'p]\u001e\fq#\u0019:dQ&4XmQ8na2,G/\u001a3SK2,\u0017m]3\u0015\t\u0005e\u00141\u0011\t\u0006\u0003w\ny(_\u0007\u0003\u0003{R!a\u0017\u0012\n\t\u0005\u0005\u0015Q\u0010\u0002\u0004)JL\bBBAC\u001f\u0001\u0007A.A\u0005sK2,\u0017m]3JI\u0006\tr-\u001a;TK\u0006\u00148\r\u001b)bO\u0016\u001c\u0016N_3\u0016\u0005\u0005\u0005\u0012!D:mK\u0016\u0004\u0018J\u001a(fK\u0012,G-\u0001\u0006sC:$vn\u001c'p]\u001e$B!a\u0011\u0002\u0012\"9\u0011Q\u000e\nA\u0002\u0005=\u0014aA8gM\u0006Q\u0001O]3EKN$(o\\=)\u0007Q\tI\n\u0005\u0003\u0002\u001c\u0006\rVBAAO\u0015\r9\u0015q\u0014\u0006\u0003\u0003C\u000bQA[1wCbLA!!*\u0002\u001e\nQ\u0001K]3EKN$(o\\=)\u0007\u0001\tI\u000b\u0005\u0003\u0002,\u0006EVBAAW\u0015\r\ty\u000bT\u0001\u000bgR,'/Z8usB,\u0017\u0002BAZ\u0003[\u0013qaU3sm&\u001cW\r")
public class ArchivingScheduleService
implements Logging {
    private final ArchivingService archivingService;
    private final ArchivingSettingsManager archivingConfig;
    private final AtomicBoolean isCancelRequested;
    private final Object archiveInProgressLock;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ArchivingScheduleService archivingScheduleService = this;
        synchronized (archivingScheduleService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ArchivingService archivingService() {
        return this.archivingService;
    }

    public ArchivingSettingsManager archivingConfig() {
        return this.archivingConfig;
    }

    private AtomicBoolean isCancelRequested() {
        return this.isCancelRequested;
    }

    private Object archiveInProgressLock() {
        return this.archiveInProgressLock;
    }

    public String getArchivingJobCronSchedule() {
        return this.archivingConfig().getArchivingJobCronSchedule();
    }

    @Timed
    public void archiveExpiredReleases(Integer releaseAgeToArchive) {
        if (this.archivingConfig().getEnabled()) {
            long startArchiving = System.currentTimeMillis();
            Date expirationDate = LocalDateTime.now().minusHours(Predef$.MODULE$.Integer2int(releaseAgeToArchive)).toDate();
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Archiving completed releases older than ").append(releaseAgeToArchive).append(" hours (completed before ").append(expirationDate).append(")...").toString());
            Object object = this.archiveInProgressLock();
            synchronized (object) {
                int archivedReleasesCount = this.findAndProcessArchivableReleases(expirationDate, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)s -> {
                    this.archiveCompletedRelease(s);
                    return BoxedUnit.UNIT;
                });
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Archived ").append(archivedReleasesCount).append(" releases in ").append(System.currentTimeMillis() - startArchiving).append(" ms").toString());
            }
        } else {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> "Archiving is not enabled.");
        }
    }

    @Timed
    public void archiveExpiredReleases() {
        this.archiveExpiredReleases(this.archivingConfig().getReleaseAgeToDeleteFromJcr());
    }

    private int findAndProcessArchivableReleases(Date date, Function1<String, BoxedUnit> action) {
        AtomicInteger count;
        block3: {
            long runStartTimeMillis = System.currentTimeMillis();
            count = new AtomicInteger(0);
            boolean done = false;
            while (!done && !this.isCancelRequested().get()) {
                int archivingPageSize = this.getSearchPageSize();
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Fetching ").append(archivingPageSize).append(" completed or aborted releases from repository").toString());
                Seq<String> releaseIds = this.archivingService().findArchivableReleaseIds(date, Predef$.MODULE$.int2Integer(archivingPageSize));
                if (releaseIds.nonEmpty() && count.get() == 0) {
                    this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Archiving releases that completed before ").append(date).toString());
                }
                if (done = this.processReleases((Iterable<String>)releaseIds, count, runStartTimeMillis, action)) continue;
                if (releaseIds.isEmpty() || releaseIds.size() < archivingPageSize) {
                    this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Processed only ").append(releaseIds.size()).append(" finished releases on this page: we're done.").toString());
                    done = true;
                    continue;
                }
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Archived ").append(count.get()).append(" releases that completed before ").append(date).append(", fetching the next ").append(archivingPageSize).toString());
            }
            if (count.get() <= 0) break block3;
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Archived ").append(count.get()).append(" releases that completed before ").append(date).toString());
        }
        return count.get();
    }

    private boolean processReleases(Iterable<String> releaseIds, AtomicInteger count, long runStartTimeMillis, Function1<String, BoxedUnit> action) {
        boolean bl;
        Object object = new Object();
        try {
            releaseIds.foreach((Function1 & Serializable & scala.Serializable)releaseId -> {
                ArchivingScheduleService.$anonfun$processReleases$1(this, object, count, action, runStartTimeMillis, releaseId);
                return BoxedUnit.UNIT;
            });
            bl = false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    private Try<BoxedUnit> archiveCompletedRelease(String releaseId) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Archiving release [").append(releaseId).append("]").toString());
            long s = System.currentTimeMillis();
            this.archivingService().archiveRelease(releaseId);
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Archived release [").append(releaseId).append("] in ").append(System.currentTimeMillis() - s).append(" ms").toString());
        }).recoverWith((PartialFunction)new scala.Serializable(this, releaseId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArchivingScheduleService $outer;
            private final String releaseId$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Exception) {
                    Exception exception = (Exception)A1;
                    this.$outer.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Could not archive release [").append($this.releaseId$1).append("]: ").append(exception.getMessage()).toString(), (Function0 & Serializable & scala.Serializable)() -> exception);
                    object = new Failure((Throwable)exception);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof Exception;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.releaseId$1 = releaseId$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.xebialabs.xlrelease.service.ArchivingScheduleService$$anonfun$archiveCompletedRelease$4 java.lang.Exception ), $anonfun$applyOrElse$2(java.lang.Exception )}, serializedLambda);
            }
        });
    }

    private int getSearchPageSize() {
        return Predef$.MODULE$.Integer2int(this.archivingConfig().getSearchPageSize()) > 0 ? Predef$.MODULE$.Integer2int(this.archivingConfig().getSearchPageSize()) : 20;
    }

    private void sleepIfNeeded() {
        block2: {
            if (Predef$.MODULE$.Integer2int(this.archivingConfig().getSleepSecondsBetweenReleases()) <= 0) break block2;
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Sleeping for ").append(this.archivingConfig().getSleepSecondsBetweenReleases()).append(" seconds before archiving the next release").toString());
            try {
                Thread.sleep(Predef$.MODULE$.Integer2int(this.archivingConfig().getSleepSecondsBetweenReleases()) * 1000);
            }
            catch (InterruptedException interruptedException) {
                this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Sleeping for ").append(this.archivingConfig().getSleepSecondsBetweenReleases()).append(" seconds was interrupted").toString());
            }
        }
    }

    private boolean ranTooLong(long runStartTimeMillis) {
        return Predef$.MODULE$.Integer2int(this.archivingConfig().getMaxSecondsPerRun()) > 0 ? System.currentTimeMillis() - runStartTimeMillis > (long)(Predef$.MODULE$.Integer2int(this.archivingConfig().getMaxSecondsPerRun()) * 1000) : false;
    }

    private void off() {
        this.isCancelRequested().set(true);
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Waiting until no archiving is in progress");
        Object object = this.archiveInProgressLock();
        synchronized (object) {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Archiving done, destroying ArchivingScheduleService");
        }
    }

    @PreDestroy
    private void preDestroy() {
        this.off();
    }

    public static final /* synthetic */ void $anonfun$processReleases$1(ArchivingScheduleService $this, Object nonLocalReturnKey1$1, AtomicInteger count$2, Function1 action$1, long runStartTimeMillis$1, String releaseId) {
        if ($this.isCancelRequested().get()) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
        }
        if (count$2.get() > 0) {
            $this.sleepIfNeeded();
        }
        action$1.apply((Object)releaseId);
        count$2.incrementAndGet();
        if ($this.ranTooLong(runStartTimeMillis$1)) {
            $this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(95).append("Archiving paused because it ran for more than ").append($this.archivingConfig().getMaxSecondsPerRun()).append(" seconds. ").append("Archiving will continue in the next run").toString());
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
        }
    }

    @Autowired
    public ArchivingScheduleService(ArchivingService archivingService, ArchivingSettingsManager archivingConfig) {
        this.archivingService = archivingService;
        this.archivingConfig = archivingConfig;
        Logging.$init$((Logging)this);
        this.isCancelRequested = new AtomicBoolean(false);
        this.archiveInProgressLock = new Object();
    }
}

