/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.events;

import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.events.XLReleaseEventListener;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class EventListenerRegister {
    private static final Logger logger = LoggerFactory.getLogger(EventListenerRegister.class);
    @Resource(name="eventFactoryBean")
    private List<XLReleaseEventListener> eventListeners;
    @Autowired
    private XLReleaseEventBus eventBus;

    @org.springframework.context.event.EventListener(value={ContextRefreshedEvent.class})
    public void registerEventListeners(ContextRefreshedEvent event) {
        logger.info("Start registering event listeners...");
        ApplicationContext ctx = event.getApplicationContext();
        Map listeners = ctx.getBeansWithAnnotation(EventListener.class);
        listeners.forEach((key, listener) -> this.eventBus.register(listener));
        this.eventListeners.forEach(listener -> {
            ctx.getAutowireCapableBeanFactory().autowireBean(listener);
            this.eventBus.register(listener);
        });
        logger.info("Event listeners successfully registered");
    }
}

