/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Objects;
import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateCondition;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.DependencyService;
import com.xebialabs.xlrelease.service.GateConditionService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.views.DependencyView;
import com.xebialabs.xlrelease.views.GateConditionView;
import com.xebialabs.xlrelease.views.PlanItemView;
import com.xebialabs.xlrelease.views.ReleaseView;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/gates")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class GatesResource {
    private ReleaseActorService releaseActorService;
    private GateConditionService conditions;
    private ReleaseService releaseService;
    private PermissionChecker permissions;
    private DependencyService dependencyService;

    @Autowired
    public GatesResource(ReleaseActorService releaseActorService, GateConditionService conditions, ReleaseService releaseService, PermissionChecker permissions, DependencyService dependencyService) {
        this.releaseActorService = releaseActorService;
        this.conditions = conditions;
        this.releaseService = releaseService;
        this.permissions = permissions;
        this.dependencyService = dependencyService;
    }

    @PUT
    @Timed
    @Path(value="conditions/{conditionId:.*Condition[^/-]*}")
    public GateConditionView updateCondition(@PathParam(value="conditionId") @IdParam String conditionId, GateConditionView conditionView) {
        Release release = this.releaseService.findById(Ids.releaseIdFrom((String)conditionId));
        if (release.isTemplate()) {
            this.permissions.check(XLReleasePermissions.EDIT_TEMPLATE, release);
        } else {
            this.permissions.checkIsAllowedToWorkOnTask(Ids.getParentId((String)conditionId));
            GateCondition previousCondition = this.conditions.findById(conditionId);
            if (!Objects.equal((Object)previousCondition.getTitle(), (Object)conditionView.toCondition().getTitle())) {
                this.permissions.check(XLReleasePermissions.EDIT_RELEASE_TASK, release);
            }
        }
        return new GateConditionView(this.releaseActorService.updateGateCondition(conditionId, conditionView.toCondition()));
    }

    @POST
    @Timed
    @Path(value="{gateId:.*Task[^/-]*}/conditions")
    public GateConditionView createCondition(@PathParam(value="gateId") @IdParam String gateId) {
        this.permissions.checkEditTask(Ids.releaseIdFrom((String)gateId));
        GateCondition gateCondition = this.releaseActorService.createGateCondition(gateId);
        return new GateConditionView(gateCondition);
    }

    @DELETE
    @Timed
    @Path(value="conditions/{conditionId:.*Condition[^/-]*}")
    public void deleteCondition(@PathParam(value="conditionId") @IdParam String conditionId) {
        this.permissions.checkEditTask(Ids.releaseIdFrom((String)conditionId));
        this.releaseActorService.deleteGateCondition(conditionId);
    }

    @POST
    @Timed
    @Path(value="{gateId:.*Task[^/-]*}/dependencies")
    public DependencyView addDependency(@PathParam(value="gateId") @IdParam String gateId, DependencyView dependencyView) {
        this.permissions.checkEditTask(Ids.releaseIdFrom((String)gateId));
        if (dependencyView.hasFixedTarget()) {
            this.permissions.checkView(Ids.releaseIdFrom((String)dependencyView.toTargetId()));
        }
        Dependency dependency = this.releaseActorService.createDependency(gateId, dependencyView.toTargetIdOrVariable());
        return new DependencyView(dependency);
    }

    @GET
    @Timed
    @Path(value="{gateId:.*Task[^/-]*}/dependency-target-candidates")
    public List<PlanItemView> getDependencyTargetCandidates(@PathParam(value="gateId") @IdParam String gateId) {
        List<Release> dependencyTargetCandidates = this.dependencyService.findAllDependencyCandidates(gateId);
        return dependencyTargetCandidates.stream().map(PlanItemView::new).collect(Collectors.toList());
    }

    @GET
    @Timed
    @Path(value="{gateId:.*Task[^/-]*}/dependency-target-candidates/{releaseId:.*Release[^/-]*}")
    public ReleaseView loadDependencyTargetCandidate(@PathParam(value="gateId") @IdParam String gateId, @PathParam(value="releaseId") @IdParam String releaseId) {
        this.permissions.checkView(releaseId);
        return new ReleaseView(this.dependencyService.getDependencyCandidate(gateId, releaseId));
    }
}

