/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.forms.FacetFilters;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.FacetCreatedEvent;
import com.xebialabs.xlrelease.domain.events.FacetDeletedEvent;
import com.xebialabs.xlrelease.domain.events.FacetUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.domain.facet.FacetScope;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.TypeHelper$;
import com.xebialabs.xlrelease.repository.VariableRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005}f\u0001B\u0001\u0003\u0001-\u0011ABR1dKR\u001cVM\u001d<jG\u0016T!a\u0001\u0003\u0002\u000fM,'O^5dK*\u0011QAB\u0001\nq2\u0014X\r\\3bg\u0016T!a\u0002\u0005\u0002\u0013a,'-[1mC\n\u001c(\"A\u0005\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001a!\u0003\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003'ai\u0011\u0001\u0006\u0006\u0003+Y\tQa\u001d7gi)T\u0011aF\u0001\tOJL'P\u001f7fI&\u0011\u0011\u0004\u0006\u0002\b\u0019><w-\u001b8h\u0011!Y\u0002A!A!\u0002\u0013a\u0012a\u00044bG\u0016$(+\u001a9pg&$xN]=\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}!\u0011A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011\u0011E\b\u0002\u0010\r\u0006\u001cW\r\u001e*fa>\u001c\u0018\u000e^8ss\"A1\u0005\u0001B\u0001B\u0003%A%\u0001\buCN\\'+\u001a9pg&$xN]=\u0011\u0005u)\u0013B\u0001\u0014\u001f\u00059!\u0016m]6SKB|7/\u001b;pefD\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!K\u0001\tKZ,g\u000e\u001e\"vgB\u0011!&L\u0007\u0002W)\u0011A\u0006B\u0001\u0007KZ,g\u000e^:\n\u00059Z#!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\"A\u0001\u0007\u0001B\u0001B\u0003%\u0011'\u0001\tbe\u000eD\u0017N^5oON+'O^5dKB\u0011!gM\u0007\u0002\u0005%\u0011AG\u0001\u0002\u0011\u0003J\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016D\u0001B\u000e\u0001\u0003\u0002\u0003\u0006IaN\u0001\u0012e\u0016dW-Y:f%\u0016\u0004xn]5u_JL\bCA\u000f9\u0013\tIdDA\tSK2,\u0017m]3SKB|7/\u001b;pefD\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001P\u0001\fG&LEmU3sm&\u001cW\r\u0005\u00023{%\u0011aH\u0001\u0002\f\u0007&LEmU3sm&\u001cW\r\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0003I1\u0018M]5bE2,'+\u001a9pg&$xN]=\u0011\u0005u\u0011\u0015BA\"\u001f\u0005I1\u0016M]5bE2,'+\u001a9pg&$xN]=\t\u0011\u0015\u0003!\u0011!Q\u0001\n\u0019\u000b1C]3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016\u0004\"a\u0012&\u000e\u0003!S!!\u0013\u0003\u0002\r\u0005\u001cGo\u001c:t\u0013\tY\u0005JA\nSK2,\u0017m]3BGR|'oU3sm&\u001cW\rC\u0003N\u0001\u0011\u0005a*\u0001\u0004=S:LGO\u0010\u000b\n\u001fB\u000b&k\u0015+V-^\u0003\"A\r\u0001\t\u000bma\u0005\u0019\u0001\u000f\t\u000b\rb\u0005\u0019\u0001\u0013\t\u000b!b\u0005\u0019A\u0015\t\u000bAb\u0005\u0019A\u0019\t\u000bYb\u0005\u0019A\u001c\t\u000bmb\u0005\u0019\u0001\u001f\t\u000b\u0001c\u0005\u0019A!\t\u000b\u0015c\u0005\u0019\u0001$)\u00051K\u0006C\u0001.f\u001b\u0005Y&B\u0001/^\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003=~\u000bqAZ1di>\u0014\u0018P\u0003\u0002aC\u0006)!-Z1og*\u0011!mY\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tA-A\u0002pe\u001eL!AZ.\u0003\u0013\u0005+Ho\\<je\u0016$\u0007\"\u00025\u0001\t\u0003I\u0017aA4fiR\u0011!N\u001d\t\u0003WBl\u0011\u0001\u001c\u0006\u0003[:\fQAZ1dKRT!a\u001c\u0003\u0002\r\u0011|W.Y5o\u0013\t\tHNA\u0003GC\u000e,G\u000fC\u0003tO\u0002\u0007A/A\u0004gC\u000e,G/\u00133\u0011\u0005UdhB\u0001<{!\t9h\"D\u0001y\u0015\tI(\"\u0001\u0004=e>|GOP\u0005\u0003w:\ta\u0001\u0015:fI\u00164\u0017BA?\u007f\u0005\u0019\u0019FO]5oO*\u00111P\u0004\u0015\u0004O\u0006\u0005\u0001\u0003BA\u0002\u0003\u001fi!!!\u0002\u000b\u0007q\u000b9A\u0003\u0003\u0002\n\u0005-\u0011aB7fiJL7m\u001d\u0006\u0004\u0003\u001bA\u0011\u0001C2pI\u0006D\u0017\r\\3\n\t\u0005E\u0011Q\u0001\u0002\u0006)&lW\r\u001a\u0005\b\u0003+\u0001A\u0011AA\f\u0003\u0019\u0019'/Z1uKR\u0019!.!\u0007\t\r5\f\u0019\u00021\u0001kQ\u0011\t\u0019\"!\u0001\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"\u00051A-\u001a7fi\u0016$B!a\t\u0002*A\u0019Q\"!\n\n\u0007\u0005\u001dbB\u0001\u0003V]&$\bBB:\u0002\u001e\u0001\u0007A\u000f\u000b\u0003\u0002\u001e\u0005\u0005\u0001bBA\u0018\u0001\u0011\u0005\u0011\u0011G\u0001\u0007kB$\u0017\r^3\u0015\u0007)\f\u0019\u0004\u0003\u0004n\u0003[\u0001\rA\u001b\u0015\u0005\u0003[\t\t\u0001C\u0004\u0002:\u0001!\t!a\u000f\u0002\rM,\u0017M]2i)\u0011\ti$!\u0014\u0011\u000b\u0005}\u0012\u0011\n6\u000e\u0005\u0005\u0005#\u0002BA\"\u0003\u000b\nA!\u001e;jY*\u0011\u0011qI\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002L\u0005\u0005#\u0001\u0002'jgRD\u0001\"a\u0014\u00028\u0001\u0007\u0011\u0011K\u0001\bM&dG/\u001a:t!\u0011\t\u0019&!\u0019\u000e\u0005\u0005U#\u0002BA,\u00033\nQAZ8s[NTA!a\u0017\u0002^\u0005\u0011a/\r\u0006\u0004\u0003?\"\u0011aA1qS&!\u00111MA+\u000511\u0015mY3u\r&dG/\u001a:tQ\u0011\t9$!\u0001\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l\u00051Q\r_5tiN$B!!\u001c\u0002tA\u0019Q\"a\u001c\n\u0007\u0005EdBA\u0004C_>dW-\u00198\t\rM\f9\u00071\u0001uQ\u0011\t9'!\u0001\t\u000f\u0005e\u0004\u0001\"\u0003\u0002|\u0005\u00112M]3bi\u0016tUm\u001e,be&\f'\r\\3t)\u0019\t\u0019#! \u0002\n\"A\u0011qPA<\u0001\u0004\t\t)A\u0004sK2,\u0017m]3\u0011\t\u0005\r\u0015QQ\u0007\u0002]&\u0019\u0011q\u00118\u0003\u000fI+G.Z1tK\"1Q.a\u001eA\u0002)Dq!!$\u0001\t\u0013\ty)A\ftK\u0006\u00148\r[%o\u0003J\u001c\u0007.\u001b<fIJ+G.Z1tKR1\u0011\u0011SAR\u0003O\u0003R!a%\u0002\u001e*tA!!&\u0002\u001a:\u0019q/a&\n\u0003=I1!a'\u000f\u0003\u001d\u0001\u0018mY6bO\u0016LA!a(\u0002\"\n\u00191+Z9\u000b\u0007\u0005me\u0002C\u0004\u0002&\u0006-\u0005\u0019\u0001;\u0002\u0013I,G.Z1tK&#\u0007\u0002CA(\u0003\u0017\u0003\r!!\u0015\t\u000f\u0005-\u0006\u0001\"\u0003\u0002.\u0006Aa/\u00197jI\u0006$X\r\u0006\u0003\u0002$\u0005=\u0006BB7\u0002*\u0002\u0007!\u000eK\u0002\u0001\u0003g\u0003B!!.\u0002<6\u0011\u0011q\u0017\u0006\u0004\u0003s\u000b\u0017AC:uKJ,w\u000e^=qK&!\u0011QXA\\\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class FacetService
implements Logging {
    private final FacetRepository facetRepository;
    private final TaskRepository taskRepository;
    private final XLReleaseEventBus eventBus;
    private final ArchivingService archivingService;
    private final CiIdService ciIdService;
    private final ReleaseActorService releaseActorService;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        FacetService facetService = this;
        synchronized (facetService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public Facet get(String facetId) {
        return this.facetRepository.get(facetId);
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Facet create(Facet facet) {
        void var2_2;
        this.validate(facet);
        Facet createdFacet = this.facetRepository.create(facet);
        Object task = this.taskRepository.findById(facet.getTargetId());
        this.createNewVariables(task.getRelease(), createdFacet);
        this.eventBus.publish((XLReleaseEvent)new FacetCreatedEvent(createdFacet));
        return var2_2;
    }

    @Timed
    public void delete(String facetId) {
        Facet facet = this.facetRepository.get(facetId);
        this.facetRepository.delete(facetId);
        this.eventBus.publish((XLReleaseEvent)new FacetDeletedEvent(facet));
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Facet update(Facet facet) {
        void var3_3;
        this.validate(facet);
        Facet originalFacet = this.facetRepository.get(facet.getId());
        Facet updatedFacet = this.facetRepository.update(facet);
        Object task = this.taskRepository.findById(facet.getTargetId());
        this.createNewVariables(task.getRelease(), updatedFacet);
        this.eventBus.publish((XLReleaseEvent)new FacetUpdatedEvent(originalFacet, updatedFacet));
        return var3_3;
    }

    @Timed
    public List<Facet> search(FacetFilters filters) {
        filters.validate();
        filters.setTypes((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Option$.MODULE$.apply(filters.getTypes()).map((Function1 & Serializable & scala.Serializable)x$1 -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$1).asScala()).flatMap((Function1 & Serializable & scala.Serializable)ciType -> TypeHelper$.MODULE$.getAllSubtypesOf(ciType), Buffer$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty())).asJava());
        String containerId = filters.getParentId() != null ? filters.getParentId() : filters.getTargetId();
        return this.archivingService.exists(Ids.releaseIdFrom((String)containerId)) ? (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.searchInArchivedRelease(Ids.releaseIdFrom((String)containerId), filters)).asJava() : (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.facetRepository.search(filters)).asJava();
    }

    @Timed
    public boolean exists(String facetId) {
        return this.facetRepository.exists(facetId);
    }

    private void createNewVariables(Release release, Facet facet) {
        block0: {
            Buffer newVariables = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)facet, this.ciIdService)).asScala();
            if (!newVariables.nonEmpty()) break block0;
            newVariables.foreach((Function1 & Serializable & scala.Serializable)v -> $this.releaseActorService.createVariable((Variable)v, release.getId()));
        }
    }

    private Seq<Facet> searchInArchivedRelease(String releaseId, FacetFilters filters) {
        Release release = this.archivingService.getRelease(releaseId);
        return ((TraversableOnce)((TraversableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllTasks()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)FacetService.$anonfun$searchInArchivedRelease$1(filters, x$2)))).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$3.getFacets()).asScala(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)facet -> BoxesRunTime.boxToBoolean((boolean)FacetService.$anonfun$searchInArchivedRelease$3(filters, facet)))).toList();
    }

    private void validate(Facet facet) {
        FacetScope facetScope = facet.getScope();
        if (!FacetScope.TASK.equals(facetScope)) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Target type ", " is not supported."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{facet.getScope()})));
        }
        Checks.checkArgument((boolean)Ids.isTaskId((String)facet.getTargetId()), (String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Target ID is not a valid task ID."})).s((Seq)Nil$.MODULE$), (Object[])new Object[0]);
        Checks.checkArgument((boolean)this.taskRepository.exists(facet.getTargetId()), (String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task with the ID '", "' does not exist or has been archived."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{facet.getTargetId()})), (Object[])new Object[0]);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$searchInArchivedRelease$1(FacetFilters filters$1, Task x$2) {
        String string = x$2.getId();
        String string2 = filters$1.getTargetId();
        return !(string == null ? string2 != null : !string.equals(string2)) || !filters$1.hasTargetId();
    }

    public static final /* synthetic */ boolean $anonfun$searchInArchivedRelease$3(FacetFilters filters$1, Facet facet) {
        return filters$1.getTypes().isEmpty() || filters$1.getTypes().contains(facet.getType());
    }

    @Autowired
    public FacetService(FacetRepository facetRepository, TaskRepository taskRepository, XLReleaseEventBus eventBus, ArchivingService archivingService, ReleaseRepository releaseRepository, CiIdService ciIdService, VariableRepository variableRepository, ReleaseActorService releaseActorService) {
        this.facetRepository = facetRepository;
        this.taskRepository = taskRepository;
        this.eventBus = eventBus;
        this.archivingService = archivingService;
        this.ciIdService = ciIdService;
        this.releaseActorService = releaseActorService;
        Logging.$init$((Logging)this);
    }
}

