/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.authentication;

import com.xebialabs.xlrelease.repository.CustomPersistentTokenRepository;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.authentication.rememberme.AbstractRememberMeServices;
import org.springframework.security.web.authentication.rememberme.CookieTheftException;
import org.springframework.security.web.authentication.rememberme.InvalidCookieException;
import org.springframework.security.web.authentication.rememberme.PersistentRememberMeToken;
import org.springframework.security.web.authentication.rememberme.RememberMeAuthenticationException;
import org.springframework.util.Assert;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005g\u0001B\u0001\u0003\u0001-\u00111\u0005\u00177QKJ\u001c\u0018n\u001d;f]R$vn[3o%\u0016lW-\u001c2fe6+7+\u001a:wS\u000e,7O\u0003\u0002\u0004\t\u0005q\u0011-\u001e;iK:$\u0018nY1uS>t'BA\u0003\u0007\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\b\u0011\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002\u0013\u0005\u00191m\\7\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001bei\u0011A\u0004\u0006\u0003\u001fA\t!B]3nK6\u0014WM]7f\u0015\t\u0019\u0011C\u0003\u0002\u0013'\u0005\u0019q/\u001a2\u000b\u0005Q)\u0012\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005Y9\u0012aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003a\t1a\u001c:h\u0013\tQbB\u0001\u000eBEN$(/Y2u%\u0016lW-\u001c2fe6+7+\u001a:wS\u000e,7\u000f\u0003\u0005\u001d\u0001\t\u0005\t\u0015!\u0003\u001e\u0003\rYW-\u001f\t\u0003=\u001dr!aH\u0013\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\tR\u0011A\u0002\u001fs_>$hHC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13%\u0001\u0004Qe\u0016$WMZ\u0005\u0003Q%\u0012aa\u0015;sS:<'B\u0001\u0014$\u0011!Y\u0003A!A!\u0002\u0013a\u0013AE;tKJ$U\r^1jYN\u001cVM\u001d<jG\u0016\u0004\"!\f\u001a\u000e\u00039R!a\f\u0019\u0002\u0017U\u001cXM\u001d3fi\u0006LGn\u001d\u0006\u0003cM\tAaY8sK&\u00111G\f\u0002\u0013+N,'\u000fR3uC&d7oU3sm&\u001cW\r\u0003\u00056\u0001\t\u0005\t\u0015!\u00037\u0003=!xn[3o%\u0016\u0004xn]5u_JL\bCA\u001c;\u001b\u0005A$BA\u001d\u0005\u0003)\u0011X\r]8tSR|'/_\u0005\u0003wa\u0012qdQ;ti>l\u0007+\u001a:tSN$XM\u001c;U_.,gNU3q_NLGo\u001c:z\u0011\u0015i\u0004\u0001\"\u0001?\u0003\u0019a\u0014N\\5u}Q!q(\u0011\"D!\t\u0001\u0005!D\u0001\u0003\u0011\u0015aB\b1\u0001\u001e\u0011\u0015YC\b1\u0001-\u0011\u0015)D\b1\u00017\u0011\u001d)\u0005A1A\u0005\n\u0019\u000bQ\u0003R#G\u0003VcEkX*F%&+5k\u0018'F\u001d\u001e#\u0006*F\u0001H!\tA\u0015*D\u0001$\u0013\tQ5EA\u0002J]RDa\u0001\u0014\u0001!\u0002\u00139\u0015A\u0006#F\r\u0006+F\nV0T\u000bJKUiU0M\u000b:;E\u000b\u0013\u0011\t\u000f9\u0003!\u0019!C\u0005\r\u0006!B)\u0012$B+2#v\fV(L\u000b:{F*\u0012(H)\"Ca\u0001\u0015\u0001!\u0002\u00139\u0015!\u0006#F\r\u0006+F\nV0U\u001f.+ej\u0018'F\u001d\u001e#\u0006\n\t\u0005\b%\u0002\u0001\r\u0011\"\u0003G\u00031\u0019XM]5fg2+gn\u001a;i\u0011\u001d!\u0006\u00011A\u0005\nU\u000b\u0001c]3sS\u0016\u001cH*\u001a8hi\"|F%Z9\u0015\u0005YK\u0006C\u0001%X\u0013\tA6E\u0001\u0003V]&$\bb\u0002.T\u0003\u0003\u0005\raR\u0001\u0004q\u0012\n\u0004B\u0002/\u0001A\u0003&q)A\u0007tKJLWm\u001d'f]\u001e$\b\u000e\t\u0005\b=\u0002\u0001\r\u0011\"\u0003G\u0003-!xn[3o\u0019\u0016tw\r\u001e5\t\u000f\u0001\u0004\u0001\u0019!C\u0005C\u0006yAo\\6f]2+gn\u001a;i?\u0012*\u0017\u000f\u0006\u0002WE\"9!lXA\u0001\u0002\u00049\u0005B\u00023\u0001A\u0003&q)\u0001\u0007u_.,g\u000eT3oORD\u0007\u0005C\u0004g\u0001\t\u0007I\u0011B4\u0002\rI\fg\u000eZ8n+\u0005A\u0007CA5n\u001b\u0005Q'B\u0001\u000bl\u0015\u0005a\u0017\u0001\u00026bm\u0006L!A\u001c6\u0003\u0019M+7-\u001e:f%\u0006tGm\\7\t\rA\u0004\u0001\u0015!\u0003i\u0003\u001d\u0011\u0018M\u001c3p[\u0002BQA\u001d\u0001\u0005\nM\faaZ8QCN$Hc\u0001;{yB\u0011Q\u000f_\u0007\u0002m*\u0011qo[\u0001\u0005kRLG.\u0003\u0002zm\n!A)\u0019;f\u0011\u0015Y\u0018\u000f1\u0001u\u0003%9\u0017N^3o\t\u0006$X\rC\u0003~c\u0002\u0007a0\u0001\u0005uS6,\u0017J\\'t!\tAu0C\u0002\u0002\u0002\r\u0012A\u0001T8oO\"9\u0011Q\u0001\u0001\u0005\n\u0005\u001d\u0011\u0001C4p\rV$XO]3\u0015\u000bQ\fI!a\u0003\t\rm\f\u0019\u00011\u0001u\u0011\u0019i\u00181\u0001a\u0001}\"9\u0011q\u0002\u0001\u0005B\u0005E\u0011AD8o\u0019><\u0017N\\*vG\u000e,7o\u001d\u000b\b-\u0006M\u00111FA\u001b\u0011!\t)\"!\u0004A\u0002\u0005]\u0011a\u0002:fcV,7\u000f\u001e\t\u0005\u00033\t9#\u0004\u0002\u0002\u001c)!\u0011QDA\u0010\u0003\u0011AG\u000f\u001e9\u000b\t\u0005\u0005\u00121E\u0001\bg\u0016\u0014h\u000f\\3u\u0015\t\t)#A\u0003kCZ\f\u00070\u0003\u0003\u0002*\u0005m!A\u0005%uiB\u001cVM\u001d<mKR\u0014V-];fgRD\u0001\"!\f\u0002\u000e\u0001\u0007\u0011qF\u0001\te\u0016\u001c\bo\u001c8tKB!\u0011\u0011DA\u0019\u0013\u0011\t\u0019$a\u0007\u0003'!#H\u000f]*feZdW\r\u001e*fgB|gn]3\t\u0011\u0005]\u0012Q\u0002a\u0001\u0003s\t\u0001d];dG\u0016\u001c8OZ;m\u0003V$\b.\u001a8uS\u000e\fG/[8o!\u0011\tY$!\u0010\u000e\u0003AJ1!a\u00101\u00059\tU\u000f\u001e5f]RL7-\u0019;j_:Dq!a\u0011\u0001\t\u0003\n)%\u0001\fqe>\u001cWm]:BkR|Gj\\4j]\u000e{wn[5f)!\t9%!\u0014\u0002X\u0005e\u0003cA\u0017\u0002J%\u0019\u00111\n\u0018\u0003\u0017U\u001bXM\u001d#fi\u0006LGn\u001d\u0005\t\u0003\u001f\n\t\u00051\u0001\u0002R\u0005a1m\\8lS\u0016$vn[3ogB!\u0001*a\u0015\u001e\u0013\r\t)f\t\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\t\u0003+\t\t\u00051\u0001\u0002\u0018!A\u0011QFA!\u0001\u0004\ty\u0003C\u0004\u0002^\u0001!\t%a\u0018\u0002\r1|wm\\;u)\u001d1\u0016\u0011MA2\u0003KB\u0001\"!\u0006\u0002\\\u0001\u0007\u0011q\u0003\u0005\t\u0003[\tY\u00061\u0001\u00020!91!a\u0017A\u0002\u0005e\u0002bBA5\u0001\u0011E\u00111N\u0001\u0013O\u0016tWM]1uKN+'/[3t\t\u0006$\u0018-F\u0001\u001e\u0011\u001d\ty\u0007\u0001C\t\u0003W\n\u0011cZ3oKJ\fG/\u001a+pW\u0016tG)\u0019;b\u0011\u001d\t\u0019\b\u0001C\u0005\u0003k\n\u0011\"\u00193e\u0007>|7.[3\u0015\u000fY\u000b9(!!\u0002\u0004\"A\u0011\u0011PA9\u0001\u0004\tY(A\u0003u_.,g\u000eE\u0002\u000e\u0003{J1!a \u000f\u0005e\u0001VM]:jgR,g\u000e\u001e*f[\u0016l'-\u001a:NKR{7.\u001a8\t\u0011\u0005U\u0011\u0011\u000fa\u0001\u0003/A\u0001\"!\f\u0002r\u0001\u0007\u0011q\u0006\u0005\b\u0003\u000f\u0003A\u0011AAE\u0003=\u0019X\r^*fe&,7\u000fT3oORDGc\u0001,\u0002\f\"1!+!\"A\u0002\u001dCq!a$\u0001\t\u0003\t\t*\u0001\btKR$vn[3o\u0019\u0016tw\r\u001e5\u0015\u0007Y\u000b\u0019\n\u0003\u0004_\u0003\u001b\u0003\ra\u0012\u0005\b\u0003/\u0003A\u0011IAM\u0003]\u0019X\r\u001e+pW\u0016tg+\u00197jI&$\u0018pU3d_:$7\u000fF\u0002W\u00037Cq!!(\u0002\u0016\u0002\u0007q)\u0001\u000bu_.,gNV1mS\u0012LG/_*fG>tGm\u001d\u0005\r\u0003C\u0003\u0001\u0013!A\u0001\u0002\u0013\u0005\u00111U\u0001\u0018aJ|G/Z2uK\u0012$s-\u001a;D_>\\\u0017.\u001a(b[\u0016$B!!*\u00022R\u0011\u0011q\u0015\t\u0005\u0003S\u000by+\u0004\u0002\u0002,*\u0019\u0011QV6\u0002\t1\fgnZ\u0005\u0004Q\u0005-\u0006\u0002\u0003.\u0002 \u0006\u0005\t\u0019A \t\u0019\u0005U\u0006\u0001%A\u0001\u0002\u0003%\t!a.\u0002-A\u0014x\u000e^3di\u0016$G\u0005Z3d_\u0012,7i\\8lS\u0016$B!!/\u0002@R!\u00111XA_!\u0015A\u00151KAT\u0011%Q\u00161WA\u0001\u0002\u0004\t9\u000b\u0003\u0005[\u0003g\u000b\t\u00111\u0001@\u0001")
public class XlPersistentTokenRememberMeServices
extends AbstractRememberMeServices {
    private final CustomPersistentTokenRepository tokenRepository;
    private final int DEFAULT_SERIES_LENGTH;
    private final int DEFAULT_TOKEN_LENGTH;
    private int seriesLength;
    private int tokenLength;
    private final SecureRandom random;

    public /* synthetic */ String protected$getCookieName(XlPersistentTokenRememberMeServices x$1) {
        return x$1.getCookieName();
    }

    public /* synthetic */ String[] protected$decodeCookie(XlPersistentTokenRememberMeServices x$1, String x$12) {
        return x$1.decodeCookie(x$12);
    }

    private int DEFAULT_SERIES_LENGTH() {
        return this.DEFAULT_SERIES_LENGTH;
    }

    private int DEFAULT_TOKEN_LENGTH() {
        return this.DEFAULT_TOKEN_LENGTH;
    }

    private int seriesLength() {
        return this.seriesLength;
    }

    private void seriesLength_$eq(int x$1) {
        this.seriesLength = x$1;
    }

    private int tokenLength() {
        return this.tokenLength;
    }

    private void tokenLength_$eq(int x$1) {
        this.tokenLength = x$1;
    }

    private SecureRandom random() {
        return this.random;
    }

    private Date goPast(Date givenDate, long timeInMs) {
        long givenTimeInMs = givenDate.getTime();
        long pastTime = givenTimeInMs - timeInMs;
        return new Date(pastTime);
    }

    private Date goFuture(Date givenDate, long timeInMs) {
        long givenTimeInMs = givenDate.getTime();
        long futureTime = givenTimeInMs + timeInMs;
        return new Date(futureTime);
    }

    public void onLoginSuccess(HttpServletRequest request, HttpServletResponse response, Authentication successfulAuthentication) {
        String username = successfulAuthentication.getName();
        this.logger.debug((Object)("Creating new persistent login for user " + username));
        PersistentRememberMeToken persistentToken = new PersistentRememberMeToken(username.toLowerCase(), this.generateSeriesData(), this.generateTokenData(), new Date());
        try {
            this.tokenRepository.createNewToken(persistentToken);
            this.addCookie(persistentToken, request, response);
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to save persistent token ", (Throwable)e);
        }
    }

    public UserDetails processAutoLoginCookie(String[] cookieTokens, HttpServletRequest request, HttpServletResponse response) {
        if (cookieTokens.length != 2) {
            throw new InvalidCookieException("Cookie token did not contain " + 2 + " tokens, but contained '" + Arrays.asList((Object[])new String[][]{cookieTokens}) + "'");
        }
        String presentedSeries = cookieTokens[0];
        String presentedToken = cookieTokens[1];
        PersistentRememberMeToken token = this.tokenRepository.getTokenForSeries(presentedSeries);
        if (token == null) {
            throw new RememberMeAuthenticationException("No persistent token found for series id: " + presentedSeries);
        }
        String string = presentedToken;
        String string2 = token.getTokenValue();
        if (string == null ? string2 != null : !string.equals(string2)) {
            List<PersistentRememberMeToken> previousTokenList = this.tokenRepository.getPreviousTokenForSeries(presentedSeries, token.getTokenValue());
            Optional<PersistentRememberMeToken> previousOldToken = previousTokenList.stream().filter(previousToken -> {
                String string = previousToken.getTokenValue();
                String string2 = presentedToken;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }).findFirst();
            if (!previousOldToken.isPresent()) {
                this.tokenRepository.removeUserTokens(token.getUsername());
                throw new CookieTheftException(this.messages.getMessage("PersistentTokenBasedRememberMeServices.cookieStolen", "Invalid remember-me token (Series/token) mismatch. Implies previous cookie theft attack."));
            }
            this.tokenRepository.removeTokenInSeriesBeforeGivenDate(token.getSeries(), this.goPast(previousOldToken.get().getDate(), 60000L));
        }
        if (this.goFuture(token.getDate(), (long)this.getTokenValiditySeconds() * 1000L).getTime() < System.currentTimeMillis()) {
            throw new RememberMeAuthenticationException("Remember-me login has expired");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Refreshing persistent login token for user '" + token.getUsername() + "', series '" + token.getSeries() + "'"));
        }
        try {
            if (this.goFuture(token.getDate(), 30000L).getTime() < System.currentTimeMillis()) {
                PersistentRememberMeToken newToken = new PersistentRememberMeToken(token.getUsername().toLowerCase(), token.getSeries(), this.generateTokenData(), new Date());
                this.tokenRepository.createNewToken(newToken);
                this.addCookie(newToken, request, response);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to update token: ", (Throwable)e);
            throw new RememberMeAuthenticationException("Autologin failed due to data access problem");
        }
        return this.getUserDetailsService().loadUserByUsername(token.getUsername());
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        super.logout(request, response, authentication);
        if (authentication != null) {
            this.tokenRepository.removeUserTokens(authentication.getName().toLowerCase());
        } else {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])request.getCookies())).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)XlPersistentTokenRememberMeServices.$anonfun$logout$1(this, x$1))).foreach((Function1 & Serializable & scala.Serializable)c -> {
                XlPersistentTokenRememberMeServices.$anonfun$logout$2(this, c);
                return BoxedUnit.UNIT;
            });
        }
        SecurityContextLogoutHandler securityContextLogoutHandler = new SecurityContextLogoutHandler();
        securityContextLogoutHandler.logout(request, response, null);
    }

    public String generateSeriesData() {
        byte[] newSeries = new byte[this.seriesLength()];
        this.random().nextBytes(newSeries);
        return new String(Base64.getEncoder().encode(newSeries));
    }

    public String generateTokenData() {
        byte[] newToken = new byte[this.tokenLength()];
        this.random().nextBytes(newToken);
        return new String(Base64.getEncoder().encode(newToken));
    }

    private void addCookie(PersistentRememberMeToken token, HttpServletRequest request, HttpServletResponse response) {
        this.setCookie((String[])((Object[])new String[]{token.getSeries(), token.getTokenValue()}), this.getTokenValiditySeconds(), request, response);
    }

    public void setSeriesLength(int seriesLength) {
        this.seriesLength_$eq(seriesLength);
    }

    public void setTokenLength(int tokenLength) {
        this.tokenLength_$eq(tokenLength);
    }

    public void setTokenValiditySeconds(int tokenValiditySeconds) {
        Assert.isTrue((tokenValiditySeconds > 0 ? 1 : 0) != 0, (String)"tokenValiditySeconds must be positive for this implementation");
        super.setTokenValiditySeconds(tokenValiditySeconds);
    }

    public static final /* synthetic */ boolean $anonfun$logout$1(XlPersistentTokenRememberMeServices $this, Cookie x$1) {
        String string = x$1.getName();
        String string2 = $this.protected$getCookieName($this);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$logout$2(XlPersistentTokenRememberMeServices $this, Cookie c) {
        String[] values = $this.protected$decodeCookie($this, c.getValue());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])values)).headOption().foreach((Function1 & Serializable & scala.Serializable)series -> {
            $this.tokenRepository.removeUserTokensBasedOnSeries(series);
            return BoxedUnit.UNIT;
        });
    }

    public XlPersistentTokenRememberMeServices(String key, UserDetailsService userDetailsService, CustomPersistentTokenRepository tokenRepository) {
        this.tokenRepository = tokenRepository;
        super(key, userDetailsService);
        this.DEFAULT_SERIES_LENGTH = 16;
        this.DEFAULT_TOKEN_LENGTH = 16;
        this.seriesLength = this.DEFAULT_SERIES_LENGTH();
        this.tokenLength = this.DEFAULT_TOKEN_LENGTH();
        this.random = new SecureRandom();
    }
}

