/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.forms.FacetFilters;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.FacetService;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/api/v1/facets")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Controller
public class FacetApi
implements ApiService {
    private final FacetService facetService;
    private final PermissionChecker permissions;

    @Autowired
    public FacetApi(FacetService facetService, PermissionChecker permissions) {
        this.facetService = facetService;
        this.permissions = permissions;
    }

    @GET
    @Path(value="/{facetId:.*Facet[^/]*}")
    @PublicApiMember
    @Timed
    public Facet getFacet(@PathParam(value="facetId") String facetId) {
        return this.facetService.get(facetId);
    }

    @POST
    @PublicApiMember
    @Timed
    public Facet createFacet(Facet facet) {
        return this.facetService.create(facet);
    }

    @PublicApiMember
    public Facet newFacet(String type) {
        return (Facet)Type.valueOf((String)type).getDescriptor().newInstance("");
    }

    @PUT
    @Path(value="/{facetId:.*Facet[^/]*}")
    @PublicApiMember
    @Timed
    public Facet updateFacet(@PathParam(value="facetId") String facetId, Facet facet) {
        facet.setId(facetId);
        return this.facetService.update(facet);
    }

    @DELETE
    @Path(value="/{facetId:.*Facet[^/]*}")
    @PublicApiMember
    @Timed
    public void deleteFacet(@PathParam(value="facetId") String facetId) {
        this.facetService.delete(facetId);
    }

    @POST
    @Path(value="/search")
    @PublicApiMember
    @Timed
    public List<Facet> searchFacets(FacetFilters facetFilters) {
        return this.facetService.search(facetFilters);
    }

    public String serviceName() {
        return "facetApi";
    }
}

