/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.principaldata;

import com.xebialabs.xlrelease.principaldata.CompositeLdapPrincipalDataProvider;
import com.xebialabs.xlrelease.principaldata.DefaultUserDataProvider;
import com.xebialabs.xlrelease.principaldata.LdapGroupEmailProvider;
import com.xebialabs.xlrelease.principaldata.LdapUserDataProvider;
import com.xebialabs.xlrelease.principaldata.PrincipalDataProvider;
import com.xebialabs.xlrelease.principaldata.PrincipalDataProviderCache;
import com.xebialabs.xlrelease.security.authentication.LdapAuthenticationProvider;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.stereotype.Service;

@Service
public class PrincipalDataProviderFactoryBean
implements FactoryBean<PrincipalDataProvider>,
ApplicationContextAware,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(PrincipalDataProviderFactoryBean.class);
    private ApplicationContext context;
    private PrincipalDataProvider provider;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public void afterPropertiesSet() throws Exception {
        DefaultUserDataProvider defaultProvider = new DefaultUserDataProvider();
        CompositeLdapPrincipalDataProvider compositeLdapProvider = new CompositeLdapPrincipalDataProvider();
        this.tryInitUserDataProviderFromSpringLdapUserSearch(defaultProvider, compositeLdapProvider);
        if (compositeLdapProvider.isUserProvidersEmpty()) {
            this.tryInitUserDataProviderFromSpringLdapProvider(defaultProvider, compositeLdapProvider);
            if (compositeLdapProvider.isUserProvidersEmpty()) {
                logger.info("Defaulting to {}", (Object)DefaultUserDataProvider.class.getSimpleName());
                compositeLdapProvider.addProvider(defaultProvider);
            }
        }
        this.tryInitGroupEmailProviderFromLdapProvider(compositeLdapProvider);
        if (compositeLdapProvider.isGroupEmailProvidersEmpty()) {
            this.tryInitGroupEmailProviderFromLdapGroupEmailProvider(compositeLdapProvider);
        }
        this.provider = new PrincipalDataProviderCache(compositeLdapProvider);
    }

    public PrincipalDataProvider getObject() throws Exception {
        return this.provider;
    }

    public Class<?> getObjectType() {
        return PrincipalDataProvider.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private void tryInitGroupEmailProviderFromLdapGroupEmailProvider(CompositeLdapPrincipalDataProvider compositeLdapProvider) {
        Map ldapGroupEmailProviders = this.context.getBeansOfType(LdapGroupEmailProvider.class);
        if (ldapGroupEmailProviders != null && !ldapGroupEmailProviders.isEmpty()) {
            try {
                logger.info("Found {} in spring context", (Object)LdapGroupEmailProvider.class.getSimpleName());
                ldapGroupEmailProviders.forEach((name, ldapGroupEmailProvider) -> compositeLdapProvider.addProvider((LdapGroupEmailProvider)ldapGroupEmailProvider));
            }
            catch (Exception e) {
                logger.warn("Error initializing from {}", (Object)LdapGroupEmailProvider.class.getSimpleName(), (Object)e);
            }
        }
    }

    private void tryInitGroupEmailProviderFromLdapProvider(CompositeLdapPrincipalDataProvider compositeLdapProvider) {
        Map ldapProviders = this.context.getBeansOfType(LdapAuthenticationProvider.class);
        if (ldapProviders != null && !ldapProviders.isEmpty()) {
            try {
                logger.info("Found {} in spring context, initializing from LDAP", (Object)LdapAuthenticationProvider.class.getSimpleName());
                ldapProviders.forEach((name, ldapProvider) -> {
                    if (ldapProvider.getGroupEmailProvider() != null) {
                        compositeLdapProvider.addProvider(ldapProvider.getGroupEmailProvider());
                    }
                });
            }
            catch (Exception e) {
                logger.warn("Error initializing from {}", (Object)LdapAuthenticationProvider.class.getSimpleName(), (Object)e);
            }
        }
    }

    private void tryInitUserDataProviderFromSpringLdapProvider(DefaultUserDataProvider defaultUserDataProvider, CompositeLdapPrincipalDataProvider compositeLdapProvider) {
        Map ldapProviders = this.context.getBeansOfType(org.springframework.security.ldap.authentication.LdapAuthenticationProvider.class);
        if (ldapProviders != null && !ldapProviders.isEmpty()) {
            try {
                logger.info("Found {} in spring context, initializing from LDAP", (Object)org.springframework.security.ldap.authentication.LdapAuthenticationProvider.class.getSimpleName());
                ldapProviders.forEach((name, ldapProvider) -> compositeLdapProvider.addProvider(new LdapUserDataProvider((org.springframework.security.ldap.authentication.LdapAuthenticationProvider)ldapProvider, defaultUserDataProvider)));
            }
            catch (Exception e) {
                logger.warn("Error initializing from {}", (Object)org.springframework.security.ldap.authentication.LdapAuthenticationProvider.class.getSimpleName(), (Object)e);
            }
        }
    }

    private void tryInitUserDataProviderFromSpringLdapUserSearch(DefaultUserDataProvider defaultUserDataProvider, CompositeLdapPrincipalDataProvider compositeLdapProvider) {
        Map ldapUserSearches = this.context.getBeansOfType(LdapUserSearch.class);
        if (ldapUserSearches != null && !ldapUserSearches.isEmpty()) {
            try {
                logger.info("Found {} in spring context, initializing from LDAP", (Object)LdapUserSearch.class.getSimpleName());
                ldapUserSearches.forEach((name, ldapUserSearch) -> compositeLdapProvider.addProvider(new LdapUserDataProvider((LdapUserSearch)ldapUserSearch, defaultUserDataProvider)));
            }
            catch (Exception e) {
                logger.warn("Error initializing from {}", (Object)LdapUserSearch.class.getSimpleName(), (Object)e);
            }
        }
    }
}

