/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlrelease.domain.Phase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.util.StringUtils;

@PublicApiRef
public enum PhaseVersion {
    LATEST,
    ORIGINAL,
    ALL;


    public static PhaseVersion fromString(String s) {
        if (StringUtils.hasText((String)s)) {
            return PhaseVersion.valueOf(s.toUpperCase());
        }
        return ALL;
    }

    public static List<PhaseVersion> determinePhaseVersion(Phase phase) {
        if (phase == null) {
            return Arrays.asList(ALL);
        }
        ArrayList<PhaseVersion> phaseVersions = new ArrayList<PhaseVersion>(2);
        if (phase.isOriginal()) {
            phaseVersions.add(ORIGINAL);
        }
        if (!phase.isPhaseCopied()) {
            phaseVersions.add(LATEST);
        }
        if (!phaseVersions.isEmpty()) {
            return phaseVersions;
        }
        return Arrays.asList(ALL);
    }

    public static boolean isPhaseVersion(Phase phase, PhaseVersion phaseVersion) {
        return PhaseVersion.determinePhaseVersion(phase).contains((Object)phaseVersion);
    }
}

