/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.xml.WriteWithoutPasswordCiConverter;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.io.SourceArtifactFile;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.RepositoryAdapter;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.ArchivedReleases$;
import com.xebialabs.xlrelease.db.ArchivedReleasesSearch;
import com.xebialabs.xlrelease.db.AttachmentInfo;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.json.CiSerializerHelper$;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.ArchivedActivityLogsSerializer;
import com.xebialabs.xlrelease.service.ArchivingService$;
import com.xebialabs.xlrelease.service.CompletedReleaseExportService;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@Service
@Transactional(value="reportingTransactionManager", propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, rollbackFor={Throwable.class})
@ScalaSignature(bytes="\u0006\u0001\rUq!B\u0001\u0003\u0011\u0003Y\u0011\u0001E!sG\"Lg/\u001b8h'\u0016\u0014h/[2f\u0015\t\u0019A!A\u0004tKJ4\u0018nY3\u000b\u0005\u00151\u0011!\u0003=me\u0016dW-Y:f\u0015\t9\u0001\"A\u0005yK\nL\u0017\r\\1cg*\t\u0011\"A\u0002d_6\u001c\u0001\u0001\u0005\u0002\r\u001b5\t!AB\u0003\u000f\u0005!\u0005qB\u0001\tBe\u000eD\u0017N^5oON+'O^5dKN\u0011Q\u0002\u0005\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000b]iA\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005Y\u0001\"\u0002\u000e\u000e\t\u0003Y\u0012A\u00073fg\u0016\u0014\u0018.\u00197ju\u0016\f%o\u00195jm\u0016$'+\u001a7fCN,Gc\u0001\u000f#_A\u0011Q\u0004I\u0007\u0002=)\u0011q\u0004B\u0001\u0007I>l\u0017-\u001b8\n\u0005\u0005r\"a\u0002*fY\u0016\f7/\u001a\u0005\u0006Ge\u0001\r\u0001J\u0001\fe\u0016dW-Y:f\u0015N|g\u000e\u0005\u0002&Y9\u0011aE\u000b\t\u0003OIi\u0011\u0001\u000b\u0006\u0003S)\ta\u0001\u0010:p_Rt\u0014BA\u0016\u0013\u0003\u0019\u0001&/\u001a3fM&\u0011QF\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005-\u0012\u0002\"\u0002\u0019\u001a\u0001\u0004\t\u0014A\u0003:fa>\u001c\u0018\u000e^8ssB\u0011!GN\u0007\u0002g)\u0011\u0001\u0007\u000e\u0006\u0003k\u0019\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0003oM\u0012\u0011CU3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3s\r\u0011q!\u0001A\u001d\u0014\u0007a\u0002\"\b\u0005\u0002<\u00016\tAH\u0003\u0002>}\u0005)1\u000f\u001c45U*\tq(\u0001\u0005he&T(\u0010\\3e\u0013\t\tEHA\u0004M_\u001e<\u0017N\\4\t\u0011\rC$\u0011!Q\u0001\n\u0011\u000b\u0001#\u0019:dQ&4X\r\u001a*fY\u0016\f7/Z:\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001d#\u0011A\u00013c\u0013\tIeI\u0001\tBe\u000eD\u0017N^3e%\u0016dW-Y:fg\"A1\n\u000fB\u0001B\u0003%A*\u0001\fbe\u000eD\u0017N^3e%\u0016dW-Y:fgN+\u0017M]2i!\t)U*\u0003\u0002O\r\n1\u0012I]2iSZ,GMU3mK\u0006\u001cXm]*fCJ\u001c\u0007\u000e\u0003\u0005Qq\t\u0005\t\u0015!\u0003R\u0003y\t'o\u00195jm\u0016$\u0017i\u0019;jm&$\u0018\u0010T8hgN+'/[1mSj,'\u000f\u0005\u0002\r%&\u00111K\u0001\u0002\u001f\u0003J\u001c\u0007.\u001b<fI\u0006\u001bG/\u001b<jifdunZ:TKJL\u0017\r\\5{KJD\u0001\"\u0016\u001d\u0003\u0002\u0003\u0006I!M\u0001\u0012e\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014\b\u0002C,9\u0005\u0003\u0005\u000b\u0011\u0002-\u0002=\r|W\u000e\u001d7fi\u0016$'+\u001a7fCN,7/\u0012=q_J$8+\u001a:wS\u000e,\u0007C\u0001\u0007Z\u0013\tQ&AA\u000fD_6\u0004H.\u001a;fIJ+G.Z1tK\u0016C\bo\u001c:u'\u0016\u0014h/[2f\u0011!a\u0006H!A!\u0002\u0013i\u0016!\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ssB\u0011a\fY\u0007\u0002?*\u0011\u0001\u0007B\u0005\u0003C~\u0013\u0011CU3mK\u0006\u001cXMU3q_NLGo\u001c:z\u0011!\u0019\u0007H!A!\u0002\u0013!\u0017\u0001\u00063fa\u0016tG-\u001a8dsJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002_K&\u0011am\u0018\u0002\u0015\t\u0016\u0004XM\u001c3f]\u000eL(+\u001a9pg&$xN]=\t\u0011!D$\u0011!Q\u0001\n%\f1C]3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016\u0004\"A[7\u000e\u0003-T!\u0001\u001c\u0003\u0002\r\u0005\u001cGo\u001c:t\u0013\tq7NA\nSK2,\u0017m]3BGR|'oU3sm&\u001cW\rC\u0003\u0018q\u0011\u0005\u0001\u000fF\u0005reN$XO^<ysB\u0011A\u0002\u000f\u0005\u0006\u0007>\u0004\r\u0001\u0012\u0005\u0006\u0017>\u0004\r\u0001\u0014\u0005\u0006!>\u0004\r!\u0015\u0005\u0006+>\u0004\r!\r\u0005\u0006/>\u0004\r\u0001\u0017\u0005\u00069>\u0004\r!\u0018\u0005\u0006G>\u0004\r\u0001\u001a\u0005\u0006Q>\u0004\r!\u001b\u0015\u0003_n\u00042\u0001`A\b\u001b\u0005i(B\u0001@\u0000\u0003)\tgN\\8uCRLwN\u001c\u0006\u0005\u0003\u0003\t\u0019!A\u0004gC\u000e$xN]=\u000b\t\u0005\u0015\u0011qA\u0001\u0006E\u0016\fgn\u001d\u0006\u0005\u0003\u0013\tY!A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\ti!A\u0002pe\u001eL1!!\u0005~\u0005%\tU\u000f^8xSJ,G\rC\u0004\u0002\u0016a\"\t!a\u0006\u0002\u001d\u0005\u00148\r[5wKJ+G.Z1tKR1\u0011\u0011DA\u0010\u0003G\u00012!EA\u000e\u0013\r\tiB\u0005\u0002\u0005+:LG\u000fC\u0004\u0002\"\u0005M\u0001\u0019\u0001\u000f\u0002\u000fI,G.Z1tK\"A\u0011QEA\n\u0001\u0004\t9#\u0001\nsK2,\u0017m]3BiR\f7\r[7f]R\u001c\bCBA\u0015\u0003g\t9$\u0004\u0002\u0002,)!\u0011QFA\u0018\u0003\u0011)H/\u001b7\u000b\u0005\u0005E\u0012\u0001\u00026bm\u0006LA!!\u000e\u0002,\t!A*[:u!\ri\u0012\u0011H\u0005\u0004\u0003wq\"AC!ui\u0006\u001c\u0007.\\3oi\"\"\u00111CA !\u0011\t\t%!\u0014\u000e\u0005\u0005\r#b\u0001@\u0002F)!\u0011qIA%\u0003\u001diW\r\u001e:jGNT1!a\u0013\t\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BA(\u0003\u0007\u0012Q\u0001V5nK\u0012Dq!a\u00159\t\u0003\t)&\u0001\u0006hKR\u0014V\r\\3bg\u0016$2\u0001HA,\u0011\u001d\tI&!\u0015A\u0002\u0011\n\u0011B]3mK\u0006\u001cX-\u00133)\t\u0005E\u0013q\b\u0005\b\u0003?BD\u0011AA1\u0003=9W\r\u001e*fY\u0016\f7/\u001a+ji2,Gc\u0001\u0013\u0002d!9\u0011\u0011LA/\u0001\u0004!\u0003\u0006BA/\u0003\u007fAq!!\u001b9\t\u0003\tY'\u0001\u0005hKR\u0004\u0006.Y:f)\u0011\ti'a\u001d\u0011\u0007u\ty'C\u0002\u0002ry\u0011Q\u0001\u00155bg\u0016Dq!!\u001e\u0002h\u0001\u0007A%A\u0004qQ\u0006\u001cX-\u00133)\t\u0005\u001d\u0014q\b\u0005\b\u0003wBD\u0011AA?\u0003\u001d9W\r\u001e+bg.$B!a \u0002\u0006B\u0019Q$!!\n\u0007\u0005\reD\u0001\u0003UCN\\\u0007bBAD\u0003s\u0002\r\u0001J\u0001\u0007i\u0006\u001c8.\u00133)\t\u0005e\u0014q\b\u0005\b\u0003\u001bCD\u0011AAH\u0003-9W\r\u001e,be&\f'\r\\3\u0015\t\u0005E\u0015Q\u0014\t\u0005\u0003'\u000bI*\u0004\u0002\u0002\u0016*\u0019\u0011q\u0013\u0010\u0002\u0013Y\f'/[1cY\u0016\u001c\u0018\u0002BAN\u0003+\u0013\u0001BV1sS\u0006\u0014G.\u001a\u0005\b\u0003?\u000bY\t1\u0001%\u0003)1\u0018M]5bE2,\u0017\n\u001a\u0015\u0005\u0003\u0017\u000by\u0004C\u0004\u0002&b\"\t!a*\u0002\r\u0015D\u0018n\u001d;t)\u0011\tI+a,\u0011\u0007E\tY+C\u0002\u0002.J\u0011qAQ8pY\u0016\fg\u000eC\u0004\u00022\u0006\r\u0006\u0019\u0001\u0013\u0002\t\rL\u0017\n\u001a\u0015\u0005\u0003G\u000by\u0004C\u0004\u00028b\"\t!!/\u0002\u0019\u0015D\u0018n\u001d;t\u0005ft\u0015-\\3\u0015\t\u0005%\u00161\u0018\u0005\b\u0003{\u000b)\f1\u0001%\u0003-\u0011X\r\\3bg\u0016t\u0015-\\3)\t\u0005U\u0016q\b\u0005\b\u0003\u0007DD\u0011AAc\u0003A\u0019\u0007.Z2l\u001d>$\u0018I]2iSZ,G\r\u0006\u0003\u0002\u001a\u0005\u001d\u0007bBAY\u0003\u0003\u0004\r\u0001\n\u0015\u0005\u0003\u0003\fy\u0004C\u0004\u0002Nb\"\t!a4\u0002!\u0005$H/Y2i[\u0016tG/\u0012=jgR\u001cH\u0003BAU\u0003#Dq!a5\u0002L\u0002\u0007A%\u0001\u0007biR\f7\r[7f]RLE\r\u000b\u0003\u0002L\u0006}\u0002bBAmq\u0011\u0005\u00111\\\u0001\u000eO\u0016$\u0018\t\u001e;bG\"lWM\u001c;\u0015\t\u0005]\u0012Q\u001c\u0005\b\u0003'\f9\u000e1\u0001%Q\u0011\t9.a\u0010\t\u000f\u0005\r\b\b\"\u0001\u0002f\u0006\u0019r-\u001a;BiR\f7\r[7f]R|\u0005\u000f^5p]R!\u0011q]Aw!\u0015\t\u0012\u0011^A\u001c\u0013\r\tYO\u0005\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005M\u0017\u0011\u001da\u0001I!\"\u0011\u0011]A \u0011\u001d\t\u0019\u0010\u000fC\u0001\u0003k\fab]3be\u000eD'+\u001a7fCN,7\u000f\u0006\u0003\u0002x\u0006e\b#BA\u0015\u0003ga\u0002\u0002CA~\u0003c\u0004\r!!@\u0002\u000f\u0019LG\u000e^3sgB!\u0011q B\u0007\u001b\t\u0011\tA\u0003\u0003\u0003\u0004\t\u0015\u0011!\u00024pe6\u001c(\u0002\u0002B\u0004\u0005\u0013\t!A^\u0019\u000b\u0007\t-A!A\u0002ba&LAAa\u0004\u0003\u0002\ty!+\u001a7fCN,7OR5mi\u0016\u00148\u000f\u000b\u0003\u0002r\u0006}\u0002bBAzq\u0011\u0005!Q\u0003\u000b\t\u0003o\u00149B!\u0007\u0003$!A\u00111 B\n\u0001\u0004\ti\u0010\u0003\u0005\u0003\u001c\tM\u0001\u0019\u0001B\u000f\u0003\u0015a\u0017.\\5u!\r\t\"qD\u0005\u0004\u0005C\u0011\"\u0001\u0002'p]\u001eD\u0001B!\n\u0003\u0014\u0001\u0007!QD\u0001\u0007_\u001a47/\u001a;)\t\tM\u0011q\b\u0005\b\u0005WAD\u0011\u0001B\u0017\u0003a1\u0017N\u001c3Be\u000eD\u0017N^1cY\u0016\u0014V\r\\3bg\u0016LEm\u001d\u000b\u0007\u0005_\u0011\tEa\u0013\u0011\u000b\tE\"1\b\u0013\u000f\t\tM\"q\u0007\b\u0004O\tU\u0012\"A\n\n\u0007\te\"#A\u0004qC\u000e\\\u0017mZ3\n\t\tu\"q\b\u0002\u0004'\u0016\f(b\u0001B\u001d%!A!1\tB\u0015\u0001\u0004\u0011)%\u0001\u0003eCR,\u0007\u0003BA\u0015\u0005\u000fJAA!\u0013\u0002,\t!A)\u0019;f\u0011!\u0011iE!\u000bA\u0002\t=\u0013\u0001\u00039bO\u0016\u001c\u0016N_3\u0011\t\tE#qK\u0007\u0003\u0005'RAA!\u0016\u00020\u0005!A.\u00198h\u0013\u0011\u0011IFa\u0015\u0003\u000f%sG/Z4fe\"\"!\u0011FA \u0011\u001d\u0011y\u0006\u000fC\u0001\u0005C\na$\u0019:dQ&4X-\u00117m\u0013:\u001cw.\\5oO\u0012+\u0007/\u001a8eK:\u001c\u0017.Z:\u0015\t\u0005e!1\r\u0005\b\u00033\u0012i\u00061\u0001%Q\u0011\u0011i&a\u0010\t\u000f\t%\u0004\b\"\u0001\u0003l\u0005Qq-\u001a;BY2$\u0016mZ:\u0015\t\t5$1\u000f\t\u0006\u0003S\u0011y\u0007J\u0005\u0005\u0005c\nYCA\u0002TKRD\u0001B!\u001e\u0003h\u0001\u0007!qO\u0001\fY&l\u0017\u000e\u001e(v[\n,'\u000fE\u0002\u0012\u0005sJ1Aa\u001f\u0013\u0005\rIe\u000e\u001e\u0015\u0005\u0005O\ny\u0004C\u0004\u0003\u0002b\"\tAa!\u0002\r\u0011,G.\u001a;f)\u0011\tIB!\"\t\u000f\u0005e#q\u0010a\u0001I!\"!qPA \u0011\u001d\t\u0019\u0010\u000fC\u0005\u0005\u0017#\u0002\"a>\u0003\u000e\n=%1\u0013\u0005\t\u0003w\u0014I\t1\u0001\u0002~\"A!1\u0004BE\u0001\u0004\u0011\t\nE\u0003\u0012\u0003S\u0014i\u0002\u0003\u0005\u0003&\t%\u0005\u0019\u0001BI\u0011\u001d\u00119\n\u000fC\u0005\u00053\u000b\u0001cZ3u%\u0016dW-Y:f\u001fB$\u0018n\u001c8\u0015\t\tm%Q\u0014\t\u0005#\u0005%H\u0004C\u0004\u0002Z\tU\u0005\u0019\u0001\u0013\t\u000f\t\u0005\u0006\b\"\u0003\u0003$\u0006qq-\u001a;QQ\u0006\u001cXm\u00149uS>tG\u0003\u0002BS\u0005O\u0003R!EAu\u0003[Bq!!\u001e\u0003 \u0002\u0007A\u0005C\u0004\u0003,b\"IA!,\u0002\u001b\u001d,G\u000fV1tW>\u0003H/[8o)\u0011\u0011yK!-\u0011\u000bE\tI/a \t\u000f\u0005\u001d%\u0011\u0016a\u0001I!9!Q\u0017\u001d\u0005\n\t]\u0016!E4fiZ\u000b'/[1cY\u0016|\u0005\u000f^5p]R!!\u0011\u0018B^!\u0015\t\u0012\u0011^AI\u0011\u001d\tyJa-A\u0002\u0011BqAa09\t\u0013\u0011\t-\u0001\u0010be\u000eD\u0017N^3BY2|U\u000f^4pS:<G)\u001a9f]\u0012,gnY5fgR!!1\u0019Bf!\u0019\u0011\tDa\u000f\u0003FB\u0019QDa2\n\u0007\t%gD\u0001\u0006EKB,g\u000eZ3oGfDq!!\t\u0003>\u0002\u0007A\u0004K\n9\u0005\u001f\u0014iNa8\u0003d\n\u0015(q\u001eBy\u0005w\u0014i\u0010\u0005\u0003\u0003R\neWB\u0001Bj\u0015\rq(Q\u001b\u0006\u0005\u0005/\f9!A\u0006ue\u0006t7/Y2uS>t\u0017\u0002\u0002Bn\u0005'\u0014Q\u0002\u0016:b]N\f7\r^5p]\u0006d\u0017!\u0002<bYV,\u0017E\u0001Bq\u0003m\u0011X\r]8si&tw\r\u0016:b]N\f7\r^5p]6\u000bg.Y4fe\u0006Y\u0001O]8qC\u001e\fG/[8oI\t\u00119/\u0003\u0003\u0003j\n-\u0018\u0001\u0003*F#VK%+\u0012#\u000b\t\t5(1[\u0001\f!J|\u0007/Y4bi&|g.A\u0005jg>d\u0017\r^5p]\u0012\u0012!1_\u0005\u0005\u0005k\u001490\u0001\bS\u000b\u0006#ulQ(N\u001b&#F+\u0012#\u000b\t\te(1[\u0001\n\u0013N|G.\u0019;j_:\f1B]8mY\n\f7m\u001b$pe2\u0012!q`\u0012\u0003\u0007\u0003\u0001BA!\r\u0004\u0004%!1Q\u0001B \u0005%!\u0006N]8xC\ndW\rK\u00029\u0007\u0013\u0001Baa\u0003\u0004\u00125\u00111Q\u0002\u0006\u0005\u0007\u001f\t9!\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAaa\u0005\u0004\u000e\t91+\u001a:wS\u000e,\u0007")
public class ArchivingService
implements Logging {
    private final ArchivedReleases archivedReleases;
    private final ArchivedReleasesSearch archivedReleasesSearch;
    private final ArchivedActivityLogsSerializer archivedActivityLogsSerializer;
    private final RepositoryAdapter repositoryAdapter;
    private final CompletedReleaseExportService completedReleasesExportService;
    private final ReleaseRepository releaseRepository;
    private final DependencyRepository dependencyRepository;
    private final ReleaseActorService releaseActorService;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public static Release deserializeArchivedRelease(String string, RepositoryAdapter repositoryAdapter) {
        return ArchivingService$.MODULE$.deserializeArchivedRelease(string, repositoryAdapter);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ArchivingService archivingService = this;
        synchronized (archivingService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public void archiveRelease(Release release, java.util.List<Attachment> releaseAttachments) {
        Seq<Dependency> archivedDependencies = this.archiveAllOutgoingDependencies(release);
        this.dependencyRepository.archive(release, archivedDependencies);
        this.archiveAllIncomingDependencies(release.getId());
        String serializedRelease = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release, (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
        if (!release.isTutorial()) {
            String activityLogsJson = this.archivedActivityLogsSerializer.serializeActivityLogsOf(release.getId());
            this.archivedReleases.insert(release, serializedRelease, activityLogsJson);
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(releaseAttachments).asScala()).foreach((Function1 & Serializable & scala.Serializable)attachment -> {
                ArchivingService.$anonfun$archiveRelease$1(this, release, attachment);
                return BoxedUnit.UNIT;
            });
        }
        if (this.releaseRepository.exists(release.getId())) {
            this.releaseRepository.delete(release.getId());
        }
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running release ", " through export hooks"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{release.getId()})));
        this.completedReleasesExportService.sendThroughExportHooks(release, serializedRelease);
    }

    @Timed
    public Release getRelease(String releaseId) {
        return (Release)this.getReleaseOption(releaseId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId})), new Object[0]);
        });
    }

    @Timed
    public String getReleaseTitle(String releaseId) {
        return (String)this.archivedReleases.getReleaseTitle(releaseId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId})), new Object[0]);
        });
    }

    @Timed
    public Phase getPhase(String phaseId) {
        return (Phase)this.getPhaseOption(phaseId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Ids.releaseIdFrom((String)phaseId)})), new Object[0]);
        });
    }

    @Timed
    public Task getTask(String taskId) {
        return (Task)this.getTaskOption(taskId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Ids.releaseIdFrom((String)taskId)})), new Object[0]);
        });
    }

    @Timed
    public Variable getVariable(String variableId) {
        return (Variable)this.getVariableOption(variableId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Ids.releaseIdFrom((String)variableId)})), new Object[0]);
        });
    }

    @Timed
    public boolean exists(String ciId) {
        return Ids.isReleaseId((String)ciId) ? this.archivedReleases.exists(ciId) : (Ids.isPhaseId((String)ciId) ? this.getPhaseOption(ciId).isDefined() : (Ids.isTaskId((String)ciId) ? this.getTaskOption(ciId).isDefined() : (Ids.isVariableId((String)ciId) ? this.getVariableOption(ciId).isDefined() : false)));
    }

    @Timed
    public boolean existsByName(String releaseName) {
        return this.archivedReleases.existsByName(releaseName);
    }

    @Timed
    public void checkNotArchived(String ciId) {
        if (this.archivedReleases.exists(Ids.releaseIdFrom((String)ciId))) {
            throw new Checks.IncorrectArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"You cannot perform this operation on archived release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Ids.releaseIdFrom((String)ciId)})), new Object[0]);
        }
    }

    @Timed
    public boolean attachmentExists(String attachmentId) {
        return this.archivedReleases.attachmentExists(attachmentId);
    }

    @Timed
    public Attachment getAttachment(String attachmentId) {
        return (Attachment)this.getAttachmentOption(attachmentId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find archived attachment [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attachmentId})), new Object[0]);
        });
    }

    @Timed
    public Option<Attachment> getAttachmentOption(String attachmentId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)attachmentId)).flatMap((Function1 & Serializable & scala.Serializable)release -> $this.archivedReleases.getAttachment(attachmentId).flatMap((Function1 & Serializable & scala.Serializable)overthereFile -> Option$.MODULE$.apply((Object)release.getAttachment(attachmentId)).map((Function1 & Serializable & scala.Serializable)attachment -> {
            attachment.setFile(overthereFile);
            return attachment;
        })));
    }

    @Timed
    public java.util.List<Release> searchReleases(ReleasesFilters filters) {
        return this.searchReleases(filters, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
    }

    @Timed
    public java.util.List<Release> searchReleases(ReleasesFilters filters, long limit, long offset) {
        return this.searchReleases(filters, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)limit)), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)offset)));
    }

    @Timed
    public Seq<String> findArchivableReleaseIds(Date date, Integer pageSize) {
        return this.releaseRepository.findArchivableReleaseIds(date, Predef$.MODULE$.Integer2int(pageSize));
    }

    @Timed
    public void archiveAllIncomingDependencies(String releaseId) {
        Seq<Dependency> incomingDependencies = this.dependencyRepository.findAllIncomingDependencies((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{releaseId}))), (Seq<String>)((Seq)Seq$.MODULE$.empty()), true);
        incomingDependencies.groupBy((Function1 & Serializable & scala.Serializable)d -> Ids.normalizeId((String)Ids.releaseIdFrom((String)d.getId()))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ArchivingService.$anonfun$archiveAllIncomingDependencies$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Set<String> getAllTags(int limitNumber) {
        return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.archivedReleases.findAllTags(limitNumber)).asJava();
    }

    @Timed
    public void delete(String releaseId) {
        this.archivedReleases.delete(releaseId);
    }

    private java.util.List<Release> searchReleases(ReleasesFilters filters, Option<Object> limit, Option<Object> offset) {
        filters.checkConsistency();
        List<String> releaseJsons = this.archivedReleasesSearch.searchReleases(filters, limit, offset);
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)releaseJsons.map((Function1 & Serializable & scala.Serializable)json -> ArchivingService$.MODULE$.deserializeArchivedRelease((String)json, $this.repositoryAdapter), List$.MODULE$.canBuildFrom())).asJava();
    }

    private Option<Release> getReleaseOption(String releaseId) {
        return this.archivedReleases.getRelease(releaseId).map((Function1 & Serializable & scala.Serializable)releaseJson -> {
            void var3_3;
            Release release = ArchivingService$.MODULE$.deserializeArchivedRelease((String)releaseJson, $this.repositoryAdapter);
            Map<String, String> attachmentsFileNames = $this.archivedReleases.getAttachmentsFileNames(release.getId());
            release.getAttachments().forEach(attachment -> {
                Option option = attachmentsFileNames.get((Object)ArchivedReleases$.MODULE$.shortenId(attachment.getId()));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String filename = (String)some.value();
                    attachment.setFile((OverthereFile)SourceArtifactFile.withNullableWorkDir((String)filename, (SourceArtifact)attachment, null));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(option)) {
                    this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find attachment ", " of release ", " in the attachments table"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attachment.getId(), releaseId})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)option);
                }
            });
            return var3_3;
        });
    }

    private Option<Phase> getPhaseOption(String phaseId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)phaseId)).flatMap((Function1 & Serializable & scala.Serializable)release -> Option$.MODULE$.apply((Object)release.getPhase(phaseId)));
    }

    private Option<Task> getTaskOption(String taskId) {
        return this.getPhaseOption(Ids.phaseIdFrom((String)taskId)).flatMap((Function1 & Serializable & scala.Serializable)phase -> Option$.MODULE$.apply((Object)phase.getTask(taskId)));
    }

    private Option<Variable> getVariableOption(String variableId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)variableId)).flatMap((Function1 & Serializable & scala.Serializable)release -> ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getVariables()).asScala()).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$getVariableOption$2(variableId, x$2))));
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Dependency> archiveAllOutgoingDependencies(Release release) {
        void var2_2;
        Buffer dependencies = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllGates()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$3.getDependencies()).asScala(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$archiveAllOutgoingDependencies$2(x$4)));
        dependencies.foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.archive();
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public static final /* synthetic */ void $anonfun$archiveRelease$3(ArchivingService $this, Release release$1, Attachment attachment$1, InputStream data) {
        try {
            $this.archivedReleases.insertAttachment(release$1.getId(), new AttachmentInfo(attachment$1.getId(), attachment$1.getFile().getName(), data));
        }
        finally {
            data.close();
        }
    }

    public static final /* synthetic */ void $anonfun$archiveRelease$1(ArchivingService $this, Release release$1, Attachment attachment) {
        Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> attachment.getFile().getInputStream()).foreach((Function1 & Serializable & scala.Serializable)data -> {
            ArchivingService.$anonfun$archiveRelease$3($this, release$1, attachment, data);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$archiveAllIncomingDependencies$2(ArchivingService $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String referencingReleaseId = (String)tuple2._1();
        Seq rawDependenciesToArchive = (Seq)tuple2._2();
        $this.releaseActorService.archiveDependencies(referencingReleaseId, (Seq<String>)((Seq)rawDependenciesToArchive.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getId(), Seq$.MODULE$.canBuildFrom())));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$getVariableOption$2(String variableId$2, Variable x$2) {
        String string = x$2.getId();
        String string2 = variableId$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$archiveAllOutgoingDependencies$2(Dependency x$4) {
        return !x$4.isArchived();
    }

    @Autowired
    public ArchivingService(ArchivedReleases archivedReleases, ArchivedReleasesSearch archivedReleasesSearch, ArchivedActivityLogsSerializer archivedActivityLogsSerializer, RepositoryAdapter repositoryAdapter, CompletedReleaseExportService completedReleasesExportService, ReleaseRepository releaseRepository, DependencyRepository dependencyRepository, ReleaseActorService releaseActorService) {
        this.archivedReleases = archivedReleases;
        this.archivedReleasesSearch = archivedReleasesSearch;
        this.archivedActivityLogsSerializer = archivedActivityLogsSerializer;
        this.repositoryAdapter = repositoryAdapter;
        this.completedReleasesExportService = completedReleasesExportService;
        this.releaseRepository = releaseRepository;
        this.dependencyRepository = dependencyRepository;
        this.releaseActorService = releaseActorService;
        Logging.$init$((Logging)this);
    }
}

