/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.mbeans;

import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.xebialabs.xlrelease.principaldata.PrincipalDataProvider;
import com.xebialabs.xlrelease.principaldata.PrincipalDataProviderCache;
import com.xebialabs.xlrelease.service.ReportServiceCache;
import com.xebialabs.xlrelease.service.UserProfileService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.caffeine.CaffeineCache;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.stereotype.Component;

@Component
@ManagedResource(objectName="com.xebialabs.xlrelease.settings:name=CacheControl", description="Cache control")
public class CacheControl {
    private UserProfileService userProfileService;
    private PrincipalDataProvider principalDataProvider;
    private ReportServiceCache reportServiceCache;
    private List<? extends CacheManager> cacheManagers = Collections.emptyList();

    @Autowired
    public CacheControl(UserProfileService userProfileService, PrincipalDataProvider principalDataProvider, ReportServiceCache reportServiceCache) {
        this.userProfileService = userProfileService;
        this.principalDataProvider = principalDataProvider;
        this.reportServiceCache = reportServiceCache;
    }

    @Autowired(required=false)
    public void setCacheManagers(List<? extends CacheManager> cacheManagers) {
        this.cacheManagers = cacheManagers;
    }

    @ManagedOperation(description="Clear user profiles cache")
    public void clearUserProfilesCache() {
        this.userProfileService.clearCache();
    }

    @ManagedOperation(description="Clear principal data cache")
    public void clearUserDataCache() {
        if (this.principalDataProvider instanceof PrincipalDataProviderCache) {
            ((PrincipalDataProviderCache)this.principalDataProvider).clearCache();
        }
    }

    @ManagedOperation(description="Clear reports cache")
    public void clearReportsCache() {
        this.reportServiceCache.clearCache();
    }

    @ManagedOperation(description="List caches")
    public List<String> listCaches() {
        return this.cacheManagers.stream().flatMap(manager -> manager.getCacheNames().stream()).collect(Collectors.toList());
    }

    @ManagedOperation(description="Clear named cache")
    public void clearCache(String cacheName) {
        this.cacheManagers.stream().forEach(manager -> {
            Cache cache = manager.getCache(cacheName);
            if (null != cache) {
                cache.clear();
            }
        });
    }

    @ManagedOperation(description="Fetch named cache statistics")
    public List<HashMap<String, String>> cacheStats(String cacheName) {
        return this.cacheManagers.stream().map(manager -> {
            Cache cache;
            HashMap<String, String> stats = new HashMap<String, String>();
            if (manager.getCacheNames().contains(cacheName) && (cache = manager.getCache(cacheName)) instanceof CaffeineCache) {
                CaffeineCache caffeineCache = (CaffeineCache)cache;
                CacheStats caffeineCacheStats = caffeineCache.getNativeCache().stats();
                stats.put("averageLoadPenalty", String.valueOf(caffeineCacheStats.averageLoadPenalty()));
                stats.put("evictionCount", String.valueOf(caffeineCacheStats.evictionCount()));
                stats.put("hitCount", String.valueOf(caffeineCacheStats.hitCount()));
                stats.put("hitRate", String.valueOf(caffeineCacheStats.hitRate()));
                stats.put("requestCount", String.valueOf(caffeineCacheStats.requestCount()));
            }
            return stats;
        }).collect(Collectors.toList());
    }
}

