/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.principaldata;

import com.xebialabs.xlrelease.principaldata.LdapGroupEmailProvider;
import com.xebialabs.xlrelease.principaldata.PrincipalDataProvider;
import com.xebialabs.xlrelease.principaldata.UserData;
import com.xebialabs.xlrelease.principaldata.UserDataProvider;
import java.util.ArrayList;
import java.util.List;

class CompositeLdapPrincipalDataProvider
implements PrincipalDataProvider {
    private List<UserDataProvider> userProviders = new ArrayList<UserDataProvider>();
    private List<LdapGroupEmailProvider> groupEmailProviders = new ArrayList<LdapGroupEmailProvider>();

    CompositeLdapPrincipalDataProvider() {
    }

    void addProvider(UserDataProvider provider) {
        this.userProviders.add(provider);
    }

    void addProvider(LdapGroupEmailProvider provider) {
        this.groupEmailProviders.add(provider);
    }

    public boolean isUserProvidersEmpty() {
        return this.userProviders.isEmpty();
    }

    public boolean isGroupEmailProvidersEmpty() {
        return this.groupEmailProviders.isEmpty();
    }

    @Override
    public UserData getUserData(String username) {
        return this.userProviders.stream().filter(provider -> provider.getUserData(username) != UserData.NOT_FOUND).map(provider -> provider.getUserData(username)).findFirst().orElse(UserData.NOT_FOUND);
    }

    @Override
    public String getGroupEmail(String groupName) {
        return this.groupEmailProviders.stream().filter(provider -> provider.getGroupEmail(groupName) != null).map(provider -> provider.getGroupEmail(groupName)).findFirst().orElse(null);
    }
}

