/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.views.TeamView;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.service.UserInfoResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class TeamFacade {
    private PermissionChecker permissions;
    private TeamService teamService;
    private UserInfoResolver userInfoResolver;
    private ReleaseActorService releaseActorService;
    private static final List<String> SYSTEM_TEAMS = Arrays.asList("Folder Owner", "Release Admin", "Template Owner");

    @Autowired
    public TeamFacade(PermissionChecker permissions, TeamService teamService, UserInfoResolver userInfoResolver, ReleaseActorService releaseActorService) {
        this.permissions = permissions;
        this.teamService = teamService;
        this.userInfoResolver = userInfoResolver;
        this.releaseActorService = releaseActorService;
    }

    public List<TeamView> getTeams(String containerId) {
        this.checkEdit(containerId);
        return this.teamService.getEffectiveTeams(containerId).stream().map(team -> new TeamView((Team)team, this.userInfoResolver)).collect(Collectors.toList());
    }

    public List<TeamView> setTeams(String containerId, List<TeamView> teamsToUpdate) {
        List<Team> updatedTeams;
        Checks.checkNotNull(teamsToUpdate, (String)"No teams submitted for update.");
        this.checkEdit(containerId);
        this.checkPermissions(teamsToUpdate);
        List<Team> submittedTeams = teamsToUpdate.stream().map(TeamView::toTeam).collect(Collectors.toList());
        if (Ids.isReleaseId((String)containerId)) {
            updatedTeams = this.releaseActorService.updateTeams(containerId, submittedTeams);
        } else {
            if (Ids.isInRootFolder((String)containerId) || teamsToUpdate.size() > 0) {
                this.checkSystemTeamsArePresent(teamsToUpdate);
            }
            updatedTeams = this.teamService.saveTeamsToPlatform(containerId, submittedTeams);
        }
        return updatedTeams.stream().map(team -> new TeamView((Team)team, this.userInfoResolver)).collect(Collectors.toList());
    }

    private void checkSystemTeamsArePresent(List<TeamView> teamsToUpdate) {
        ArrayList<String> missingSystemTeams = new ArrayList<String>(SYSTEM_TEAMS);
        List updateTeams = teamsToUpdate.stream().map(TeamView::getTeamName).collect(Collectors.toList());
        missingSystemTeams.removeAll(updateTeams);
        Checks.checkArgument((boolean)missingSystemTeams.isEmpty(), (String)"Cannot update teams with the following system teams missing: %s", (Object[])new Object[]{missingSystemTeams});
    }

    private void checkPermissions(List<TeamView> teamsToUpdate) {
        TreeSet unknownPermissions = new TreeSet();
        teamsToUpdate.forEach(t -> unknownPermissions.addAll(t.getPermissions().stream().filter(p -> Permission.find((String)p) == null).collect(Collectors.toList())));
        Checks.checkArgument((boolean)unknownPermissions.isEmpty(), (String)"Unknown permissions found: '%s'", (Object[])new Object[]{unknownPermissions.stream().collect(Collectors.joining(", "))});
    }

    private void checkEdit(String teamContainerId) {
        if (Ids.isReleaseId((String)teamContainerId)) {
            this.permissions.checkEdit(teamContainerId);
        } else if (Ids.isFolderId((String)teamContainerId)) {
            this.permissions.check(XLReleasePermissions.EDIT_FOLDER_SECURITY, teamContainerId);
        } else {
            throw new Checks.IncorrectArgumentException("[%s] is not a release or a folder", new Object[]{teamContainerId});
        }
    }
}

