/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.db;

import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.core.AddForeignKeyConstraintChange;
import liquibase.change.core.CreateProcedureChange;
import liquibase.change.core.CreateSequenceChange;
import liquibase.change.core.CreateTableChange;
import liquibase.change.core.CreateViewChange;
import liquibase.change.core.RenameTableChange;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.executor.ExecutorService;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.AbstractSqlStatement;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.DeleteStatement;
import liquibase.statement.core.DropForeignKeyConstraintStatement;
import liquibase.statement.core.DropProcedureStatement;
import liquibase.statement.core.DropSequenceStatement;
import liquibase.statement.core.DropTableStatement;
import liquibase.statement.core.DropViewStatement;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e4A!\u0001\u0002\u0001\u0017\t1\u0002\f\u0014*fY\u0016\f7/\u001a#c\u0013:LG/[1mSj,'O\u0003\u0002\u0004\t\u0005\u0011AM\u0019\u0006\u0003\u000b\u0019\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005\u001dA\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005I\u0011aA2p[\u000e\u00011c\u0001\u0001\r%A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"a\u0005\r\u000e\u0003QQ!!\u0006\f\u0002\u000bMdg\r\u000e6\u000b\u0003]\t\u0001b\u001a:jujdW\rZ\u0005\u00033Q\u0011q\u0001T8hO&tw\r\u0003\u0005\u001c\u0001\t\u0015\r\u0011\"\u0001\u001d\u0003!!'mQ8oM&<W#A\u000f\u0011\u0005y)cBA\u0010$!\t\u0001c\"D\u0001\"\u0015\t\u0011#\"\u0001\u0004=e>|GOP\u0005\u0003I9\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0014(\u0005\u0019\u0019FO]5oO*\u0011AE\u0004\u0005\tS\u0001\u0011\t\u0011)A\u0005;\u0005IAMY\"p]\u001aLw\r\t\u0005\tW\u0001\u0011)\u0019!C\u0001Y\u0005QA-\u0019;b'>,(oY3\u0016\u00035\u0002\"AL\u001a\u000e\u0003=R!\u0001M\u0019\u0002\u0007M\fHNC\u00013\u0003\u0015Q\u0017M^1y\u0013\t!tF\u0001\u0006ECR\f7k\\;sG\u0016D\u0001B\u000e\u0001\u0003\u0002\u0003\u0006I!L\u0001\fI\u0006$\u0018mU8ve\u000e,\u0007\u0005C\u00039\u0001\u0011\u0005\u0011(\u0001\u0004=S:LGO\u0010\u000b\u0004uqj\u0004CA\u001e\u0001\u001b\u0005\u0011\u0001\"B\u000e8\u0001\u0004i\u0002\"B\u00168\u0001\u0004i\u0003\"B \u0001\t\u0003\u0001\u0015\u0001B5oSR$\u0012!\u0011\t\u0003\u001b\tK!a\u0011\b\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u000b\u0002!\t\u0001Q\u0001\bIJ|\u0007/\u00117m\u0011\u00159\u0005\u0001\"\u0001A\u00031!'o\u001c9NsR\u000b'\r\\3t\u0011\u0015I\u0005\u0001\"\u0003K\u0003Aawn\u001a#s_B\u001cF/\u0019;f[\u0016tG\u000f\u0006\u0002B\u0017\")A\n\u0013a\u0001\u001b\u0006iAM]8q'R\fG/Z7f]R\u0004\"AT*\u000e\u0003=S!\u0001U)\u0002\u0013M$\u0018\r^3nK:$(\"\u0001*\u0002\u00131L\u0017/^5cCN,\u0017B\u0001+P\u00051\u0019\u0016\u000f\\*uCR,W.\u001a8u\u0011\u00151\u0006\u0001\"\u0003X\u0003Q\u0019'/Z1uK\u0012\u0013x\u000e]*uCR,W.\u001a8ugR\u0011\u0001,\u0019\t\u00043zkeB\u0001.]\u001d\t\u00013,C\u0001\u0010\u0013\tif\"A\u0004qC\u000e\\\u0017mZ3\n\u0005}\u0003'aA*fc*\u0011QL\u0004\u0005\u0006EV\u0003\raY\u0001\u0012I\u0006$\u0018MY1tK\u000eC\u0017M\\4f\u0019><\u0007C\u00013h\u001b\u0005)'B\u00014R\u0003%\u0019\u0007.\u00198hK2|w-\u0003\u0002iK\n\tB)\u0019;bE\u0006\u001cXm\u00115b]\u001e,Gj\\4\t\u000b)\u0004A\u0011B6\u00027\u0011,G.\u001a;f\t\u0006$\u0018MY1tK\u000eC\u0017M\\4f\u0019><'k\\<t)\t\tE\u000eC\u0003SS\u0002\u0007Q\u000e\u0005\u0002o_6\t\u0011+\u0003\u0002q#\nIA*[9vS\n\f7/\u001a\u0005\u0006e\u0002!Ia]\u0001\u0010I><\u0016\u000e\u001e5MSF,\u0018NY1tKR\u0011\u0011\t\u001e\u0005\u0006kF\u0004\rA^\u0001\tG\u0006dGNY1dWB!Qb^7B\u0013\tAhBA\u0005Gk:\u001cG/[8oc\u0001")
public class XLReleaseDbInitializer
implements Logging {
    private final String dbConfig;
    private final DataSource dataSource;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        XLReleaseDbInitializer xLReleaseDbInitializer = this;
        synchronized (xLReleaseDbInitializer) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public String dbConfig() {
        return this.dbConfig;
    }

    public DataSource dataSource() {
        return this.dataSource;
    }

    public void init() {
        this.doWithLiquibase((Function1<Liquibase, BoxedUnit>)(Function1 & Serializable & scala.Serializable)liquibase -> {
            liquibase.update("");
            return BoxedUnit.UNIT;
        });
    }

    public void dropAll() {
        this.doWithLiquibase((Function1<Liquibase, BoxedUnit>)(Function1 & Serializable & scala.Serializable)liquibase -> {
            liquibase.dropAll();
            return BoxedUnit.UNIT;
        });
    }

    public void dropMyTables() {
        this.doWithLiquibase((Function1<Liquibase, BoxedUnit>)(Function1 & Serializable & scala.Serializable)liquibase -> {
            XLReleaseDbInitializer.$anonfun$dropMyTables$1(this, liquibase);
            return BoxedUnit.UNIT;
        });
    }

    private void logDropStatement(SqlStatement dropStatement) {
        String string;
        SqlStatement sqlStatement = dropStatement;
        if (sqlStatement instanceof DropTableStatement) {
            DropTableStatement dropTableStatement = (DropTableStatement)sqlStatement;
            string = dropTableStatement.getTableName();
        } else if (sqlStatement instanceof DropForeignKeyConstraintStatement) {
            DropForeignKeyConstraintStatement dropForeignKeyConstraintStatement = (DropForeignKeyConstraintStatement)sqlStatement;
            string = dropForeignKeyConstraintStatement.getConstraintName();
        } else if (sqlStatement instanceof DropViewStatement) {
            DropViewStatement dropViewStatement = (DropViewStatement)sqlStatement;
            string = dropViewStatement.getViewName();
        } else if (sqlStatement instanceof DropSequenceStatement) {
            DropSequenceStatement dropSequenceStatement = (DropSequenceStatement)sqlStatement;
            string = dropSequenceStatement.getSequenceName();
        } else if (sqlStatement instanceof DropProcedureStatement) {
            DropProcedureStatement dropProcedureStatement = (DropProcedureStatement)sqlStatement;
            string = dropProcedureStatement.getProcedureName();
        } else {
            string = sqlStatement.toString();
        }
        String entityName = string;
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dropping ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entityName})));
    }

    private Seq<SqlStatement> createDropStatements(DatabaseChangeLog databaseChangeLog) {
        List changeSets = databaseChangeLog.getChangeSets();
        return (Seq)((SeqLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(changeSets).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$1.getChanges()).asScala(), Buffer$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Seq seq;
            Change change = x0$2;
            if (change instanceof CreateTableChange) {
                CreateTableChange createTableChange = (CreateTableChange)change;
                Buffer dropStatements = (Buffer)((TraversableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(createTableChange.getColumns()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)XLReleaseDbInitializer.$anonfun$createDropStatements$3(x$2)))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)XLReleaseDbInitializer.$anonfun$createDropStatements$4(x$3)))).map((Function1 & Serializable & scala.Serializable)col -> new DropForeignKeyConstraintStatement(createTableChange.getCatalogName(), createTableChange.getSchemaName(), createTableChange.getTableName(), col.getConstraints().getForeignKeyName()), Buffer$.MODULE$.canBuildFrom());
                seq = (Seq)dropStatements.$colon$plus((Object)new DropTableStatement(createTableChange.getCatalogName(), createTableChange.getSchemaName(), createTableChange.getTableName(), true), Buffer$.MODULE$.canBuildFrom());
            } else if (change instanceof RenameTableChange) {
                RenameTableChange renameTableChange = (RenameTableChange)change;
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DropTableStatement[]{new DropTableStatement(renameTableChange.getCatalogName(), renameTableChange.getSchemaName(), renameTableChange.getNewTableName(), true)}));
            } else if (change instanceof AddForeignKeyConstraintChange) {
                AddForeignKeyConstraintChange addForeignKeyConstraintChange = (AddForeignKeyConstraintChange)change;
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DropForeignKeyConstraintStatement[]{new DropForeignKeyConstraintStatement(addForeignKeyConstraintChange.getBaseTableCatalogName(), addForeignKeyConstraintChange.getBaseTableSchemaName(), addForeignKeyConstraintChange.getBaseTableName(), addForeignKeyConstraintChange.getConstraintName())}));
            } else if (change instanceof CreateViewChange) {
                CreateViewChange createViewChange = (CreateViewChange)change;
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DropViewStatement[]{new DropViewStatement(createViewChange.getCatalogName(), createViewChange.getSchemaName(), createViewChange.getViewName())}));
            } else if (change instanceof CreateSequenceChange) {
                CreateSequenceChange createSequenceChange = (CreateSequenceChange)change;
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DropSequenceStatement[]{new DropSequenceStatement(createSequenceChange.getCatalogName(), createSequenceChange.getSchemaName(), createSequenceChange.getSequenceName())}));
            } else if (change instanceof CreateProcedureChange) {
                CreateProcedureChange createProcedureChange = (CreateProcedureChange)change;
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DropProcedureStatement[]{new DropProcedureStatement(createProcedureChange.getCatalogName(), createProcedureChange.getSchemaName(), createProcedureChange.getProcedureName())}));
            } else {
                seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
            return seq;
        }, Buffer$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToInteger((int)XLReleaseDbInitializer.$anonfun$createDropStatements$6(x0$3)), (Ordering)Ordering.Int$.MODULE$);
    }

    private void deleteDatabaseChangeLogRows(Liquibase liquibase) {
        Database database = liquibase.getDatabase();
        liquibase.getDatabaseChangeLog().getChangeSets().forEach(changeSet -> {
            DeleteStatement deleteStatement = new DeleteStatement(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName(), database.getDatabaseChangeLogTableName());
            deleteStatement.setWhere("FILENAME = ?");
            deleteStatement.addWhereParameter((Object)changeSet.getFilePath());
            try {
                try {
                    ExecutorService.getInstance().getExecutor(database).execute((SqlStatement)deleteStatement);
                }
                catch (DatabaseException e) {
                    this.logger().debug((Function0 & Serializable & scala.Serializable)() -> e.getMessage());
                }
            }
            finally {
                database.commit();
            }
        });
    }

    private void doWithLiquibase(Function1<Liquibase, BoxedUnit> callback) {
        try (Connection connection = this.dataSource().getConnection();){
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));
            Liquibase liquibase = new Liquibase(this.dbConfig(), (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
            callback.apply((Object)liquibase);
        }
    }

    public static final /* synthetic */ boolean $anonfun$dropMyTables$2(boolean doExecDropSequencesAndTriggers$1, SqlStatement x0$1) {
        SqlStatement sqlStatement = x0$1;
        boolean bl = sqlStatement instanceof DropSequenceStatement ? true : sqlStatement instanceof DropProcedureStatement;
        boolean bl2 = bl ? doExecDropSequencesAndTriggers$1 : true;
        return bl2;
    }

    public static final /* synthetic */ void $anonfun$dropMyTables$3(XLReleaseDbInitializer $this, Database database$1, SqlStatement dropStatement) {
        try {
            $this.logDropStatement(dropStatement);
            ExecutorService.getInstance().getExecutor(database$1).execute(dropStatement);
        }
        catch (DatabaseException e) {
            $this.logger().debug((Function0 & Serializable & scala.Serializable)() -> e.getMessage());
        }
    }

    public static final /* synthetic */ void $anonfun$dropMyTables$1(XLReleaseDbInitializer $this, Liquibase liquibase) {
        block0: {
            Database database = liquibase.getDatabase();
            boolean doExecDropSequencesAndTriggers = database.getDatabaseProductName().toLowerCase().contains("oracle");
            Seq dropsStatements = (Seq)$this.createDropStatements(liquibase.getDatabaseChangeLog()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)XLReleaseDbInitializer.$anonfun$dropMyTables$2(doExecDropSequencesAndTriggers, x0$1)));
            boolean enableForeignKeys = database.supportsForeignKeyDisable() && database.disableForeignKeyChecks();
            dropsStatements.foreach((Function1 & Serializable & scala.Serializable)dropStatement -> {
                XLReleaseDbInitializer.$anonfun$dropMyTables$3($this, database, dropStatement);
                return BoxedUnit.UNIT;
            });
            $this.deleteDatabaseChangeLogRows(liquibase);
            if (!enableForeignKeys) break block0;
            liquibase.getDatabase().enableForeignKeyChecks();
        }
    }

    public static final /* synthetic */ boolean $anonfun$createDropStatements$3(ColumnConfig x$2) {
        return x$2.getConstraints() != null;
    }

    public static final /* synthetic */ boolean $anonfun$createDropStatements$4(ColumnConfig x$3) {
        return x$3.getConstraints().getForeignKeyName() != null;
    }

    public static final /* synthetic */ int $anonfun$createDropStatements$6(AbstractSqlStatement x0$3) {
        AbstractSqlStatement abstractSqlStatement = x0$3;
        int n = abstractSqlStatement instanceof DropForeignKeyConstraintStatement ? 0 : (abstractSqlStatement instanceof DropViewStatement ? 0 : 1);
        return n;
    }

    public XLReleaseDbInitializer(String dbConfig, DataSource dataSource) {
        this.dbConfig = dbConfig;
        this.dataSource = dataSource;
        Logging.$init$((Logging)this);
    }
}

