/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.xebialabs.xlrelease.domain.GateCondition;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.GateConditionCreatedEvent;
import com.xebialabs.xlrelease.domain.events.GateConditionDeletedEvent;
import com.xebialabs.xlrelease.domain.events.GateConditionUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.GateConditionRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GateConditionService {
    private static final String DEFAULT_TITLE = "New Condition";
    private CiIdService ciIdService;
    private GateConditionRepository gateConditionRepository;
    private XLReleaseEventBus eventBus;
    private TaskRepository taskRepository;

    @Autowired
    public GateConditionService(CiIdService ciIdService, XLReleaseEventBus eventBus, TaskRepository taskRepository, GateConditionRepository gateConditionRepository) {
        this.ciIdService = ciIdService;
        this.eventBus = eventBus;
        this.gateConditionRepository = gateConditionRepository;
        this.taskRepository = taskRepository;
    }

    @Timed
    public GateCondition create(String parentId) {
        return this.create(parentId, DEFAULT_TITLE);
    }

    @Timed
    public GateCondition create(String gateId, String text) {
        GateTask gate = (GateTask)this.taskRepository.findById(gateId);
        Preconditions.checkArgument((boolean)gate.isUpdatable(), (Object)"You can't add a condition to a finished gate");
        GateCondition condition = new GateCondition();
        condition.setId(this.ciIdService.getUniqueId(condition.getType(), gateId));
        condition.setTitle(text);
        gate.addCondition(condition);
        List<Variable> variables = this.updateVariables(gate);
        this.gateConditionRepository.create(condition, variables);
        this.eventBus.publish((XLReleaseEvent)new GateConditionCreatedEvent(gate, condition));
        return condition;
    }

    @Timed
    public GateCondition findById(String conditionId) {
        return this.gateConditionRepository.findById(conditionId);
    }

    @Timed
    public GateCondition update(String conditionId, GateCondition updatedCondition) {
        String gateId = Ids.getParentId((String)updatedCondition.getId());
        GateTask gate = (GateTask)this.taskRepository.findById(gateId);
        Preconditions.checkArgument((boolean)gate.isUpdatable(), (Object)"You can't update a condition of a finished gate.");
        GateCondition condition = gate.getCondition(conditionId);
        GateCondition originalCondition = CiCloneHelper.cloneCi(condition);
        condition.setChecked(updatedCondition.isChecked());
        condition.setTitle(updatedCondition.getTitle());
        List<Variable> variables = this.updateVariables(gate);
        this.gateConditionRepository.update(updatedCondition, variables);
        this.eventBus.publish((XLReleaseEvent)new GateConditionUpdatedEvent(gate, originalCondition, updatedCondition));
        return updatedCondition;
    }

    private List<Variable> updateVariables(GateTask gate) {
        Release release = gate.getRelease();
        return VariablePersistenceHelper.scanAndBuildNewVariables(release, (VisitableItem)gate, this.ciIdService);
    }

    @Timed
    public void delete(String conditionId) {
        String gateId = Ids.getParentId((String)conditionId);
        GateTask gate = (GateTask)this.taskRepository.findById(gateId);
        Preconditions.checkArgument((boolean)gate.isUpdatable(), (Object)"You can't delete a condition from a finished gate");
        GateCondition gateCondition = this.findById(conditionId);
        this.gateConditionRepository.delete(gateCondition);
        this.eventBus.publish((XLReleaseEvent)new GateConditionDeletedEvent(gate, gateCondition));
    }
}

