/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.upgrade.json;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.upgrade.Components;
import com.xebialabs.xlrelease.upgrade.ImportUpgrade;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class XLRelease451ImportAddTemplateViewersFields
implements ImportUpgrade {
    private static final String VERSION = "4.5.1";

    @Override
    public List<String> performUpgrade(JSONObject release) throws JSONException {
        JSONArray teams = release.getJSONArray("teams");
        ArrayList memberViewers = Lists.newArrayList();
        ArrayList roleViewers = Lists.newArrayList();
        for (int i = 0; i < teams.length(); ++i) {
            JSONObject team = teams.getJSONObject(i);
            JSONArray permissions = team.getJSONArray("permissions");
            if (!this.containsPermissions(permissions, XLReleasePermissions.VIEW_TEMPLATE.getPermissionName())) continue;
            JSONArray members = team.getJSONArray("members");
            memberViewers.addAll(this.getStrings(members));
            JSONArray roles = team.getJSONArray("roles");
            roleViewers.addAll(this.getStrings(roles));
        }
        release.put("memberViewers", (Collection)memberViewers);
        release.put("roleViewers", (Collection)roleViewers);
        return Lists.newArrayList();
    }

    private List<String> getStrings(JSONArray jsonArrayOfStrings) throws JSONException {
        ArrayList strings = Lists.newArrayList();
        for (int i = 0; i < jsonArrayOfStrings.length(); ++i) {
            strings.add(jsonArrayOfStrings.getString(i));
        }
        return strings;
    }

    private boolean containsPermissions(JSONArray permissions, String permissionName) throws JSONException {
        for (int i = 0; i < permissions.length(); ++i) {
            String permission = permissions.getString(i);
            if (!permission.equals(permissionName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Version getUpgradeVersion() {
        return Version.valueOf((String)Components.XL_RELEASE_COMPONENT, (String)VERSION);
    }
}

