/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.upgrade.RepositoryInitializer;
import com.xebialabs.deployit.upgrade.UpgradeRejectedException;
import com.xebialabs.deployit.upgrade.Upgrader;
import com.xebialabs.xlplatform.spring.JythonBindingsHolder;
import com.xebialabs.xlrelease.actors.cluster.XlrActorSystem;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.XLReleaseServiceHolder;
import com.xebialabs.xlrelease.db.XLReleaseDbInitializer;
import com.xebialabs.xlrelease.script.bindings.SecurityApiBinding;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ServiceStarter {
    private final Upgrader upgrader;
    private final RepositoryInitializer repositoryInitializer;
    private final XlrActorSystem xlrActorSystem;
    private XLReleaseDbInitializer xlrMigrationsDbInitializer;
    private XLReleaseDbInitializer xlrRepositoryDbInitializer;
    private XLReleaseDbInitializer reportingDbInitializer;
    private List<? extends ApiService> apiServices;
    private static final Logger logger = LoggerFactory.getLogger(ServiceStarter.class);

    @Autowired
    public ServiceStarter(Upgrader upgrader, RepositoryInitializer repositoryInitializer, XlrActorSystem xlrActorSystem, @Qualifier(value="xlrMigrationsDbInitializer") XLReleaseDbInitializer xlrMigrationsDbInitializer, @Qualifier(value="xlrRepositoryDbInitializer") XLReleaseDbInitializer xlrRepositoryDbInitializer, @Qualifier(value="reportingDbInitializer") XLReleaseDbInitializer reportingDbInitializer) {
        this.upgrader = upgrader;
        this.repositoryInitializer = repositoryInitializer;
        this.xlrActorSystem = xlrActorSystem;
        this.xlrMigrationsDbInitializer = xlrMigrationsDbInitializer;
        this.xlrRepositoryDbInitializer = xlrRepositoryDbInitializer;
        this.reportingDbInitializer = reportingDbInitializer;
    }

    @Autowired
    public void setApiServices(List<? extends ApiService> apiServices) {
        this.apiServices = apiServices;
    }

    @PostConstruct
    public void startServices() {
        XLReleaseServiceHolder.init(this.apiServices);
        this.initEndpointsJythonBindings(this.apiServices);
        this.xlrMigrationsDbInitializer.init();
        this.xlrRepositoryDbInitializer.init();
        this.reportingDbInitializer.init();
        this.repositoryInitializer.initializeComponents();
        try {
            this.upgrader.autoUpgrade();
        }
        catch (UpgradeRejectedException e) {
            logger.warn("Upgrade rejected: {}", (Object)e.getMessage());
            return;
        }
        this.xlrActorSystem.boot();
    }

    private void initEndpointsJythonBindings(List<? extends ApiService> apiServices) {
        HashMap<String, SecurityApiBinding> bindings = new HashMap<String, SecurityApiBinding>();
        bindings.put(SecurityApiBinding.NAME, new SecurityApiBinding());
        apiServices.forEach(apiService -> bindings.put(apiService.serviceName(), (SecurityApiBinding)apiService));
        JythonBindingsHolder.setBindings(Collections.unmodifiableMap(bindings));
    }
}

