/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service.blackout;

import akka.actor.Actor;
import akka.actor.ActorRef;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.ReleaseExecutionActor;
import com.xebialabs.xlrelease.actors.ReleaseExecutionActorMessages;
import com.xebialabs.xlrelease.actors.extension.ActorExtensionHandlerFactory;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata$;
import com.xebialabs.xlrelease.domain.blackout.BlackoutPeriod;
import com.xebialabs.xlrelease.domain.events.BlackoutDeletedEvent;
import com.xebialabs.xlrelease.domain.events.BlackoutUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.EventBus;
import com.xebialabs.xlrelease.domain.events.TaskUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.repository.CalendarSearchStrategy;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.TaskGetCommand;
import com.xebialabs.xlrelease.repository.TaskUpdateCommand;
import com.xebialabs.xlrelease.repository.TasksAffectedByBlackout;
import com.xebialabs.xlrelease.repository.XlrQueries;
import com.xebialabs.xlrelease.repository.XlrRepository;
import com.xebialabs.xlrelease.service.blackout.BlackoutReleaseExecutionActorMessages;
import com.xebialabs.xlrelease.service.blackout.BlackoutTaskEventHandler$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import nl.javadude.t2bus.AllowConcurrentEvents;
import nl.javadude.t2bus.Subscribe;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@Service
@ScalaSignature(bytes="\u0006\u0001\t-c\u0001B\u0001\u0003\u00015\u0011\u0001D\u00117bG.|W\u000f\u001e+bg.,e/\u001a8u\u0011\u0006tG\r\\3s\u0015\t\u0019A!\u0001\u0005cY\u0006\u001c7n\\;u\u0015\t)a!A\u0004tKJ4\u0018nY3\u000b\u0005\u001dA\u0011!\u0003=me\u0016dW-Y:f\u0015\tI!\"A\u0005yK\nL\u0017\r\\1cg*\t1\"A\u0002d_6\u001c\u0001a\u0005\u0003\u0001\u001dQa\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u001655\taC\u0003\u0002\u00181\u0005IQ\r\u001f;f]NLwN\u001c\u0006\u00033\u0019\ta!Y2u_J\u001c\u0018BA\u000e\u0017\u0005q\t5\r^8s\u000bb$XM\\:j_:D\u0015M\u001c3mKJ4\u0015m\u0019;pef\u0004\"!\b\u0012\u000e\u0003yQ!a\b\u0011\u0002\u000bMdg\r\u000e6\u000b\u0003\u0005\n\u0001b\u001a:jujdW\rZ\u0005\u0003Gy\u0011q\u0001T8hO&tw\r\u0003\u0005&\u0001\t\u0015\r\u0011\"\u0001'\u0003!)g/\u001a8u\u0005V\u001cX#A\u0014\u0011\u0005!jS\"A\u0015\u000b\u0005)Z\u0013AB3wK:$8O\u0003\u0002-\r\u00051Am\\7bS:L!AL\u0015\u0003\u0011\u00153XM\u001c;CkND\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006IaJ\u0001\nKZ,g\u000e\u001e\"vg\u0002B\u0001B\r\u0001\u0003\u0006\u0004%\taM\u0001\u0017G\u0006dWM\u001c3beN+\u0017M]2i'R\u0014\u0018\r^3hsV\tA\u0007\u0005\u00026q5\taG\u0003\u00028\r\u0005Q!/\u001a9pg&$xN]=\n\u0005e2$AF\"bY\u0016tG-\u0019:TK\u0006\u00148\r[*ue\u0006$XmZ=\t\u0011m\u0002!\u0011!Q\u0001\nQ\nqcY1mK:$\u0017M]*fCJ\u001c\u0007n\u0015;sCR,w-\u001f\u0011\t\u0011u\u0002!Q1A\u0005\u0002y\n1C]3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016,\u0012a\u0010\t\u0003\u0001\u0006k\u0011\u0001G\u0005\u0003\u0005b\u00111CU3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016D\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006IaP\u0001\u0015e\u0016dW-Y:f\u0003\u000e$xN]*feZL7-\u001a\u0011\t\u0011\u0019\u0003!Q1A\u0005\u0002\u001d\u000bQ\u0002\u001f7s%\u0016\u0004xn]5u_JLX#\u0001%\u0011\u0005UJ\u0015B\u0001&7\u00055AFN\u001d*fa>\u001c\u0018\u000e^8ss\"AA\n\u0001B\u0001B\u0003%\u0001*\u0001\byYJ\u0014V\r]8tSR|'/\u001f\u0011\t\u00119\u0003!Q1A\u0005\u0002=\u000b!\u0002\u001f7s#V,'/[3t+\u0005\u0001\u0006CA\u001bR\u0013\t\u0011fG\u0001\u0006YYJ\fV/\u001a:jKND\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006I\u0001U\u0001\fq2\u0014\u0018+^3sS\u0016\u001c\b\u0005C\u0003W\u0001\u0011\u0005q+\u0001\u0004=S:LGO\u0010\u000b\u00071j[F,\u00180\u0011\u0005e\u0003Q\"\u0001\u0002\t\u000b\u0015*\u0006\u0019A\u0014\t\u000bI*\u0006\u0019\u0001\u001b\t\u000bu*\u0006\u0019A \t\u000b\u0019+\u0006\u0019\u0001%\t\u000b9+\u0006\u0019\u0001))\u0005U\u0003\u0007CA1m\u001b\u0005\u0011'BA2e\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003K\u001a\fqAZ1di>\u0014\u0018P\u0003\u0002hQ\u0006)!-Z1og*\u0011\u0011N[\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t1.A\u0002pe\u001eL!!\u001c2\u0003\u0013\u0005+Ho\\<je\u0016$\u0007\"B8\u0001\t\u0003\u0001\u0018\u0001\u0003:fO&\u001cH/\u001a:\u0015\u0003E\u0004\"a\u0004:\n\u0005M\u0004\"\u0001B+oSRD#A\\;\u0011\u0005YTX\"A<\u000b\u0005\rD(\"A=\u0002\u000b)\fg/\u0019=\n\u0005m<(!\u0004)pgR\u001cuN\\:ueV\u001cG\u000fC\u0003~\u0001\u0011\u0005\u0001/\u0001\u0006v]J,w-[:uKJD#\u0001`@\u0011\u0007Y\f\t!C\u0002\u0002\u0004]\u0014!\u0002\u0015:f\t\u0016\u001cHO]8z\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013\t\u0011c\u001c8CY\u0006\u001c7n\\;u+B$\u0017\r^3e)\r\t\u00181\u0002\u0005\t\u0003\u001b\t)\u00011\u0001\u0002\u0010\u0005)QM^3oiB\u0019\u0001&!\u0005\n\u0007\u0005M\u0011F\u0001\u000bCY\u0006\u001c7n\\;u+B$\u0017\r^3e\u000bZ,g\u000e\u001e\u0015\u0005\u0003\u000b\t9\u0002\u0005\u0003\u0002\u001a\u0005\u001dRBAA\u000e\u0015\u0011\ti\"a\b\u0002\u000bQ\u0014$-^:\u000b\t\u0005\u0005\u00121E\u0001\tU\u00064\u0018\rZ;eK*\u0011\u0011QE\u0001\u0003]2LA!!\u000b\u0002\u001c\t)\u0012\t\u001c7po\u000e{gnY;se\u0016tG/\u0012<f]R\u001c\b\u0006BA\u0003\u0003[\u0001B!!\u0007\u00020%!\u0011\u0011GA\u000e\u0005%\u0019VOY:de&\u0014W\rC\u0004\u00026\u0001!\t!a\u000e\u0002#=t'\t\\1dW>,H\u000fR3mKR,G\rF\u0002r\u0003sA\u0001\"!\u0004\u00024\u0001\u0007\u00111\b\t\u0004Q\u0005u\u0012bAA S\t!\"\t\\1dW>,H\u000fR3mKR,G-\u0012<f]RDC!a\r\u0002\u0018!\"\u00111GA\u0017\u0011\u001d\t9\u0005\u0001C\u0005\u0003\u0013\n\u0001#[:BM\u001a,7\r^5oOR\u000b7o[:\u0015\r\u0005-\u0013\u0011KA*!\ry\u0011QJ\u0005\u0004\u0003\u001f\u0002\"a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003\u001b\t)\u00051\u0001\u0002\u0010!A\u0011QKA#\u0001\u0004\t9&A\u0002o_^\u0004B!!\u0017\u0002d5\u0011\u00111\f\u0006\u0005\u0003;\ny&\u0001\u0003vi&d'BAA1\u0003\u0011Q\u0017M^1\n\t\u0005\u0015\u00141\f\u0002\u0005\t\u0006$X\rC\u0004\u0002j\u0001!I!a\u001b\u0002%M\u001c\u0007.\u001a3vY\u0016$\u0016m]6Va\u0012\fG/\u001a\u000b\u0006c\u00065\u0014q\u0011\u0005\t\u0003_\n9\u00071\u0001\u0002r\u00051A/Y:l\u0013\u0012\u0004B!a\u001d\u0002\u0002:!\u0011QOA?!\r\t9\bE\u0007\u0003\u0003sR1!a\u001f\r\u0003\u0019a$o\\8u}%\u0019\u0011q\u0010\t\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019)!\"\u0003\rM#(/\u001b8h\u0015\r\ty\b\u0005\u0005\t\u0003\u0013\u000b9\u00071\u0001\u0002\f\u000691m\\7nC:$\u0007\u0003BAG\u0003GsA!a$\u0002 :!\u0011\u0011SAO\u001d\u0011\t\u0019*a'\u000f\t\u0005U\u0015\u0011\u0014\b\u0005\u0003o\n9*C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0011\u0011DB\u0005\u0004\u0003CC\u0012!\b*fY\u0016\f7/Z#yK\u000e,H/[8o\u0003\u000e$xN]'fgN\fw-Z:\n\t\u0005\u0015\u0016q\u0015\u0002\u0011\u000bb$XM\\:j_:\u001cu.\\7b]\u0012T1!!)\u0019\u0011\u001d\tY\u000b\u0001C!\u0003[\u000b!bZ3u\u0011\u0006tG\r\\3s)\u0019\ty+!4\u0002`B!\u0011\u0011WAd\u001d\u0011\t\u0019,!1\u000f\t\u0005U\u00161\u0018\b\u0005\u0003o\n9,\u0003\u0002\u0002:\u0006!\u0011m[6b\u0013\u0011\ti,a0\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0005\u0005e\u0016\u0002BAb\u0003\u000b\fQ!Q2u_JTA!!0\u0002@&!\u0011\u0011ZAf\u0005\u001d\u0011VmY3jm\u0016TA!a1\u0002F\"A\u0011qZAU\u0001\u0004\t\t.\u0001\u0004tK:$WM\u001d\t\u0006\u001f\u0005M\u0017q[\u0005\u0004\u0003+\u0004\"!\u0003$v]\u000e$\u0018n\u001c81!\u0011\tI.a7\u000e\u0005\u0005\u0015\u0017\u0002BAo\u0003\u000b\u0014\u0001\"Q2u_J\u0014VM\u001a\u0005\t\u0003C\fI\u000b1\u0001\u0002r\u0005I!/\u001a7fCN,\u0017\n\u001a\u0005\b\u0003K\u0004A\u0011BAt\u00039)\b\u000fZ1uKR\u000b7o[,ji\"$B!!;\u0002~R\u0019\u0011/a;\t\u0011\u00055\u00181\u001da\u0001\u0003_\fq!\u001e9eCR,'\u000f\u0005\u0004\u0010\u0003c\f)0]\u0005\u0004\u0003g\u0004\"!\u0003$v]\u000e$\u0018n\u001c82!\u0011\t90!?\u000e\u0003-J1!a?,\u0005\u0011!\u0016m]6\t\u0011\u0005=\u00141\u001da\u0001\u0003cBqA!\u0001\u0001\t\u0013\u0011\u0019!\u0001\rva\u0012\fG/Z*dQ\u0016$W\u000f\\3e'R\f'\u000f\u001e#bi\u0016$R!\u001dB\u0003\u0005\u0013A\u0001Ba\u0002\u0002\u0000\u0002\u0007\u0011Q_\u0001\u0005i\u0006\u001c8\u000e\u0003\u0005\u0003\f\u0005}\b\u0019AA,\u0003UqWm^*dQ\u0016$W\u000f\\3e'R\f'\u000f\u001e#bi\u0016DqAa\u0004\u0001\t\u0013\u0011\t\"A\fsKN,GoU2iK\u0012,H.\u001a3Ti\u0006\u0014H\u000fR1uKR\u0019\u0011Oa\u0005\t\u0011\t\u001d!Q\u0002a\u0001\u0003kDqAa\u0006\u0001\t\u0003\u0012I\"\u0001\u0005tkB\u0004xN\u001d;t)\u0011\tYEa\u0007\t\u0011\tu!Q\u0003a\u0001\u0005?\tQa\u00197buj\u0004DA!\t\u0003,A1\u00111\u000fB\u0012\u0005OIAA!\n\u0002\u0006\n)1\t\\1tgB!!\u0011\u0006B\u0016\u0019\u0001!AB!\f\u0003\u001c\u0005\u0005\t\u0011!B\u0001\u0005_\u00111a\u0018\u00132#\u0011\u0011\tDa\u000e\u0011\u0007=\u0011\u0019$C\u0002\u00036A\u0011qAT8uQ&tw\r\u0005\u0003\u0002Z\ne\u0012\u0002\u0002B\u001e\u0003\u000b\u0014Q!Q2u_JD3\u0001\u0001B !\u0011\u0011\tEa\u0012\u000e\u0005\t\r#b\u0001B#Q\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\t%#1\t\u0002\b'\u0016\u0014h/[2f\u0001")
public class BlackoutTaskEventHandler
implements ActorExtensionHandlerFactory,
Logging {
    private final EventBus eventBus;
    private final CalendarSearchStrategy calendarSearchStrategy;
    private final ReleaseActorService releaseActorService;
    private final XlrRepository xlrRepository;
    private final XlrQueries xlrQueries;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public <T> void replyOrFail(Function0<ActorRef> sender, Function0<T> call) {
        ActorExtensionHandlerFactory.replyOrFail$(this, sender, call);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        BlackoutTaskEventHandler blackoutTaskEventHandler = this;
        synchronized (blackoutTaskEventHandler) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    public CalendarSearchStrategy calendarSearchStrategy() {
        return this.calendarSearchStrategy;
    }

    public ReleaseActorService releaseActorService() {
        return this.releaseActorService;
    }

    public XlrRepository xlrRepository() {
        return this.xlrRepository;
    }

    public XlrQueries xlrQueries() {
        return this.xlrQueries;
    }

    @PostConstruct
    public void register() {
        this.eventBus().register((Object)this);
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Blackout task event handler registered in event bus.");
    }

    @PreDestroy
    public void unregister() {
        this.eventBus().deregister((Object)this);
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Blackout task event handler de-registered from event bus.");
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onBlackoutUpdated(BlackoutUpdatedEvent event) {
        block0: {
            Date now = new Date();
            if (!this.isAffectingTasks(event, now)) break block0;
            Seq<String> taskIds = this.xlrQueries().query(new TasksAffectedByBlackout(event.original()));
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " taskIds to be updated after blackout ", " update."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)taskIds.length()), event.original().getLabel()})));
            BlackoutMetadata metadata = BlackoutMetadata$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BlackoutPeriod[]{new BlackoutPeriod(event.updated().getStartDate(), event.updated().getEndDate())})));
            boolean isInBlackout = metadata.isInBlackout(now);
            Date newScheduledStartDate = metadata.getEndOfBlackout(now);
            taskIds.foreach((Function1 & Serializable & scala.Serializable)taskId -> {
                this.scheduleTaskUpdate(taskId, isInBlackout ? new BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate(taskId, newScheduledStartDate) : new BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate(taskId));
                return BoxedUnit.UNIT;
            });
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onBlackoutDeleted(BlackoutDeletedEvent event) {
        Seq<String> taskIds = this.xlrQueries().query(new TasksAffectedByBlackout(event.blackout()));
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " taskIds to be started after blackout ", " removal."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)taskIds.length()), event.blackout().getLabel()})));
        taskIds.foreach((Function1 & Serializable & scala.Serializable)taskId -> {
            this.scheduleTaskUpdate(taskId, new BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate(taskId));
            return BoxedUnit.UNIT;
        });
    }

    private boolean isAffectingTasks(BlackoutUpdatedEvent event, Date now) {
        Date date = event.original().getEndDate();
        Date date2 = event.updated().getEndDate();
        boolean endDateChanged = date == null ? date2 != null : !((Object)date).equals(date2);
        boolean startDateMovedIntoFuture = now.after(event.original().getStartDate()) && now.before(event.updated().getStartDate());
        return endDateChanged || startDateMovedIntoFuture;
    }

    private void scheduleTaskUpdate(String taskId, ReleaseExecutionActorMessages.ExtensionCommand command) {
        this.releaseActorService().executeCommandAsync(taskId, command);
    }

    @Override
    public PartialFunction<Object, BoxedUnit> getHandler(Function0<ActorRef> sender, String releaseId) {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlackoutTaskEventHandler $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate) {
                    BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate updateScheduledStartDate = (BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate)A1;
                    String taskId = updateScheduledStartDate.taskId();
                    Date newScheduledStartDate = updateScheduledStartDate.newScheduledStartDate();
                    this.$outer.com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateTaskWith(taskId, (Function1<Task, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
                        $anonfun$getHandler$1.$anonfun$applyOrElse$1(this, newScheduledStartDate, x$1);
                        return BoxedUnit.UNIT;
                    });
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate) {
                    BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate resetScheduledStartDate = (BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate)A1;
                    String taskId = resetScheduledStartDate.taskId();
                    this.$outer.com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateTaskWith(taskId, (Function1<Task, BoxedUnit>)(Function1 & Serializable & scala.Serializable)task -> {
                        $anonfun$getHandler$1.$anonfun$applyOrElse$2(this, task);
                        return BoxedUnit.UNIT;
                    });
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate ? true : object instanceof BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate;
                return bl;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$1($anonfun$getHandler$1 $this, Date newScheduledStartDate$2, Task x$1) {
                $this.$outer.com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateScheduledStartDate(x$1, newScheduledStartDate$2);
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$2($anonfun$getHandler$1 $this, Task task) {
                $this.$outer.com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$resetScheduledStartDate(task);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(com.xebialabs.xlrelease.service.blackout.BlackoutTaskEventHandler$$anonfun$getHandler$1 java.util.Date com.xebialabs.xlrelease.domain.Task ), $anonfun$applyOrElse$2$adapted(com.xebialabs.xlrelease.service.blackout.BlackoutTaskEventHandler$$anonfun$getHandler$1 com.xebialabs.xlrelease.domain.Task )}, serializedLambda);
            }
        };
    }

    public void com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateTaskWith(String taskId, Function1<Task, BoxedUnit> updater) {
        Task task = (Task)this.xlrRepository().handle(new TaskGetCommand(taskId));
        Task original = CiCloneHelper.cloneCi(task);
        updater.apply((Object)task);
        this.xlrRepository().handle(new TaskUpdateCommand(original, task, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.empty()).asJava(), task.getRelease(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.empty()).asJava()));
        this.eventBus().publish((XLReleaseEvent)new TaskUpdatedEvent(original, task));
    }

    public void com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateScheduledStartDate(Task task, Date newScheduledStartDate) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updating task '", "' scheduled start date due to new blackout end date '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{task.getId(), newScheduledStartDate})));
        Date originalScheduledStartDate = task.getOriginalScheduledStartDate();
        task.setScheduledStartDate(newScheduledStartDate);
        task.setPostponedDueToBlackout(true);
        task.setOriginalScheduledStartDate(originalScheduledStartDate);
    }

    public void com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$resetScheduledStartDate(Task task) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Resetting task '", "' scheduled start date due to blackout not being applicable anymore."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{task.getId()})));
        task.setScheduledStartDate(task.getOriginalScheduledStartDate());
        task.setPostponedDueToBlackout(false);
    }

    @Override
    public boolean supports(Class<? extends Actor> clazz) {
        return ReleaseExecutionActor.class.isAssignableFrom(clazz);
    }

    @Autowired
    public BlackoutTaskEventHandler(EventBus eventBus, CalendarSearchStrategy calendarSearchStrategy, ReleaseActorService releaseActorService, XlrRepository xlrRepository, XlrQueries xlrQueries) {
        this.eventBus = eventBus;
        this.calendarSearchStrategy = calendarSearchStrategy;
        this.releaseActorService = releaseActorService;
        this.xlrRepository = xlrRepository;
        this.xlrQueries = xlrQueries;
        ActorExtensionHandlerFactory.$init$(this);
        Logging.$init$((Logging)this);
    }
}

