/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ScriptTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.repository.Comments;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.repository.TaskTypeConversion;
import com.xebialabs.xlrelease.repository.Tasks;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.ExecutionService;
import com.xebialabs.xlrelease.service.TaskAccessService;
import com.xebialabs.xlrelease.user.User;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskService {
    private Tasks tasks;
    private ExecutionService executionService;
    private Releases releases;
    private Comments comments;
    private PermissionChecker permissions;
    private TaskAccessService taskAccessService;
    private TaskTypeConversion taskTypeConversionService;

    @Autowired
    public TaskService(Tasks tasks, ExecutionService executionService, Releases releases, Comments comments, PermissionChecker permissions, TaskAccessService taskAccessService, TaskTypeConversion taskTypeConversionService) {
        this.tasks = tasks;
        this.executionService = executionService;
        this.releases = releases;
        this.comments = comments;
        this.permissions = permissions;
        this.taskAccessService = taskAccessService;
        this.taskTypeConversionService = taskTypeConversionService;
    }

    public Task updateTaskWith(String taskId, Task updated) {
        Preconditions.checkArgument((updated.getFlagStatus() != null ? 1 : 0) != 0, (Object)"Flag status is required.");
        this.taskAccessService.checkIfAuthenticatedUserCanUseTask(updated);
        Object original = this.tasks.findById(taskId);
        boolean ownerHasBeenReassigned = updated.ownerHasBeenReassigned(original);
        boolean teamHasBeenReassigned = updated.teamHasBeenReassigned(original);
        boolean delayDuringBlackoutHasChanged = updated.delayDuringBlackoutHasChanged(original);
        if (ownerHasBeenReassigned) {
            this.permissions.checkReassignTaskToUser((Task)original, updated.getOwner());
        }
        if (teamHasBeenReassigned) {
            this.permissions.checkReassignTaskPermission(original.getRelease());
        }
        if (delayDuringBlackoutHasChanged) {
            this.permissions.checkEditBlackoutPermission(original.getRelease());
        }
        this.tasks.updateTaskWith((Task)original, updated);
        return this.tasks.findById(original.getId());
    }

    public Task changeTaskType(String taskId, Type newTaskType) {
        this.taskAccessService.checkIfAuthenticatedUserCanUseTask((Task)this.tasks.findById(taskId));
        return this.taskTypeConversionService.changeActiveTaskType(taskId, newTaskType);
    }

    public Task completeTask(String taskId, String commentText) {
        Object task = this.tasks.findById(taskId);
        Release release = task.getRelease();
        if (task.isPlanned()) {
            this.checkIsStatusCompletableInAdvance((Task)task);
            this.checkReleaseIsInProgress(task.getRelease());
            this.executionService.markTaskAsDone(release, TaskStatus.COMPLETED_IN_ADVANCE, taskId, commentText, User.AUTHENTICATED_USER);
        } else {
            this.checkIsStatusUpdatable((Task)task, "complete");
            this.executionService.markTaskAsDone(release, TaskStatus.COMPLETED, taskId, commentText, User.AUTHENTICATED_USER);
        }
        return this.tasks.findById(taskId);
    }

    public List<String> completeTasks(List<String> taskIds, String commentText) {
        return this.executeBulkActionSilently(taskIds, taskId -> this.completeTask((String)taskId, commentText));
    }

    public Task skipTask(String taskId, String commentText) {
        Object task = this.tasks.findById(taskId);
        Release release = task.getRelease();
        if (task.isPlanned()) {
            this.checkIsTaskSkippableInAdvance((Task)task);
            this.checkReleaseIsInProgress(task.getRelease());
            this.executionService.markTaskAsDone(release, TaskStatus.SKIPPED_IN_ADVANCE, taskId, commentText, User.AUTHENTICATED_USER);
        } else {
            this.checkIsTaskSkippable((Task)this.tasks.findById(taskId));
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)commentText) ? 1 : 0) != 0, (Object)"Comment is mandatory when skipping a task.");
            this.executionService.markTaskAsDone(release, TaskStatus.SKIPPED, taskId, commentText, User.AUTHENTICATED_USER);
        }
        return this.tasks.findById(taskId);
    }

    public List<String> skipTasks(List<String> taskIds, String commentText) {
        return this.executeBulkActionSilently(taskIds, taskId -> this.skipTask((String)taskId, commentText));
    }

    public Task failTask(String taskId, String commentText) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)commentText) ? 1 : 0) != 0, (Object)"Comment is mandatory when failing a task.");
        Object task = this.tasks.findById(taskId);
        Preconditions.checkArgument((!this.isScriptOrCustomScriptTask((Task)task) ? 1 : 0) != 0, (Object)"Script tasks can't be failed, they can be aborted");
        this.checkIsStatusUpdatable((Task)task, "fail");
        this.executionService.fail((Task)task, commentText, User.AUTHENTICATED_USER, task.getRelease());
        return task;
    }

    public List<String> failTasks(List<String> taskIds, String commentText) {
        return this.executeBulkActionSilently(taskIds, taskId -> this.failTask((String)taskId, commentText));
    }

    public Task abortTask(String taskId, String commentText) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)commentText) ? 1 : 0) != 0, (Object)"Comment is mandatory when aborting a task.");
        Object task = this.tasks.findById(taskId);
        this.checkCanTaskBeAborted((Task)task);
        this.executionService.abortTask((Task)task, commentText);
        return this.tasks.findById(taskId);
    }

    public List<String> abortTasks(List<String> taskIds, String commentText) {
        return this.executeBulkActionSilently(taskIds, taskId -> this.abortTask((String)taskId, commentText));
    }

    public List<String> reopenTasks(List<String> taskIds, String commentText) {
        return this.executeBulkActionSilently(taskIds, taskId -> this.reopenTask((String)taskId, commentText));
    }

    public Task reopenTask(String taskId, String commentText) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)commentText) ? 1 : 0) != 0, (Object)"Comment is mandatory when starting a pending task.");
        Object task = this.tasks.findById(taskId);
        this.checkCanTaskBeReopen((Task)task);
        this.executionService.reopenTask((Task)task, commentText);
        return this.tasks.findById(taskId);
    }

    public Task retryTask(String taskId, String commentText) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)commentText) ? 1 : 0) != 0, (Object)"Comment is mandatory when retrying a task.");
        Object task = this.tasks.findById(taskId);
        this.checkCanTaskBeRetried((Task)task);
        this.executionService.retry((Task)task, commentText);
        return task;
    }

    public List<String> retryTasks(List<String> taskIds, String commentText) {
        return this.executeBulkActionSilently(taskIds, taskId -> this.retryTask((String)taskId, commentText));
    }

    public Task startPendingTask(String taskId, String commentText) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)commentText) ? 1 : 0) != 0, (Object)"Comment is mandatory when starting a pending task.");
        Object task = this.tasks.findById(taskId);
        this.executionService.startPendingTask(taskId, task.getRelease(), commentText, User.AUTHENTICATED_USER);
        return this.tasks.findById(taskId);
    }

    public Task startWithInput(String taskId, List<Variable> variables) {
        return this.executionService.startWithInput(taskId, variables);
    }

    public Comment addComment(String taskId, String commentText) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)commentText) ? 1 : 0) != 0, (Object)"A commentText is required.");
        return this.comments.create(taskId, commentText, User.AUTHENTICATED_USER, true);
    }

    public List<String> addComments(List<String> taskIds, String commentText) {
        return this.executeBulkActionSilently(taskIds, taskId -> this.addComment((String)taskId, commentText));
    }

    private void applyNewOwner(String newOwner, Task task) {
        String previousOwner = task.getOwner();
        if (!Objects.equal((Object)newOwner, (Object)previousOwner)) {
            this.tasks.reassignToOwner(task, newOwner);
        }
    }

    private void applyNewTeam(String newTeam, Task task) {
        String previousTeam = task.getTeam();
        if (!Objects.equal((Object)newTeam, (Object)previousTeam)) {
            this.tasks.reassignToTeam(task, newTeam);
        }
    }

    public Task reassignToOwner(String taskId, String newOwner) {
        Object task = this.tasks.findById(taskId);
        this.applyNewOwner(newOwner, (Task)task);
        return task;
    }

    public List<String> reassignTasks(List<String> taskIds, String newTeam, String newOwner) {
        return this.executeBulkActionSilently(taskIds, taskId -> {
            this.applyNewTeam(newTeam, (Task)this.tasks.findById((String)taskId));
            this.reassignToOwner((String)taskId, newOwner);
            return null;
        });
    }

    public List<String> deleteTasks(List<String> taskIds) {
        return this.executeBulkActionSilently(taskIds, taskId -> {
            this.tasks.delete((String)taskId);
            return null;
        });
    }

    public List<Attachment> getAttachments(String taskId) {
        Object task = this.tasks.findById(taskId);
        Preconditions.checkArgument((task != null ? 1 : 0) != 0, (Object)("Task not found for taskId " + taskId));
        return task.getAttachments();
    }

    private boolean isScriptOrCustomScriptTask(Task task) {
        return task instanceof ScriptTask || task instanceof CustomScriptTask;
    }

    private void checkIsStatusUpdatable(Task task, String action) {
        if (!this.canUpdateInProgressStatus(task)) {
            throw new IllegalArgumentException("You can not " + action + " a task that is : not in progress, automated, or unassigned");
        }
        if (task.isTaskGroup()) {
            throw new IllegalArgumentException("You can not " + action + " a task group");
        }
    }

    private void checkIsStatusCompletableInAdvance(Task task) {
        boolean isAutomated = (Boolean)task.getProperty("automated");
        if (!this.canUpdatePlannedStatus(task) || isAutomated) {
            throw new IllegalArgumentException("You can not complete in advance a task that is : not planned or unassigned or automated");
        }
    }

    private void checkIsTaskSkippable(Task task) {
        if (!this.canUpdateInProgressStatus(task) && !this.canUpdateFailedStatus(task)) {
            throw new IllegalArgumentException("You can not skip a task that is : (in progress and automated or unassigned) or (failed and not automated or unassigned)");
        }
        if (task.isTaskGroup() && !((TaskGroup)task).isSkippableOrRetriable()) {
            throw new IllegalArgumentException("You can not skip this task group");
        }
    }

    private void checkIsTaskSkippableInAdvance(Task task) {
        if (!this.canUpdatePlannedStatus(task)) {
            throw new IllegalArgumentException("You can not skip in advance a task that is : not planned or unassigned");
        }
    }

    private void checkCanTaskBeRetried(Task task) {
        if (!this.canUpdateFailedStatus(task)) {
            throw new IllegalArgumentException("You can not retry a task that is : failed and not automated or unassigned");
        }
        if (task instanceof TaskGroup && !((TaskGroup)task).isSkippableOrRetriable()) {
            throw new IllegalArgumentException("You can not retry this task group");
        }
    }

    private void checkCanTaskBeReopen(Task task) {
        if (!task.isDoneInAdvance()) {
            throw new IllegalArgumentException("You can not reopen a task that is not done in advance");
        }
        Release release = task.getRelease();
        this.checkReleaseIsInProgress(release);
    }

    private void checkCanTaskBeAborted(Task task) {
        if (task.isInProgress()) {
            Preconditions.checkArgument((task instanceof ScriptTask || task instanceof CustomScriptTask ? 1 : 0) != 0, (Object)"When a task in running, only ScriptTask or CustomScriptTask may be cancelled");
        } else {
            Preconditions.checkArgument((boolean)task.isPreconditionInProgress(), (Object)"Only task currently evaluating a precondition may be cancelled");
        }
    }

    private boolean canUpdateInProgressStatus(Task task) {
        return task.isInProgress() && !task.isAutomated() && (task.hasOwner() || task.hasTeam());
    }

    private boolean canUpdatePlannedStatus(Task task) {
        return task.isPlanned() && (task.hasOwner() || task.hasTeam());
    }

    private boolean canUpdateFailedStatus(Task task) {
        boolean isAutomated = (Boolean)task.getProperty("automated");
        return task.isFailed() && (isAutomated || task.hasOwner() || task.hasTeam());
    }

    private void checkReleaseIsInProgress(Release release) {
        Preconditions.checkState((boolean)release.isInProgress(), (String)"The release '%s' must be in progress.", (Object[])new Object[]{release.getTitle()});
    }

    private List<String> executeBulkActionSilently(List<String> taskIds, Function<String, ?> action) {
        return taskIds.stream().filter(taskId -> {
            try {
                action.apply((String)taskId);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }).collect(Collectors.toList());
    }
}

