/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.xlrelease.configuration.UserProfile;
import com.xebialabs.xlrelease.repository.UserCountStrategy;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class UserProfiles {
    public static final String ROOT = Metadata.ConfigurationItemRoot.CONFIGURATION.getRootNodeName() + "/Users";
    private UserCountStrategy userCountStrategy;
    private RepositoryService repositoryService;

    @Autowired
    public UserProfiles(RepositoryService repositoryService, UserCountStrategy userCountStrategy) {
        this.repositoryService = repositoryService;
        this.userCountStrategy = userCountStrategy;
    }

    public List<UserProfile> findByCanonicalId(String canonicalId) {
        SearchParameters query = new SearchParameters().setType(Type.valueOf(UserProfile.class)).addProperty("canonicalId", canonicalId);
        return this.repositoryService.listEntities(query);
    }

    public List<UserProfile> findAll() {
        SearchParameters query = new SearchParameters().setType(Type.valueOf(UserProfile.class));
        return this.repositoryService.listEntities(query);
    }

    public void createOrUpdate(UserProfile profile) {
        this.repositoryService.createOrUpdate((ConfigurationItem[])new UserProfile[]{profile});
    }

    public void update(UserProfile ... profile) {
        this.repositoryService.update((ConfigurationItem[])profile);
    }

    public void delete(String id) {
        this.repositoryService.delete(new String[]{id});
    }

    public static String buildId(String username) {
        return ROOT + "/" + username;
    }

    public int countUserWithLoginAllowed() {
        return this.userCountStrategy.countUserWithLoginAllowed();
    }

    public List<UserProfile> search(String email, String fullName, Boolean loginAllowed, Long page, Long resultsPerPage) {
        SearchParameters query = new SearchParameters().setType(Type.valueOf(UserProfile.class)).setPage(page.longValue()).setResultsPerPage(resultsPerPage.longValue());
        if (email != null) {
            query.addProperty("email", email);
        }
        if (fullName != null) {
            query.addProperty("fullName", fullName);
        }
        if (loginAllowed != null) {
            query.addProperty("loginAllowed", loginAllowed.toString());
        }
        return this.repositoryService.listEntities(query);
    }
}

