/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.builder.DependencyBuilder;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.DependencyCreatedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyDeletedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.DependencyCreateCommand;
import com.xebialabs.xlrelease.repository.DependencyDeleteCommand;
import com.xebialabs.xlrelease.repository.DependencyFindByReleaseId;
import com.xebialabs.xlrelease.repository.DependencyGetCommand;
import com.xebialabs.xlrelease.repository.DependencyUpdateCommand;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.PlanItemByIdQuery;
import com.xebialabs.xlrelease.repository.Tasks;
import com.xebialabs.xlrelease.repository.XlrQueries;
import com.xebialabs.xlrelease.repository.XlrRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.variable.VariableHelper;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class Dependencies {
    private XlrRepository xlrRepository;
    private XlrQueries xlrQueries;
    private Tasks tasks;
    private CiIdService ciIdService;
    private XLReleaseEventBus eventBus;

    @Autowired
    public Dependencies(XlrRepository xlrRepository, XlrQueries xlrQueries, Tasks tasks, CiIdService ciIdService, XLReleaseEventBus eventBus) {
        this.xlrRepository = xlrRepository;
        this.xlrQueries = xlrQueries;
        this.tasks = tasks;
        this.ciIdService = ciIdService;
        this.eventBus = eventBus;
    }

    @Timed
    public Dependency create(GateTask gate, String targetIdOrVariable) {
        Dependency dependency = DependencyBuilder.newDependency().withId(this.ciIdService.getUniqueId(Type.valueOf(Dependency.class), gate.getId())).build();
        if (VariableHelper.containsVariables((String)targetIdOrVariable)) {
            dependency.setTargetId(targetIdOrVariable);
        } else {
            PlanItem target = (PlanItem)this.xlrQueries.query(new PlanItemByIdQuery(targetIdOrVariable, Integer.MAX_VALUE));
            dependency.setTarget(target);
        }
        gate.addDependency(dependency);
        dependency.setGateTask(gate);
        Release release = gate.getRelease();
        List<Variable> variables = VariablePersistenceHelper.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService);
        this.xlrRepository.handle(new DependencyCreateCommand(release, dependency, variables));
        this.eventBus.publish((XLReleaseEvent)new DependencyCreatedEvent(dependency));
        return dependency;
    }

    @Timed
    public Dependency update(String dependencyId, String targetIdOrVariable) {
        String gateId = Ids.getParentId((String)dependencyId);
        GateTask gate = (GateTask)this.tasks.findById(gateId);
        Dependency dependency = gate.getDependencies().stream().filter(d -> dependencyId.equals(d.getId())).findFirst().orElseThrow(() -> new NotFoundException(String.format("Dependency with Id '%s' not found.", dependencyId), new Object[0]));
        Dependency original = CiCloneHelper.cloneCi(dependency);
        Checks.checkArgument((!dependency.isDone() ? 1 : 0) != 0, (String)"Dependency has already been resolved and cannot be updated", (Object[])new Object[0]);
        if (VariableHelper.containsVariables((String)targetIdOrVariable)) {
            dependency.setTargetId(targetIdOrVariable);
            dependency.setTarget(null);
        } else {
            PlanItem newTarget = (PlanItem)this.xlrQueries.query(new PlanItemByIdQuery(targetIdOrVariable, Integer.MAX_VALUE));
            dependency.setTargetId(targetIdOrVariable);
            dependency.setTarget(newTarget);
        }
        Release release = gate.getRelease();
        List<Variable> newVariables = VariablePersistenceHelper.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService);
        this.xlrRepository.handle(new DependencyUpdateCommand(release, dependency, newVariables));
        this.eventBus.publish((XLReleaseEvent)new DependencyUpdatedEvent(original, dependency));
        return dependency;
    }

    @Timed
    public void delete(String dependencyId) {
        Dependency dependency = this.xlrRepository.handle(new DependencyGetCommand(dependencyId));
        GateTask gate = dependency.getGateTask();
        Checks.checkArgument((!dependency.isDone() || gate.isPlanned() ? 1 : 0) != 0, (String)"Dependency has already been resolved and cannot be deleted", (Object[])new Object[0]);
        this.xlrRepository.handle(new DependencyDeleteCommand(dependency));
        this.eventBus.publish((XLReleaseEvent)new DependencyDeletedEvent(dependency));
    }

    @Timed
    public List<Dependency> findByReleaseId(String releaseId, Integer depth) {
        Page page = new Page(0L, Long.MAX_VALUE, depth);
        return this.xlrQueries.query(new DependencyFindByReleaseId(page, releaseId));
    }
}

