/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.builder.CommentBuilder;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.CommentCreatedEvent;
import com.xebialabs.xlrelease.domain.events.CommentUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.CommentCreateCommand;
import com.xebialabs.xlrelease.repository.CommentGetCommand;
import com.xebialabs.xlrelease.repository.CommentUpdateCommand;
import com.xebialabs.xlrelease.repository.CommentsHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Tasks;
import com.xebialabs.xlrelease.repository.XlrRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.user.User;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class Comments {
    public static final String COMMENT_PREFIX_SCRIPT = String.format("This comment was too long and has been cut off at the end. See the `script_output.log` attachment for the full log.%n%n---%n%n", new Object[0]);
    public static final String COMMENT_PREFIX_MANUAL = String.format("This comment was too long and has been cut off at the end.%n%n---%n%n", new Object[0]);
    public static final String COMMENT_SUFFIX = String.format("%n%n---%n%n[...truncated...]", new Object[0]);
    private static final Logger logger = LoggerFactory.getLogger(Comments.class);
    private CiIdService ciIdService;
    private XlrRepository xlrRepository;
    private Tasks tasks;
    private XLReleaseEventBus eventBus;

    @Autowired
    public Comments(XlrRepository xlrRepository, CiIdService ciIdService, Tasks tasks, XLReleaseEventBus eventBus) {
        this.xlrRepository = xlrRepository;
        this.ciIdService = ciIdService;
        this.tasks = tasks;
        this.eventBus = eventBus;
    }

    public Comment create(String taskId, String text, User author, boolean notify) {
        Object task = this.tasks.findById(taskId);
        return this.create((Task)task, text, author, notify);
    }

    public Comment create(Task task, String text, User author, boolean notify) {
        return this.createComment(task, text, author, notify, COMMENT_PREFIX_MANUAL, COMMENT_SUFFIX);
    }

    public Comment update(String commentId, String text) {
        Comment comment = this.xlrRepository.handle(new CommentGetCommand(commentId));
        Comment original = CiCloneHelper.cloneCi(comment);
        String taskId = Ids.getParentId((String)commentId);
        Object task = this.tasks.findById(taskId);
        int maxCommentSize = task.getMaxCommentSize();
        if (!text.equals(comment.getText())) {
            CommentsHelper.updateCommentText((Comment)comment, (String)text, (int)maxCommentSize, (String)COMMENT_PREFIX_MANUAL, (String)COMMENT_SUFFIX);
            task.updateComment(original, comment);
            this.xlrRepository.handle(new CommentUpdateCommand((Task)task, original, comment));
            this.eventBus.publish((XLReleaseEvent)new CommentUpdatedEvent(task, original, comment));
        }
        return comment;
    }

    public String appendComment(String taskId, String commentId, String commentText) {
        String updatedCommentId = commentId;
        try {
            Object task = this.tasks.findById(taskId);
            int maxCommentSize = task.getMaxCommentSize();
            if (Strings.isBlank((String)updatedCommentId)) {
                Comment comment = this.createComment((Task)task, commentText, User.LOG_OUTPUT, false, COMMENT_PREFIX_SCRIPT, COMMENT_SUFFIX);
                updatedCommentId = comment.getId();
            } else {
                Comment comment = this.xlrRepository.handle(new CommentGetCommand(updatedCommentId));
                Comment original = CiCloneHelper.cloneCi(comment);
                CommentsHelper.appendCommentText((Comment)comment, (String)commentText, (int)maxCommentSize, (String)COMMENT_PREFIX_SCRIPT, (String)COMMENT_SUFFIX);
                this.xlrRepository.handle(new CommentUpdateCommand((Task)task, original, comment));
            }
        }
        catch (Exception exception) {
            logger.warn("Unable to update XL Release task: '{}'", (Object)taskId, (Object)exception);
        }
        return updatedCommentId;
    }

    private Comment createComment(Task task, String commentText, User author, boolean notify, String prefix, String suffix) {
        int maxCommentSize = task.getMaxCommentSize();
        Comment comment = CommentBuilder.newComment().withId(this.ciIdService.getUniqueId(Type.valueOf(Comment.class), task.getId())).withLimit(task.getMaxCommentSize()).withAuthor(author.getName()).withDate(new Date()).build();
        CommentsHelper.appendCommentText((Comment)comment, (String)commentText, (int)maxCommentSize, (String)prefix, (String)suffix);
        task.getComments().add(comment);
        logger.debug("Creating comment: {}", (Object)comment);
        this.xlrRepository.handle(new CommentCreateCommand(task, comment, author, notify));
        this.eventBus.publish((XLReleaseEvent)new CommentCreatedEvent(task, comment, author.getName(), notify));
        return comment;
    }
}

