/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.io.StreamWrappingOverthereFile;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.AttachmentCreatedEvent;
import com.xebialabs.xlrelease.domain.events.AttachmentDeletedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.AttachmentCreateCommand;
import com.xebialabs.xlrelease.repository.AttachmentDeleteCommand;
import com.xebialabs.xlrelease.repository.AttachmentGetCommand;
import com.xebialabs.xlrelease.repository.AttachmentSizeLimiter;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseGetCommand;
import com.xebialabs.xlrelease.repository.XlrRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import scala.Option;

@Repository
public class Attachments {
    private static final Logger logger = LoggerFactory.getLogger(Attachments.class);
    private XlrRepository xlrRepository;
    private ArchivingService archivingService;
    private CiIdService ciIdService;
    private XLReleaseEventBus eventBus;

    @Autowired
    public Attachments(XlrRepository xlrRepository, ArchivingService archivingService, CiIdService ciIdService, XLReleaseEventBus eventBus) {
        this.xlrRepository = xlrRepository;
        this.archivingService = archivingService;
        this.ciIdService = ciIdService;
        this.eventBus = eventBus;
    }

    @Timed
    public Attachment findById(String attachmentId) {
        return this.xlrRepository.handle(new AttachmentGetCommand(attachmentId));
    }

    @Timed
    public Attachment findByIdIncludingArchived(String attachmentId) {
        try {
            return this.findById(attachmentId);
        }
        catch (NotFoundException e) {
            if (this.archivingService.attachmentExists(attachmentId)) {
                return this.archivingService.getAttachment(attachmentId);
            }
            throw new NotFoundException(String.format("Attachment [%s] does not exist in the repository or archive", attachmentId), new Object[]{e});
        }
    }

    @Timed
    public Attachment attach(String ciId, String filename, String contentType, InputStream stream) {
        Release release = this.findReleaseById(Ids.releaseIdFrom((String)ciId));
        Task task = null;
        if (!Ids.isReleaseId((String)ciId)) {
            task = release.getTask(ciId);
        }
        return this.attach(release, task, filename, contentType, stream);
    }

    @Timed
    public Attachment attach(Release release, @Nullable Task task, String filename, String contentType, InputStream bytes) {
        Attachment attachment = this.attachToRelease(release, filename, contentType, bytes);
        String attachmentContainerId = release.getId();
        if (task != null) {
            task.getAttachments().add(attachment);
            attachmentContainerId = task.getId();
        }
        attachment.setRelease(release);
        attachment.setExportFilename(attachment.buildExportFileName());
        Attachment savedAttachment = this.xlrRepository.handle(new AttachmentCreateCommand(release, (Option<Task>)Option.apply((Object)task), attachment));
        this.eventBus.publish((XLReleaseEvent)new AttachmentCreatedEvent(attachmentContainerId, savedAttachment));
        return savedAttachment;
    }

    private Attachment attachToRelease(Release release, String filename, String contentType, InputStream bytes) {
        AttachmentSizeLimiter limiter = new AttachmentSizeLimiter(bytes);
        StreamWrappingOverthereFile file = new StreamWrappingOverthereFile(filename, (InputStream)limiter);
        Attachment attachment = new Attachment(file, contentType);
        String attachmentId = this.ciIdService.getUniqueId(Type.valueOf(Attachment.class), release.getId());
        attachment.setId(attachmentId);
        release.getAttachments().add(attachment);
        return attachment;
    }

    @Timed
    public void deleteAttachment(String releaseId, String attachmentId) {
        Release release = this.findReleaseById(releaseId);
        Set tasksUsingAttachment = release.getTasksUsingAttachment(attachmentId);
        Preconditions.checkState((boolean)tasksUsingAttachment.isEmpty(), (Object)String.format("Attachment '%s' is used by tasks : %s", attachmentId, tasksUsingAttachment.toString()));
        logger.info("Deleting attachment reference '{}' from release '{}'", (Object)attachmentId, (Object)releaseId);
        release.deleteAttachment(attachmentId);
        Attachment attachment = this.findById(attachmentId);
        this.xlrRepository.handle(new AttachmentDeleteCommand(Collections.singletonList(release), attachment, true));
        this.eventBus.publish((XLReleaseEvent)new AttachmentDeletedEvent(releaseId, attachment));
    }

    @Timed
    public void deleteAttachmentFromTask(String releaseId, String taskId, String attachmentId) {
        Release release = this.findReleaseById(releaseId);
        Task task = release.getTask(taskId);
        Preconditions.checkState((!task.isInProgress() ? 1 : 0) != 0, (Object)"Can't delete an attachment from a running task.");
        Set tasksUsingAttachment = release.getTasksUsingAttachment(attachmentId);
        Preconditions.checkState((boolean)tasksUsingAttachment.contains(task), (Object)String.format("Attachment '%s' found on release, but not found on task '%s'", attachmentId, taskId));
        Attachment attachment = task.getAttachments().stream().filter(at -> attachmentId.equals(at.getId())).findFirst().orElseThrow(() -> new NotFoundException("Attachment [%s] not found", new Object[]{attachmentId}));
        if (tasksUsingAttachment.size() == 1) {
            logger.info("Deleting attachment reference '{}' from release '{}'", (Object)attachmentId, (Object)releaseId);
            release.deleteAttachment(attachmentId);
            task.deleteAttachment(attachmentId);
            this.xlrRepository.handle(new AttachmentDeleteCommand(Arrays.asList(release, task), attachment, true));
        } else {
            logger.info("Deleting attachment reference '{}' from task '{}'", (Object)attachmentId, (Object)taskId);
            task.deleteAttachment(attachmentId);
            this.xlrRepository.handle(new AttachmentDeleteCommand(Collections.singletonList(task), attachment, false));
        }
        this.eventBus.publish((XLReleaseEvent)new AttachmentDeletedEvent(taskId, attachment));
    }

    private Release findReleaseById(String releaseId) {
        return this.xlrRepository.handle(new ReleaseGetCommand(releaseId, Integer.MAX_VALUE, false, null));
    }
}

