/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.forms.Comment;
import com.xebialabs.xlrelease.api.v1.forms.Condition;
import com.xebialabs.xlrelease.api.v1.forms.StartTask;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateCondition;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.UserInputTask;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.repository.GateConditions;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.repository.Tasks;
import com.xebialabs.xlrelease.rest.AllCILevels;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.UploadService;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.jboss.resteasy.spi.BadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/api/v1/tasks/")
@AllCILevels
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@PublicApi
@ShowOnlyPublicApiMembers
public class TaskApi
implements ApiService {
    private static final Logger logger = LoggerFactory.getLogger(TaskApi.class);
    public static final String SERVICE_NAME = "taskApi";
    private ReleaseActorService releaseActorService;
    private Tasks tasks;
    private GateConditions gateConditions;
    private PermissionChecker permissions;
    private Releases releases;
    private UploadService uploadService;

    @Autowired
    public TaskApi(ReleaseActorService releaseActorService, Tasks tasks, PermissionChecker permissions, GateConditions gateConditions, UploadService uploadService, Releases releases) {
        this.releaseActorService = releaseActorService;
        this.tasks = tasks;
        this.permissions = permissions;
        this.gateConditions = gateConditions;
        this.uploadService = uploadService;
        this.releases = releases;
    }

    @Override
    public String serviceName() {
        return SERVICE_NAME;
    }

    @POST
    @Path(value="{taskId:.*/Task[^/]*}/attachments")
    @Consumes(value={"multipart/form-data"})
    @Timed
    public List<Attachment> addAttachments(@PathParam(value="taskId") String taskId, @Context HttpServletRequest request) throws IOException, FileUploadException {
        this.permissions.checkEditTask(Ids.releaseIdFrom((String)taskId));
        ServletFileUpload upload = new ServletFileUpload();
        FileItemIterator fileItems = upload.getItemIterator(request);
        List<Attachment> attachments = this.uploadService.addAttachment(taskId, fileItems);
        if (attachments.isEmpty()) {
            logger.debug("No attachments uploaded caused by incorrect form body");
            throw new BadRequestException("Expected file upload");
        }
        return attachments;
    }

    @PublicApiMember
    @Timed
    public Attachment addAttachment(String taskId, String fileName, byte[] fileByteArray) throws IOException {
        this.permissions.checkEditTask(Ids.releaseIdFrom((String)taskId));
        return this.uploadService.addAttachment(taskId, fileName, fileByteArray);
    }

    @DELETE
    @Path(value="{taskId:.*/Task[^/]*}/attachments/{attachmentId:.*/Attachment[^/]*}")
    @PublicApiMember
    @Timed
    public void deleteAttachment(@PathParam(value="taskId") String taskId, @PathParam(value="attachmentId") String attachmentId) {
        String releaseId = Ids.releaseIdFrom((String)taskId);
        this.permissions.check(XLReleasePermissions.EDIT_RELEASE_TASK, releaseId);
        this.releaseActorService.deleteAttachmentFromTask(releaseId, taskId, attachmentId);
    }

    @GET
    @Path(value="/{taskId:.*/Task[^/]*}")
    @PublicApiMember
    @Timed
    public Task getTask(@PathParam(value="taskId") String taskId) {
        this.permissions.checkView(Ids.releaseIdFrom((String)taskId));
        return this.tasks.findById(taskId);
    }

    @POST
    @Path(value="{taskId:.*/Task[^/]*}/copy")
    @PublicApiMember
    @Timed
    public Task copyTask(@PathParam(value="taskId") String taskId, @QueryParam(value="targetContainerId") String targetContainerId, @QueryParam(value="targetPosition") int targetPosition) {
        String releaseId = Ids.releaseIdFrom((String)taskId);
        this.permissions.checkCopyTask(releaseId);
        return this.releaseActorService.copyTask(taskId, targetContainerId, targetPosition);
    }

    @PUT
    @Path(value="/{taskId:.*/Task[^/]*}")
    @Timed
    public Task updateTask(@PathParam(value="taskId") String taskId, Task task) {
        this.permissions.checkEditTask(Ids.releaseIdFrom((String)taskId));
        return this.releaseActorService.updateTask(taskId, task);
    }

    @PublicApiMember
    @Timed
    public Task updateTask(Task task) {
        return this.updateTask(task.getId(), task);
    }

    @POST
    @Path(value="{taskId:.*/Task[^/]*}/changeType")
    @PublicApiMember
    @Timed
    public Task changeTaskType(@PathParam(value="taskId") String taskId, @QueryParam(value="targetType") String targetType) {
        Checks.checkArgument((!Strings.isNullOrEmpty((String)targetType) ? 1 : 0) != 0, (String)"Query parameter targetType must be provided", (Object[])new Object[0]);
        this.permissions.checkEditTask(Ids.releaseIdFrom((String)taskId));
        return this.releaseActorService.changeTaskType(taskId, Type.valueOf((String)targetType));
    }

    @POST
    @Path(value="/{containerId:.*?}/tasks")
    @PublicApiMember
    @Timed
    public Task addTask(@PathParam(value="containerId") String containerId, Task task) {
        String releaseId = Ids.releaseIdFrom((String)containerId);
        this.permissions.checkView(releaseId);
        this.permissions.checkEdit(releaseId);
        this.permissions.checkEditTask(releaseId);
        return this.releaseActorService.createTask(containerId, task, null);
    }

    @POST
    @Path(value="/{taskId:.*/Task[^/]*}/complete")
    @PublicApiMember
    @Timed
    public Task completeTask(@PathParam(value="taskId") String taskId, Comment comment) {
        Checks.checkNotNull((Object)comment, (String)"Comment is mandatory when completing a task.");
        this.permissions.checkIsAllowedToWorkOnTask(taskId);
        Checks.checkArgument((boolean)this.areAllRequiredVariablesSet(taskId), (String)"All required values must be set before completing the task", (Object[])new Object[0]);
        return this.releaseActorService.completeTask(taskId, comment.getComment());
    }

    private boolean areAllRequiredVariablesSet(String taskId) {
        Object task = this.tasks.findById(taskId);
        return !this.isUserInputTask((Task)task) || ((UserInputTask)task).getVariables().stream().noneMatch(v -> v.getRequiresValue() && v.isValueEmpty());
    }

    private boolean isUserInputTask(Task task) {
        return task instanceof UserInputTask;
    }

    @POST
    @Path(value="/{taskId:.*/Task[^/]*}/skip")
    @PublicApiMember
    @Timed
    public Task skipTask(@PathParam(value="taskId") String taskId, Comment comment) {
        Checks.checkNotNull((Object)comment, (String)"Comment is mandatory when skipping a task.");
        this.permissions.checkIsAllowedToWorkOnTask(taskId);
        return this.releaseActorService.skipTask(taskId, comment.getComment());
    }

    @POST
    @Path(value="/{taskId:.*/Task[^/]*}/fail")
    @PublicApiMember
    @Timed
    public Task failTask(@PathParam(value="taskId") String taskId, Comment comment) {
        Checks.checkNotNull((Object)comment, (String)"Comment is mandatory when failing a task.");
        this.permissions.checkIsAllowedToWorkOnTask(taskId);
        return this.releaseActorService.failTaskManually(taskId, comment.getComment());
    }

    @POST
    @Path(value="/{taskId:.*/Task[^/]*}/abort")
    @PublicApiMember
    @Timed
    public Task abortTask(@PathParam(value="taskId") String taskId, Comment comment) {
        Checks.checkNotNull((Object)comment, (String)"Comment is mandatory when aborting a task.");
        this.permissions.checkIsAllowedToWorkOnTask(taskId);
        Checks.checkArgument((!Strings.isNullOrEmpty((String)comment.getComment()) ? 1 : 0) != 0, (String)"Comment is mandatory when aborting a task.", (Object[])new Object[0]);
        return this.releaseActorService.abortTask(taskId, comment.getComment());
    }

    @PublicApiMember
    @POST
    @Path(value="/{taskId:.*/Task[^/]*}/retry")
    @Timed
    public Task retryTask(@PathParam(value="taskId") String taskId, Comment comment) {
        Checks.checkNotNull((Object)comment, (String)"Comment is mandatory when retrying a task.");
        this.permissions.checkRetryTask(taskId);
        Checks.checkArgument((!Strings.isNullOrEmpty((String)comment.getComment()) ? 1 : 0) != 0, (String)"Comment is mandatory when retrying a task.", (Object[])new Object[0]);
        return this.releaseActorService.retryTask(taskId, comment.getComment());
    }

    @PublicApiMember
    @POST
    @Path(value="/{taskId:.*/Task[^/]*}/startNow")
    @Timed
    public Task start(@PathParam(value="taskId") String taskId, Comment comment) {
        Checks.checkNotNull((Object)comment, (String)"Comment is mandatory when starting a pending task.");
        this.permissions.checkIsAllowedToStartTask(taskId);
        return this.releaseActorService.startTask(taskId, comment.getComment());
    }

    @PublicApiMember
    @Timed
    public Task start(Task task, List<Variable> variables) {
        return this.start(task.getId(), new StartTask(variables));
    }

    @POST
    @Path(value="/{taskId:.*/Task[^/]*}/start")
    @Timed
    public Task start(@PathParam(value="taskId") String taskId, StartTask startTask) {
        this.permissions.checkIsAllowedToWorkOnTask(taskId);
        List<Variable> taskVariables = startTask.getVariables();
        return this.releaseActorService.startTaskWithInput(taskId, taskVariables);
    }

    @PublicApiMember
    @POST
    @Path(value="/{taskId:.*/Task[^/]*}/reopen")
    @Timed
    public Task reopenTask(@PathParam(value="taskId") String taskId, Comment comment) {
        this.permissions.checkReopenTaskInRelease(Ids.releaseIdFrom((String)taskId));
        Checks.checkNotNull((Object)comment, (String)"Comment is mandatory when reopening a task.");
        Checks.checkArgument((!Strings.isNullOrEmpty((String)comment.getComment()) ? 1 : 0) != 0, (String)"Comment is mandatory when reopening a task.", (Object[])new Object[0]);
        return this.releaseActorService.reopenTask(taskId, comment.getComment());
    }

    @GET
    @Path(value="/{taskId:.*/Task[^/]*}/variables")
    @PublicApiMember
    @Timed
    public List<Variable> getVariables(@PathParam(value="taskId") String taskId) {
        Object task = this.tasks.findById(taskId);
        this.permissions.checkViewTask((Task)task);
        return task.getInputVariables();
    }

    @POST
    @Path(value="/{taskId:.*/Task[^/]*}/comment")
    @PublicApiMember
    @Timed
    public Task commentTask(@PathParam(value="taskId") String taskId, Comment comment) {
        this.permissions.checkIsAllowedToCommentOnTask(taskId);
        this.releaseActorService.addCommentToTask(taskId, comment.getComment());
        return this.tasks.findById(taskId);
    }

    @POST
    @Path(value="/{taskId:.*/Task[^/]*}/assign/{username: .*?}")
    @PublicApiMember
    @Timed
    public Task assignTask(@PathParam(value="taskId") String taskId, @PathParam(value="username") String username) {
        this.permissions.checkReassignTaskToUser(taskId, username);
        return this.releaseActorService.reassignTaskToOwner(taskId, username);
    }

    @GET
    @Path(value="/byTitle")
    @PublicApiMember
    @Timed
    public List<Task> searchTasksByTitle(@QueryParam(value="taskTitle") String taskTitle, @QueryParam(value="phaseTitle") String phaseTitle, @QueryParam(value="releaseId") String releaseId) {
        Checks.checkArgument((!Strings.isNullOrEmpty((String)taskTitle) ? 1 : 0) != 0, (String)"Query parameter taskTitle must be provided", (Object[])new Object[0]);
        Checks.checkArgument((!Strings.isNullOrEmpty((String)releaseId) ? 1 : 0) != 0, (String)"Query parameter releaseId must be provided", (Object[])new Object[0]);
        Release release = this.releases.findById(releaseId);
        this.permissions.checkView(release);
        return release.getTasksByTitle(phaseTitle, taskTitle);
    }

    @PublicApiMember
    @Timed
    public Task newTask() {
        return this.newTask("xlrelease.Task");
    }

    @PublicApiMember
    @Timed
    public Task newTask(String type) {
        Task task = Task.fromType((String)type);
        task.setTitle("New task");
        return task;
    }

    public Comment newComment(String commentText) {
        return new Comment(commentText);
    }

    @DELETE
    @Path(value="/{taskId:.*/Task[^/]*}")
    @PublicApiMember
    @Timed
    public void delete(@PathParam(value="taskId") String taskId) {
        this.permissions.checkEdit(Ids.releaseIdFrom((String)taskId));
        this.releaseActorService.deleteTask(taskId);
    }

    @DELETE
    @Path(value="/{dependencyId:.*/Dependency[^/]*}")
    @PublicApiMember
    @Timed
    public void deleteDependency(@PathParam(value="dependencyId") String dependencyId) {
        this.permissions.checkEditTask(Ids.releaseIdFrom((String)dependencyId));
        String taskId = Ids.getParentId((String)dependencyId);
        Object task = this.tasks.findById(taskId);
        Checks.checkArgument((boolean)task.isGate(), (String)("Can only delete a dependency from a GateTask, not a " + task.getTaskType().toString()), (Object[])new Object[0]);
        this.releaseActorService.deleteDependency(taskId, dependencyId);
    }

    @POST
    @Path(value="/{taskId:.*/Task[^/]*}/dependencies/{targetId:.*?}")
    @PublicApiMember
    @Timed
    public Dependency addDependency(@PathParam(value="taskId") String taskId, @PathParam(value="targetId") String targetId) {
        this.permissions.checkEditTask(Ids.releaseIdFrom((String)taskId));
        if (!VariableHelper.containsVariables((String)targetId)) {
            this.permissions.checkView(Ids.releaseIdFrom((String)targetId));
        }
        Object task = this.tasks.findById(taskId);
        Checks.checkArgument((boolean)task.isGate(), (String)("Can only add a dependency to a GateTask, not a " + task.getTaskType().toString()), (Object[])new Object[0]);
        return this.releaseActorService.createDependency(taskId, targetId);
    }

    @POST
    @Path(value="{taskId:.*/Task[^/]*}/conditions")
    @PublicApiMember
    @Timed
    public GateCondition addCondition(@PathParam(value="taskId") String taskId, Condition condition) {
        this.permissions.checkEditTask(Ids.releaseIdFrom((String)taskId));
        Object task = this.tasks.findById(taskId);
        Checks.checkArgument((boolean)task.isGate(), (String)("Can only add a condition to a GateTask, not a " + task.getType()), (Object[])new Object[0]);
        GateCondition gateCondition = this.releaseActorService.createGateCondition(taskId);
        gateCondition.setTitle(condition.getTitle());
        gateCondition.setChecked(condition.isChecked());
        return this.releaseActorService.updateGateCondition(gateCondition.getId(), gateCondition);
    }

    @POST
    @Path(value="/{conditionId:.*/GateCondition[^/]*}")
    @Timed
    public GateCondition updateCondition(@PathParam(value="conditionId") String conditionId, Condition condition) {
        String gateId = Ids.getParentId((String)conditionId);
        this.permissions.checkIsAllowedToWorkOnTask(gateId);
        GateCondition previousCondition = this.gateConditions.findById(conditionId);
        previousCondition.setChecked(condition.isChecked());
        if (!Objects.equal((Object)previousCondition.getTitle(), (Object)condition.getTitle())) {
            this.permissions.checkEditTask(Ids.releaseIdFrom((String)conditionId));
            previousCondition.setTitle(condition.getTitle());
        }
        return this.releaseActorService.updateGateCondition(conditionId, previousCondition);
    }

    @PublicApiMember
    @Timed
    public GateCondition updateCondition(GateCondition condition) {
        return this.releaseActorService.updateGateCondition(condition.getId(), condition);
    }

    @DELETE
    @Path(value="{conditionId:.*/GateCondition[^/]*?}")
    @PublicApiMember
    @Timed
    public void deleteCondition(@PathParam(value="conditionId") String conditionId) {
        this.permissions.checkEditTask(Ids.releaseIdFrom((String)conditionId));
        this.releaseActorService.deleteGateCondition(conditionId);
    }
}

