/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.deployit.plumbing.id.IdType;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PhaseVersion;
import com.xebialabs.xlrelease.repository.ReleaseTriggers;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.repository.Teams;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ReleaseEditor;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.TaskAccessService;
import com.xebialabs.xlrelease.service.UserInfoResolver;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.views.BulkActionResultView;
import com.xebialabs.xlrelease.views.MovementIndexes;
import com.xebialabs.xlrelease.views.PhaseFullView;
import com.xebialabs.xlrelease.views.ReleaseForm;
import com.xebialabs.xlrelease.views.ReleaseFullView;
import com.xebialabs.xlrelease.views.ReleasePermissionsView;
import com.xebialabs.xlrelease.views.ReleaseSearchView;
import com.xebialabs.xlrelease.views.ReleaseTriggerView;
import com.xebialabs.xlrelease.views.ReleasesFilters;
import com.xebialabs.xlrelease.views.TaskFullView;
import com.xebialabs.xlrelease.views.TemplateFilters;
import com.xebialabs.xlrelease.views.converters.PhaseViewConverter;
import com.xebialabs.xlrelease.views.converters.ReleaseTriggerViewConverter;
import com.xebialabs.xlrelease.views.converters.ReleaseViewConverter;
import com.xebialabs.xlrelease.views.converters.TasksViewConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.spi.BadRequestException;
import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/releases")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class ReleaseResource {
    private ReleaseTriggers releaseTriggers;
    private Releases releases;
    private PermissionChecker permissions;
    private ReleaseEditor releaseEditor;
    private ReleaseSearchService releasesSearch;
    private ReleaseActorService releaseActorService;
    private TaskAccessService taskAccessService;
    private ReleaseViewConverter releaseViewConverter;
    private PhaseViewConverter phaseViewConverter;
    private TasksViewConverter tasksViewConverter;
    private UserInfoResolver userInfoResolver;
    private ReleaseTriggerViewConverter releaseTriggerViewConverter;
    private Teams teams;

    @Autowired
    public ReleaseResource(Releases releases, ReleaseTriggers releaseTriggers, PermissionChecker permissions, ReleaseEditor releaseEditor, ReleaseSearchService releasesSearch, ReleaseActorService releaseActorService, TaskAccessService taskAccessService, UserInfoResolver userInfoResolver, ReleaseViewConverter releaseViewConverter, PhaseViewConverter phaseViewConverter, TasksViewConverter tasksViewConverter, ReleaseTriggerViewConverter releaseTriggerViewConverter, Teams teams) {
        this.releases = releases;
        this.releaseTriggers = releaseTriggers;
        this.permissions = permissions;
        this.releaseEditor = releaseEditor;
        this.releasesSearch = releasesSearch;
        this.releaseActorService = releaseActorService;
        this.taskAccessService = taskAccessService;
        this.userInfoResolver = userInfoResolver;
        this.releaseViewConverter = releaseViewConverter;
        this.phaseViewConverter = phaseViewConverter;
        this.tasksViewConverter = tasksViewConverter;
        this.releaseTriggerViewConverter = releaseTriggerViewConverter;
        this.teams = teams;
    }

    @POST
    @Timed
    @Path(value="templates/search")
    public ReleaseSearchView getTemplates(@QueryParam(value="page") Long page, @QueryParam(value="numberbypage") Long numberByPage, @QueryParam(value="depth") Integer depth, TemplateFilters templateFilters) {
        Integer loadDepth = Optional.ofNullable(depth).orElse(1);
        ReleaseSearchResult searchResult = this.releasesSearch.searchTemplates(templateFilters, page != null ? page : 0L, Optional.ofNullable(numberByPage).orElse(15L), loadDepth);
        return this.releaseViewConverter.toSearchView(searchResult, this.taskAccessService.getAllowedTaskTypesForAuthenticatedUser(), Collections.emptyList(), loadDepth, Collections.emptyList());
    }

    @POST
    @Timed
    @Path(value="templates")
    public ReleaseFullView createTemplate(ReleaseForm templateForm) {
        if (templateForm.getParentId() == null || Ids.ROOT_FOLDER_ID.equals(templateForm.getParentId())) {
            this.permissions.check(XLReleasePermissions.CREATE_TEMPLATE);
        } else {
            this.permissions.check(XLReleasePermissions.EDIT_TEMPLATE, templateForm.getParentId());
        }
        Preconditions.checkArgument((boolean)templateForm.hasTitle(), (Object)"Template title is mandatory");
        Preconditions.checkArgument((boolean)templateForm.hasValidDates(), (Object)"Dates are not valid");
        Release release = templateForm.getTemplateId() == null ? this.releaseEditor.createTemplate(templateForm.toRelease(), templateForm.getParentId()) : this.releaseEditor.copyTemplate(templateForm.getTemplateId(), templateForm.toRelease());
        return this.getReleaseFullView(release);
    }

    @DELETE
    @Timed
    @Path(value="templates/{templateId:.*Release[^/-]*}")
    public Response deleteTemplate(@PathParam(value="templateId") @IdParam String templateId) {
        if (Ids.isInFolder((String)templateId)) {
            this.permissions.check(XLReleasePermissions.EDIT_TEMPLATE, Ids.getParentId((String)templateId));
        } else {
            this.permissions.check(XLReleasePermissions.CREATE_TEMPLATE);
        }
        this.releaseActorService.deleteTemplate(templateId);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @PUT
    @Timed
    @Path(value="templates/{templateId:.*Release[^/-]*}")
    public ReleaseFullView updateTemplate(@PathParam(value="templateId") @IdParam String templateId, ReleaseForm releaseForm) {
        this.permissions.check(XLReleasePermissions.EDIT_TEMPLATE, templateId);
        return this.getReleaseFullView(this.releaseActorService.updateTemplateAndResumeTrigger(templateId, releaseForm.toRelease()));
    }

    @POST
    @Timed
    @Path(value="search")
    public ReleaseSearchView searchReleases(@QueryParam(value="page") Long page, @QueryParam(value="numberbypage") Long numberByPage, @QueryParam(value="depth") Integer depth, @QueryParam(value="properties") List<String> properties, @QueryParam(value="extensions") List<String> extensions, ReleasesFilters releasesFilters) {
        int RELEASE_WITH_VARIABLES_AND_PHASES_DEPTH = 2;
        Integer loadDepth = Optional.ofNullable(depth).orElse(2);
        ReleaseSearchResult searchResult = this.releasesSearch.search(releasesFilters, page != null ? page : 0L, Optional.ofNullable(numberByPage).orElse(15L), loadDepth);
        return this.releaseViewConverter.toSearchView(searchResult, this.taskAccessService.getAllowedTaskTypesForAuthenticatedUser(), properties, loadDepth, extensions);
    }

    @POST
    public ReleaseFullView createRelease(ReleaseForm releaseForm) {
        Release release;
        Preconditions.checkArgument((boolean)releaseForm.hasTitle(), (Object)"Release title is mandatory");
        if (!releaseForm.hasValidDates()) {
            throw new BadRequestException("Scheduled start date must be before due date");
        }
        if (releaseForm.isFromTemplate()) {
            this.permissions.checkIsAllowedToCreateReleaseFromTemplate(releaseForm.getTemplateId());
            release = this.releaseEditor.createFromTemplate(releaseForm.getTemplateId(), releaseForm.toRelease());
        } else {
            this.permissions.check(XLReleasePermissions.CREATE_RELEASE);
            release = this.releaseEditor.createWithoutTemplate(releaseForm.toRelease());
        }
        return this.getReleaseFullView(release);
    }

    @PUT
    @Timed
    @Path(value="{releaseId:((?!templates).)*Release[^/-]*}")
    public ReleaseFullView updateRelease(@PathParam(value="releaseId") @IdParam String releaseId, ReleaseForm releaseForm) {
        this.permissions.check(XLReleasePermissions.EDIT_RELEASE, releaseId);
        return this.getReleaseFullView(this.releaseActorService.updateRelease(releaseId, releaseForm.toRelease()));
    }

    @GET
    @Timed
    @Path(value="templates/{templateId:.*Release[^/-]*}/duration")
    public Integer getTemplateDuration(@PathParam(value="templateId") @IdParam String templateId) {
        Release template = this.releases.findByIdIncludingArchived(templateId);
        if (!template.isTemplate()) {
            throw new BadRequestException("templateId does not belong to a template");
        }
        this.permissions.checkView(template);
        Duration duration = this.releaseEditor.getDurationOf(template);
        return duration.toStandardSeconds().getSeconds();
    }

    @POST
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/start")
    public ReleaseFullView startRelease(@PathParam(value="releaseId") @IdParam String releaseId) {
        this.permissions.check(XLReleasePermissions.START_RELEASE, releaseId);
        return this.getReleaseFullView(this.releaseActorService.startRelease(releaseId, User.AUTHENTICATED_USER));
    }

    @POST
    @Path(value="start")
    public BulkActionResultView startReleases(List<String> releaseIds) {
        List<String> allowedReleaseIds = this.permissions.filterStartableReleases(releaseIds);
        if (allowedReleaseIds.isEmpty()) {
            return new BulkActionResultView(allowedReleaseIds);
        }
        return new BulkActionResultView(this.releaseActorService.startReleases(allowedReleaseIds, User.AUTHENTICATED_USER).stream().map(IdType.DOMAIN::convertToViewId).collect(Collectors.toList()));
    }

    @POST
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/abort")
    public ReleaseFullView abortRelease(@PathParam(value="releaseId") @IdParam String releaseId) {
        this.permissions.check(XLReleasePermissions.ABORT_RELEASE, releaseId);
        return this.getReleaseFullView(this.releaseActorService.abortRelease(releaseId));
    }

    @POST
    @Path(value="abort")
    public BulkActionResultView abortReleases(List<String> releaseIds) {
        List<String> allowedReleaseIds = this.permissions.filterAbortableReleases(releaseIds);
        if (allowedReleaseIds.isEmpty()) {
            return new BulkActionResultView(allowedReleaseIds);
        }
        return new BulkActionResultView(this.releaseActorService.abortReleases(allowedReleaseIds).stream().map(IdType.DOMAIN::convertToViewId).collect(Collectors.toList()));
    }

    @GET
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}")
    public ReleaseFullView getRelease(@PathParam(value="releaseId") @IdParam String releaseId) {
        Release release = this.releases.findByIdIncludingArchived(releaseId);
        this.permissions.checkView(release);
        return this.getReleaseFullView(release);
    }

    @POST
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/phases/move")
    public PhaseFullView movePhase(@PathParam(value="releaseId") @IdParam String releaseId, MovementIndexes movementIndexes) {
        this.permissions.checkEdit(releaseId);
        return this.getPhaseFullView(this.releaseActorService.movePhase(releaseId, movementIndexes));
    }

    @POST
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/tasks/move")
    public TaskFullView moveTask(@PathParam(value="releaseId") @IdParam String releaseId, MovementIndexes movementIndexes) {
        this.permissions.checkEdit(releaseId);
        return this.getTaskFullView(this.releaseActorService.moveTask(releaseId, movementIndexes));
    }

    @POST
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/phases/add")
    public PhaseFullView addPhase(@PathParam(value="releaseId") @IdParam String releaseId) {
        this.permissions.checkEdit(releaseId);
        Phase phase = this.releaseActorService.addPhase(releaseId);
        return this.getPhaseFullView(phase);
    }

    @PUT
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/tasks/duplicate/{taskId:.*Task[^/-]*}")
    public TaskFullView duplicateTask(@PathParam(value="releaseId") @IdParam String releaseId, @PathParam(value="taskId") @IdParam String originTaskId) {
        this.permissions.checkEdit(releaseId);
        return this.getTaskFullView(this.releaseActorService.duplicateTask(releaseId, originTaskId));
    }

    @PUT
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/phases/duplicate/{phaseId:.*Phase[^/-]*}")
    public PhaseFullView duplicatePhase(@PathParam(value="releaseId") @IdParam String releaseId, @PathParam(value="phaseId") @IdParam String originPhaseId) {
        this.permissions.checkEdit(releaseId);
        return this.getPhaseFullView(this.releaseActorService.duplicatePhase(releaseId, originPhaseId));
    }

    @GET
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/permissions")
    public ReleasePermissionsView getPermissions(@PathParam(value="releaseId") @IdParam String releaseId) {
        this.permissions.checkEditSecurity(releaseId);
        Release release = this.releases.findByIdIncludingArchived(releaseId);
        List permissions = release.isTemplate() ? XLReleasePermissions.getTemplatePermissions() : XLReleasePermissions.getReleasePermissions();
        return new ReleasePermissionsView(permissions, release, this.userInfoResolver);
    }

    @POST
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/restartPhases")
    public ReleaseFullView restartPhases(@PathParam(value="releaseId") @IdParam String releaseId, @QueryParam(value="fromPhaseId") @IdParam String phaseId, @QueryParam(value="fromTaskId") @IdParam String taskId, @QueryParam(value="phaseVersion") PhaseVersion phaseVersion) {
        this.permissions.check(XLReleasePermissions.EDIT_RELEASE, releaseId);
        return this.getReleaseFullView(this.releaseActorService.restartPhase(releaseId, phaseId, taskId, phaseVersion));
    }

    @POST
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/resume")
    public ReleaseFullView resume(@PathParam(value="releaseId") @IdParam String releaseId) {
        this.permissions.check(XLReleasePermissions.EDIT_RELEASE, releaseId);
        return this.getReleaseFullView(this.releaseActorService.resume(releaseId));
    }

    @DELETE
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/attachments/{attachmentId:.*Attachment[^/-]*}")
    public void deleteAttachment(@PathParam(value="releaseId") @IdParam String releaseId, @PathParam(value="attachmentId") @IdParam String attachmentId) {
        this.permissions.check(XLReleasePermissions.EDIT_RELEASE, releaseId);
        this.releaseActorService.deleteAttachment(releaseId, attachmentId);
    }

    @DELETE
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/{taskId:.*Task[^/-]*}/attachments/{attachmentId:.*Attachment[^/-]*}")
    public void deleteAttachmentFromTask(@PathParam(value="releaseId") @IdParam String releaseId, @PathParam(value="taskId") @IdParam String taskId, @PathParam(value="attachmentId") @IdParam String attachmentId) {
        this.permissions.check(XLReleasePermissions.EDIT_RELEASE_TASK, releaseId);
        this.releaseActorService.deleteAttachmentFromTask(releaseId, taskId, attachmentId);
    }

    @GET
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/teams/assignable")
    public Collection<Team> getAssignableTeams(@PathParam(value="releaseId") @IdParam String releaseId) {
        this.permissions.checkEditOrReassignTask(releaseId);
        List<Team> teamsIncludingInherited = this.teams.getEffectiveTeams(releaseId);
        Predicate<Team> withoutTemplateOwner = team -> !team.getTeamName().equals("Template Owner");
        return teamsIncludingInherited.stream().filter(withoutTemplateOwner).collect(Collectors.toList());
    }

    @POST
    @Timed
    @Path(value="{templateId:.*Release[^/-]*}/triggers")
    public void addTrigger(@PathParam(value="templateId") @IdParam String templateId, ReleaseTriggerView releaseTriggerView) {
        Release release = this.releases.findByIdIncludingArchived(templateId);
        Preconditions.checkArgument((boolean)release.isTemplate(), (Object)"Triggers can only be added to templates");
        this.permissions.check(XLReleasePermissions.CREATE_RELEASE_FROM_TEMPLATE, release);
        this.permissions.check(XLReleasePermissions.EDIT_TRIGGERS, release);
        Preconditions.checkArgument((boolean)releaseTriggerView.hasValidPeriodicity(), (Object)"Interval value is not valid for the selected type");
        Preconditions.checkArgument((!release.isArchived() ? 1 : 0) != 0, (Object)"Cannot add a trigger to an archived release");
        this.releaseActorService.addTrigger(templateId, this.releaseTriggerViewConverter.fromView(releaseTriggerView));
    }

    @GET
    @Timed
    @Path(value="{templateId:.*Release[^/-]*}/triggers")
    public List<ReleaseTriggerView> getTriggers(@PathParam(value="templateId") @IdParam String templateId) {
        Release template = this.releases.findById(templateId);
        this.permissions.check(XLReleasePermissions.EDIT_TRIGGERS, template);
        return template.getReleaseTriggers().stream().map(this.releaseTriggerViewConverter::toView).collect(Collectors.toList());
    }

    @GET
    @Timed
    @Path(value="{templateId:.*Release[^/-]*}/triggers/{triggerId:.*Trigger[^/-]*}")
    public ReleaseTriggerView getTrigger(@PathParam(value="templateId") @IdParam String templateId, @PathParam(value="triggerId") @IdParam String triggerId) {
        ReleaseTrigger releaseTrigger = this.releaseTriggers.find(triggerId);
        this.permissions.check(XLReleasePermissions.EDIT_TRIGGERS, releaseTrigger.getTemplate());
        return this.releaseTriggerViewConverter.toView(releaseTrigger);
    }

    @DELETE
    @Timed
    @Path(value="{templateId:.*Release[^/-]*}/triggers/{triggerId:.*Trigger[^/-]*}")
    public void removeTrigger(@PathParam(value="templateId") @IdParam String templateId, @PathParam(value="triggerId") @IdParam String triggerId) {
        this.permissions.check(XLReleasePermissions.EDIT_TRIGGERS, templateId);
        this.releaseActorService.deleteTrigger(templateId, triggerId);
    }

    @PUT
    @Timed
    @Path(value="{templateId:.*Release[^/-]*}/triggers/{triggerId:.*Trigger[^/-]*}")
    public void updateTrigger(@PathParam(value="templateId") @IdParam String templateId, @PathParam(value="triggerId") @IdParam String triggerId, ReleaseTriggerView releaseTriggerView) {
        this.permissions.check(XLReleasePermissions.EDIT_TRIGGERS, templateId);
        Preconditions.checkArgument((boolean)releaseTriggerView.hasValidPeriodicity(), (Object)"Interval value is not valid for the selected type");
        this.releaseActorService.updateTrigger(templateId, this.releaseTriggerViewConverter.fromView(releaseTriggerView));
    }

    private ReleaseFullView getReleaseFullView(Release release) {
        return this.releaseViewConverter.toFullView(release, this.taskAccessService.getAllowedTaskTypesForAuthenticatedUser(), Collections.emptyList(), Collections.singletonList("progress"), Integer.MAX_VALUE);
    }

    private PhaseFullView getPhaseFullView(Phase phase) {
        return this.phaseViewConverter.toFullView(phase, this.taskAccessService.getAllowedTaskTypesForAuthenticatedUser());
    }

    private TaskFullView getTaskFullView(Task task) {
        return this.tasksViewConverter.toFullView(task, this.taskAccessService.getAllowedTaskTypesForAuthenticatedUser());
    }
}

