/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plumbing.DateParam;
import com.xebialabs.xlrelease.calendar.ReleaseCalendar;
import com.xebialabs.xlrelease.configuration.SpecialDay;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.blackout.Blackout;
import com.xebialabs.xlrelease.repository.Calendar;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import java.util.Date;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/calendar")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class CalendarResource {
    private Releases releases;
    private Calendar calendar;
    private final PermissionChecker permissions;

    @Autowired
    public CalendarResource(Releases releases, Calendar calendar, PermissionChecker permissions) {
        this.releases = releases;
        this.calendar = calendar;
        this.permissions = permissions;
    }

    @GET
    @Timed
    @Path(value="/subscribe/{calendarToken}")
    public Response subscribe(@PathParam(value="calendarToken") String calendarToken) {
        Release release = this.releases.findByCalendarToken(calendarToken);
        if (release == null || !release.isCalendarPublished()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String ics = new ReleaseCalendar(release).toString();
        return Response.ok((Object)ics).build();
    }

    @GET
    @Timed
    @Path(value="/specialDays/{date}")
    public SpecialDay getSpecialDay(@PathParam(value="date") String date) {
        return this.calendar.getSpecialDay(date);
    }

    @PUT
    @Timed
    @Path(value="/specialDays/{date}")
    public SpecialDay setSpecialDay(@PathParam(value="date") String date, SpecialDay specialDay) {
        return this.calendar.setSpecialDay(date, specialDay);
    }

    @GET
    @Timed
    @Path(value="/specialDays")
    public List<SpecialDay> getSpecialDays(@QueryParam(value="from") String from, @QueryParam(value="to") String to) {
        return this.calendar.getSpecialDays(from, to);
    }

    @GET
    @Timed
    @Path(value="/blackouts")
    public List<Blackout> getBlackouts(@QueryParam(value="from") @DateParam Date from, @QueryParam(value="to") @DateParam Date to) {
        return this.calendar.getBlackouts(from, to);
    }

    @GET
    @Timed
    @Path(value="/blackouts/{blackoutId:.*/Blackout[^/]*}")
    public Blackout getBlackout(@PathParam(value="blackoutId") String blackoutId) {
        return this.calendar.getBlackout(blackoutId);
    }

    @POST
    @Timed
    @Path(value="/blackouts")
    public Blackout addBlackout(Blackout blackout) {
        this.permissions.check(XLReleasePermissions.EDIT_GLOBAL_BLACKOUT);
        return this.calendar.addBlackout(blackout);
    }

    @PUT
    @Timed
    @Path(value="/blackouts/{blackoutId:.*/Blackout[^/]*}")
    public Blackout updateBlackout(@PathParam(value="blackoutId") String blackoutId, Blackout blackout) {
        this.permissions.check(XLReleasePermissions.EDIT_GLOBAL_BLACKOUT);
        blackout.setId(blackoutId);
        return this.calendar.updateBlackout(blackout);
    }

    @DELETE
    @Timed
    @Path(value="/blackouts/{blackoutId:.*/Blackout[^/]*}")
    public void deleteBlackout(@PathParam(value="blackoutId") String blackoutId) {
        this.permissions.check(XLReleasePermissions.EDIT_GLOBAL_BLACKOUT);
        this.calendar.deleteBlackout(blackoutId);
    }

    @GET
    @Timed
    @Path(value="/blackouts/withinBlackout")
    public boolean withinBlackout() {
        return this.calendar.isInBlackout(new Date());
    }
}

