/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import com.xebialabs.deployit.plumbing.CurrentVersion;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class VersionEnforcerFilter
implements Filter {
    private static final String VERSION_PARAMETER = "xlrv";
    private String serverVersion;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.serverVersion = CurrentVersion.get();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String clientVersion;
        String[] values = request.getParameterValues(VERSION_PARAMETER);
        boolean doFilter = true;
        if (values != null && !(clientVersion = values[0]).equals(this.serverVersion)) {
            response.setContentType("text/plain");
            response.getWriter().write(String.format("%s version changed : you are using %s, but server version is now %s", "XL Release", clientVersion, this.serverVersion));
            ((HttpServletResponse)response).setStatus(410);
            doFilter = false;
        }
        if (doFilter) {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

