/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.core.rest.api.RepositoryResource;
import com.xebialabs.deployit.engine.api.RoleService;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plumbing.RequestLocal;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDirFactory;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.deployit.repository.internal.Root;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/repository")
@Consumes(value={"application/json", "application/xml"})
@Produces(value={"application/json", "application/xml"})
public class ExtendedRepositoryService
extends RepositoryResource {
    private static final String LEVEL = "level";
    private static final Type ROOT = Type.valueOf(Root.class);
    private static final Type DIRECTORY = Type.valueOf(Directory.class);
    private RepositoryService repositoryService;
    private PermissionChecker permissionChecker;
    private static final Logger logger = LoggerFactory.getLogger(ExtendedRepositoryService.class);

    @Autowired
    public ExtendedRepositoryService(RepositoryService repositoryService, Validator validator, RoleService roleService, WorkDirFactory workDirFactory, PermissionChecker permissionChecker) {
        super(repositoryService, validator, roleService, workDirFactory);
        this.repositoryService = repositoryService;
        this.permissionChecker = permissionChecker;
    }

    public ConfigurationItem read(String id) {
        if (Ids.isReleaseId((String)id)) {
            this.permissionChecker.checkView(id);
            return this.repositoryService.read(id);
        }
        return super.read(id);
    }

    public List<ConfigurationItem> read(List<String> ids) {
        ArrayList configurationItems = Lists.newArrayList();
        for (String id : ids) {
            try {
                ConfigurationItem entity = this.repositoryService.read(id, 1);
                configurationItems.add(entity);
            }
            catch (RuntimeException re) {
                logger.error("Could not read configuration item [{}]", (Object)id);
                logger.error("Exception was: ", (Throwable)re);
            }
        }
        return this.permissionChecker.filterViewables(configurationItems);
    }

    @GET
    @Path(value="tree/{ID:.*?}")
    public ConfigurationItem read(@PathParam(value="ID") String id, @QueryParam(value="level") Integer level) {
        this.setCiRefsFromLevel(level);
        return this.read(id);
    }

    @POST
    @Path(value="tree")
    public List<ConfigurationItem> read(List<String> ids, @QueryParam(value="level") Integer level) {
        this.setCiRefsFromLevel(level);
        return this.read(ids);
    }

    @GET
    @Path(value="export")
    public List<ConfigurationItem> export() {
        return this.export(this.listAllIds());
    }

    @GET
    @Path(value="export/{ID:.*?}")
    public List<ConfigurationItem> export(@PathParam(value="ID") String id) {
        ConfigurationItem ci = this.read(id);
        ConfigurationItemId typedId = ExtendedRepositoryService.toId(ci);
        ArrayList ids = Lists.newArrayList((Object[])new ConfigurationItemId[]{typedId});
        this.addNested(typedId, ids);
        return this.export(ids);
    }

    private List<ConfigurationItem> export(List<ConfigurationItemId> ids) {
        List<ConfigurationItem> cis = this.read(ExtendedRepositoryService.toString(ids), null);
        cis.forEach(CiHelper::eraseTokens);
        return cis;
    }

    private List<ConfigurationItemId> listAllIds() {
        ArrayList ids = Lists.newArrayList();
        for (Metadata.ConfigurationItemRoot root : Metadata.ConfigurationItemRoot.values()) {
            if (root.getRootNodeName() == null) continue;
            this.addNested(new ConfigurationItemId(root.getRootNodeName(), ROOT), ids);
        }
        return ids;
    }

    private void addNested(ConfigurationItemId parent, List<ConfigurationItemId> foundIds) {
        if (!parent.getType().equals((Object)ROOT) && !parent.getType().equals((Object)DIRECTORY)) {
            return;
        }
        List children = this.query(null, parent.getId(), null, null, null, null, 0L, -1L);
        for (ConfigurationItemId child : children) {
            foundIds.add(child);
            if (!child.getType().equals((Object)DIRECTORY)) continue;
            this.addNested(child, foundIds);
        }
    }

    private static List<String> toString(List<ConfigurationItemId> cis) {
        ArrayList<String> ids = new ArrayList<String>();
        for (ConfigurationItemId ci : cis) {
            ids.add(ci.getId());
        }
        return ids;
    }

    public void setCiRefsFromLevel(Integer level) {
        level = Optional.ofNullable(level).orElse(Integer.MAX_VALUE);
        RequestLocal.getMap().put(LEVEL, level);
    }

    private static ConfigurationItemId toId(ConfigurationItem ci) {
        return new ConfigurationItemId(ci.getId(), ci.getType());
    }
}

