package com.xebialabs.xlrelease.scheduler.storage.spring

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.storage.Storage
import com.xebialabs.xlrelease.storage.local.LocalStorage
import com.xebialabs.xlrelease.storage.s3.S3Storage
import com.xebialabs.xlrelease.storage.service.{DefaultStorageService, StorageService}
import org.springframework.context.annotation._

@Configuration
class StorageConfiguration(xlrConfig: XlrConfig) {

  private val storageType = xlrConfig.jobLog.storageType

  @Bean
  def logStorage: Storage = {
    if (storageType == StorageConfiguration.URI_SCHEME_S3_STORAGE) {
      new S3Storage(xlrConfig.jobLog.s3StorageConfig)
    } else {
      new LocalStorage(xlrConfig.jobLog.localStorageConfig)
    }
  }
  
  @Bean
  def storageService(storages: Array[Storage]): StorageService = {
    new DefaultStorageService(storages, storageType)
  }
}

object StorageConfiguration {
  final val URI_SCHEME_LOCAL_STORAGE = "xlr-local"
  final val URI_SCHEME_S3_STORAGE = "xlr-s3"
}
