package com.xebialabs.xlrelease.actors.initializer

import com.xebialabs.xlrelease.actors.initializer.ActorInitializerOrder.RELEASE_CLEANUP
import com.xebialabs.xlrelease.actors.{ActorSystemHolder, ReleaseCleanupActor}
import com.xebialabs.xlrelease.config.XlrConfig
import grizzled.slf4j.Logging
import org.springframework.stereotype.Component

@Component
class ReleaseCleanupInitializer(xlrConfig: XlrConfig, actorSystemHolder: ActorSystemHolder)
  extends ManagedActorInitializer with Logging {

  private lazy val actor = if (xlrConfig.isClusterEnabled) {
    actorSystemHolder.clusterSingletonActorOf[ReleaseCleanupActor](classOf[ReleaseCleanupActor], ReleaseCleanupActor.name)
  } else {
    actorSystemHolder.actorOf[ReleaseCleanupActor](classOf[ReleaseCleanupActor], ReleaseCleanupActor.name)
  }

  override def doStart(): Unit = {
    // TODO if we remove actor initializer then actor holder has to be created conditionally (only if it's NOT in maintenance mode)
    //  same for other BaseBackgroundJobActor implementations
    if (xlrConfig.maintenanceModeEnabled) {
      logger.debug("[MAINTENANCE MODE] release cleanup scheduler actor - DISABLED")
    } else {
      logger.debug("Initializing release cleanup actor...")
      actor
    }
  }

  override def doStop(): Unit = ()

  override def getOrder: Int = RELEASE_CLEANUP
}

