/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views.converters;

import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.views.DependencyNode;
import com.xebialabs.xlrelease.views.DependencyView;
import com.xebialabs.xlrelease.views.VariableOrDependencyView;
import com.xebialabs.xlrelease.views.converters.DependencyNodeFactory;

public class DependencyViewConverter {
    private DependencyViewConverter() {
        throw new IllegalStateException("Utility class");
    }

    public static DependencyView toDependencyView(Dependency dependency) {
        VariableOrDependencyView variableOrTarget;
        if (dependency.isArchived()) {
            DependencyNode dependencyNode = DependencyNodeFactory.fromArchivedDependency(dependency);
            variableOrTarget = new VariableOrDependencyView(dependencyNode);
        } else if (dependency.hasVariableTarget() || !dependency.hasResolvedTarget() && dependency.getTargetId() != null) {
            variableOrTarget = new VariableOrDependencyView(dependency.getTargetId());
        } else if (dependency.hasResolvedTarget()) {
            DependencyNode dependencyNode = DependencyNodeFactory.fromTarget(dependency.getTarget());
            variableOrTarget = new VariableOrDependencyView(dependencyNode);
        } else {
            variableOrTarget = new VariableOrDependencyView(new DependencyNode());
        }
        return new DependencyView(dependency.getId(), variableOrTarget, dependency.isDone(), dependency.isArchived());
    }
}

