/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.authentication;

import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.Users;
import com.xebialabs.xlrelease.service.accountlock.AccountLockProtectionService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.context.event.EventListener;
import org.springframework.security.authentication.event.AuthenticationFailureBadCredentialsEvent;
import org.springframework.security.authentication.event.AuthenticationFailureLockedEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005a\u0001B\u0006\r\u0001UA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\t[\u0001\u0011\t\u0011)A\u0005]!A!\u0007\u0001B\u0001B\u0003%1\u0007C\u0003:\u0001\u0011\u0005!\bC\u0004A\u0001\t\u0007I\u0011B!\t\r\u0015\u0003\u0001\u0015!\u0003C\u0011\u001d1\u0005A1A\u0005\n\u001dCaA\u0016\u0001!\u0002\u0013A\u0005\"B,\u0001\t\u0003A\u0006\"\u0002:\u0001\t\u0003\u0019(AI!vi\",g\u000e^5dCRLwN\u001c$bS2,(/Z#wK:$H*[:uK:,'O\u0003\u0002\u000e\u001d\u0005q\u0011-\u001e;iK:$\u0018nY1uS>t'BA\b\u0011\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u0012%\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002'\u0005\u00191m\\7\u0004\u0001M\u0019\u0001A\u0006\u000f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\r\u0005s\u0017PU3g!\ti\"%D\u0001\u001f\u0015\ty\u0002%A\u0003tY\u001a$$NC\u0001\"\u0003!9'/\u001b>{Y\u0016$\u0017BA\u0012\u001f\u0005\u001daunZ4j]\u001e\fA$Y2d_VtG\u000fT8dWB\u0013x\u000e^3di&|gnU3sm&\u001cW\r\u0005\u0002'W5\tqE\u0003\u0002)S\u0005Y\u0011mY2pk:$Hn\\2l\u0015\tQc\"A\u0004tKJ4\u0018nY3\n\u00051:#\u0001H!dG>,h\u000e\u001e'pG.\u0004&o\u001c;fGRLwN\\*feZL7-Z\u0001\u0010kN,'o\u001d*fa>\u001c\u0018\u000e^8ssB\u0011q\u0006M\u0007\u0002S%\u0011\u0011'\u000b\u0002\u0006+N,'o]\u0001\nq2\u00148i\u001c8gS\u001e\u0004\"\u0001N\u001c\u000e\u0003UR!A\u000e\b\u0002\r\r|gNZ5h\u0013\tATGA\u0005YYJ\u001cuN\u001c4jO\u00061A(\u001b8jiz\"BaO\u001f?\u007fA\u0011A\bA\u0007\u0002\u0019!)A\u0005\u0002a\u0001K!)Q\u0006\u0002a\u0001]!)!\u0007\u0002a\u0001g\u00059\u0012n]!dG>,h\u000e\u001e'pG.|W\u000f^#oC\ndW\rZ\u000b\u0002\u0005B\u0011qcQ\u0005\u0003\tb\u0011qAQ8pY\u0016\fg.\u0001\rjg\u0006\u001b7m\\;oi2{7m[8vi\u0016s\u0017M\u00197fI\u0002\nab\u001e5ji\u0016d\u0017n\u001d;Vg\u0016\u00148/F\u0001I!\rI\u0005k\u0015\b\u0003\u0015:\u0003\"a\u0013\r\u000e\u00031S!!\u0014\u000b\u0002\rq\u0012xn\u001c;?\u0013\ty\u0005$\u0001\u0004Qe\u0016$WMZ\u0005\u0003#J\u00131aU3u\u0015\ty\u0005\u0004\u0005\u0002J)&\u0011QK\u0015\u0002\u0007'R\u0014\u0018N\\4\u0002\u001f]D\u0017\u000e^3mSN$Xk]3sg\u0002\nqc\u001c8BkRDWM\u001c;jG\u0006$\u0018n\u001c8GC&dWO]3\u0015\u0005ec\u0006CA\f[\u0013\tY\u0006D\u0001\u0003V]&$\b\"B/\n\u0001\u0004q\u0016!B3wK:$\bCA0i\u001b\u0005\u0001'BA/b\u0015\ti!M\u0003\u0002dI\u0006A1/Z2ve&$\u0018P\u0003\u0002fM\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001h\u0003\ry'oZ\u0005\u0003S\u0002\u0014\u0001&Q;uQ\u0016tG/[2bi&|gNR1jYV\u0014XMQ1e\u0007J,G-\u001a8uS\u0006d7/\u0012<f]RD#!C6\u0011\u00051\u0004X\"A7\u000b\u0005us'BA8e\u0003\u001d\u0019wN\u001c;fqRL!!]7\u0003\u001b\u00153XM\u001c;MSN$XM\\3s\u0003\tzg.Q;uQ\u0016tG/[2bi&|gNR1jYV\u0014X\rT8dW\u0016$WI^3oiR\u0011\u0011\f\u001e\u0005\u0006;*\u0001\r!\u001e\t\u0003?ZL!a\u001e1\u0003A\u0005+H\u000f[3oi&\u001c\u0017\r^5p]\u001a\u000b\u0017\u000e\\;sK2{7m[3e\u000bZ,g\u000e\u001e\u0015\u0003\u0015-D#\u0001\u0001>\u0011\u0005mtX\"\u0001?\u000b\u0005u$\u0017AC:uKJ,w\u000e^=qK&\u0011q\u0010 \u0002\n\u0007>l\u0007o\u001c8f]R\u0004")
public class AuthenticationFailureEventListener
implements Logging {
    private final AccountLockProtectionService accountLockProtectionService;
    private final Users usersRepository;
    private final boolean isAccountLockoutEnabled;
    private final Set<String> whitelistUsers;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        AuthenticationFailureEventListener authenticationFailureEventListener = this;
        synchronized (authenticationFailureEventListener) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private boolean isAccountLockoutEnabled() {
        return this.isAccountLockoutEnabled;
    }

    private Set<String> whitelistUsers() {
        return this.whitelistUsers;
    }

    @EventListener
    public void onAuthenticationFailure(AuthenticationFailureBadCredentialsEvent event) {
        Authentication authentication = event.getAuthentication();
        AuthenticationException exception = event.getException();
        String username = authentication.getName();
        this.logger().debug((Function0 & Serializable)() -> "Authentication failure for user [" + event.getAuthentication().getName() + "]. Reason: " + exception.getMessage());
        if (this.isAccountLockoutEnabled() && !this.whitelistUsers().contains((Object)username) && !XLReleasePermissions.isAdmin((String)username)) {
            Object object = authentication.getPrincipal();
            if (this.usersRepository.userExistsInRepository(authentication.getName())) {
                this.logger().debug((Function0 & Serializable)() -> "Account lockout is enabled.Processing account lockout checks for Internal user. " + username);
                this.accountLockProtectionService.recordFailedAttempt(username);
                return;
            }
            this.logger().debug((Function0 & Serializable)() -> "skipping account lock protection checks for user " + username + " as it is not an internal user.");
            return;
        }
        this.logger().debug((Function0 & Serializable)() -> "Account lockout is disabled or the user " + username + " is whitelisted  Skipping protection checks.");
    }

    @EventListener
    public void onAuthenticationFailureLockedEvent(AuthenticationFailureLockedEvent event) {
        Authentication authentication = event.getAuthentication();
        AuthenticationException exception = event.getException();
        String username = authentication.getName();
        this.logger().debug((Function0 & Serializable)() -> "Authentication failure for user [" + event.getAuthentication().getName() + "]. Reason: " + exception.getMessage());
        if (this.isAccountLockoutEnabled() && !this.whitelistUsers().contains((Object)username) && !XLReleasePermissions.isAdmin((String)username)) {
            Object object = authentication.getPrincipal();
            if (this.usersRepository.userExistsInRepository(authentication.getName())) {
                this.logger().debug((Function0 & Serializable)() -> "Account lockout is enabled. Publishing authentication failure Lockout audit event for internal user: " + username);
                this.accountLockProtectionService.publishAuthenticationFailureLockEvent(username);
                return;
            }
            this.logger().debug((Function0 & Serializable)() -> "skipping reset account lock protection checks for user " + username + " as it is not an internal user.");
            return;
        }
        this.logger().debug((Function0 & Serializable)() -> "Account lockout is disabled or the user " + username + " is whitelisted, skipping lock audit.");
    }

    public AuthenticationFailureEventListener(AccountLockProtectionService accountLockProtectionService, Users usersRepository, XlrConfig xlrConfig) {
        this.accountLockProtectionService = accountLockProtectionService;
        this.usersRepository = usersRepository;
        Logging.$init$((Logging)this);
        this.isAccountLockoutEnabled = xlrConfig.isAccountLockoutEnabled();
        this.whitelistUsers = CollectionConverters$.MODULE$.ListHasAsScala(xlrConfig.whiteListUser()).asScala().toSet();
    }
}

