/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service.accountlock;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.domain.events.AccountLockedEvent;
import com.xebialabs.xlrelease.domain.events.AccountUnlockAndFailedAttemptsResetEvent;
import com.xebialabs.xlrelease.domain.events.AccountUnlockedAfterSuccessfulLoginEvent;
import com.xebialabs.xlrelease.domain.events.AuthenticationFailureLockEvent;
import com.xebialabs.xlrelease.domain.events.AutoLockThresholdNotReachedEvent;
import com.xebialabs.xlrelease.domain.events.FailedLoginAttemptEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.service.UserProfileService;
import com.xebialabs.xlrelease.service.Users;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005-g\u0001\u0002\u000b\u0016\u0001\u0001B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!A1\b\u0001B\u0001B\u0003%A\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u0011\u00151\u0005\u0001\"\u0001H\u0011\u001dq\u0005A1A\u0005\n=Caa\u0015\u0001!\u0002\u0013\u0001\u0006b\u0002+\u0001\u0005\u0004%I!\u0016\u0005\u0007=\u0002\u0001\u000b\u0011\u0002,\t\u000f}\u0003!\u0019!C\u0005A\"1A\r\u0001Q\u0001\n\u0005DQ!\u001a\u0001\u0005\u0002\u0019Dq!a\u0011\u0001\t\u0013\t)\u0005C\u0004\u0002`\u0001!I!!\u0019\t\u000f\u0005]\u0004\u0001\"\u0003\u0002z!9\u00111\u0014\u0001\u0005\n\u0005u\u0005bBAV\u0001\u0011\u0005\u0011Q\u0016\u0005\b\u0003c\u0003A\u0011AAZ\u0011\u001d\t9\f\u0001C\u0001\u0003s\u0013A$Q2d_VtG\u000fT8dWB\u0013x\u000e^3di&|gnU3sm&\u001cWM\u0003\u0002\u0017/\u0005Y\u0011mY2pk:$Hn\\2l\u0015\tA\u0012$A\u0004tKJ4\u0018nY3\u000b\u0005iY\u0012!\u0003=me\u0016dW-Y:f\u0015\taR$A\u0005yK\nL\u0017\r\\1cg*\ta$A\u0002d_6\u001c\u0001aE\u0002\u0001C\u001d\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0007C\u0001\u0015.\u001b\u0005I#B\u0001\u0016,\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005a\u0013\u0001C4sSjTH.\u001a3\n\u00059J#a\u0002'pO\u001eLgnZ\u0001\nq2\u00148i\u001c8gS\u001e\u0004\"!\r\u001b\u000e\u0003IR!aM\r\u0002\r\r|gNZ5h\u0013\t)$GA\u0005YYJ\u001cuN\u001c4jO\u0006\u0011Ro]3s!J|g-\u001b7f'\u0016\u0014h/[2f!\tA\u0014(D\u0001\u0018\u0013\tQtC\u0001\nVg\u0016\u0014\bK]8gS2,7+\u001a:wS\u000e,\u0017\u0001C3wK:$()^:\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}J\u0012AB3wK:$8/\u0003\u0002B}\tAQI^3oi\n+8/A\bvg\u0016\u00148OU3q_NLGo\u001c:z!\tAD)\u0003\u0002F/\t)Qk]3sg\u00061A(\u001b8jiz\"R\u0001\u0013&L\u00196\u0003\"!\u0013\u0001\u000e\u0003UAQaL\u0003A\u0002ABQAN\u0003A\u0002]BQaO\u0003A\u0002qBQAQ\u0003A\u0002\r\u000b\u0011#T1y\r\u0006LG.\u001a3BiR,W\u000e\u001d;t+\u0005\u0001\u0006C\u0001\u0012R\u0013\t\u00116EA\u0002J]R\f!#T1y\r\u0006LG.\u001a3BiR,W\u000e\u001d;tA\u00051\u0012mY2pk:$Hj\\2l_V$H)\u001e:bi&|g.F\u0001W!\t9F,D\u0001Y\u0015\tI&,\u0001\u0005ekJ\fG/[8o\u0015\tY6%\u0001\u0006d_:\u001cWO\u001d:f]RL!!\u0018-\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\u00069\u0012mY2pk:$Hj\\2l_V$H)\u001e:bi&|g\u000eI\u0001\u0016C\u000e\u001cw.\u001e8u\u0019>\u001c7n\\;u\u000b:\f'\r\\3e+\u0005\t\u0007C\u0001\u0012c\u0013\t\u00197EA\u0004C_>dW-\u00198\u0002-\u0005\u001c7m\\;oi2{7m[8vi\u0016s\u0017M\u00197fI\u0002\n1C]3d_J$g)Y5mK\u0012\fE\u000f^3naR$\"aZ7\u0011\u0005!\\W\"A5\u000b\u0005)L\u0012A\u00023p[\u0006Lg.\u0003\u0002mS\nYQk]3s!J|g-\u001b7f\u0011\u0015qG\u00021\u0001p\u0003!)8/\u001a:oC6,\u0007C\u00019x\u001d\t\tX\u000f\u0005\u0002sG5\t1O\u0003\u0002u?\u00051AH]8pizJ!A^\u0012\u0002\rA\u0013X\rZ3g\u0013\tA\u0018P\u0001\u0004TiJLgn\u001a\u0006\u0003m\u000eB#\u0003D>\u0002\u0010\u0005E\u0011QCA\f\u0003C\t\u0019#!\f\u00020A\u0019A0a\u0003\u000e\u0003uT!A`@\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0003\u0002\u0002\u0005\r\u0011a\u0003;sC:\u001c\u0018m\u0019;j_:TA!!\u0002\u0002\b\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0002\n\u0005\u0019qN]4\n\u0007\u00055QPA\u0007Ue\u0006t7/Y2uS>t\u0017\r\\\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003'\tq\u0004\u001f7s%\u0016\u0004xn]5u_JLHK]1og\u0006\u001cG/[8o\u001b\u0006t\u0017mZ3s\u0003-\u0001(o\u001c9bO\u0006$\u0018n\u001c8%\u0005\u0005e\u0011\u0002BA\u000e\u0003;\t\u0001BU#R+&\u0013V\t\u0012\u0006\u0004\u0003?i\u0018a\u0003)s_B\fw-\u0019;j_:\f\u0011\"[:pY\u0006$\u0018n\u001c8%\u0005\u0005\u0015\u0012\u0002BA\u0014\u0003S\taBU#B\t~\u001bu*T'J)R+EIC\u0002\u0002,u\f\u0011\"S:pY\u0006$\u0018n\u001c8\u0002\u001b9|'k\u001c7mE\u0006\u001c7NR8sY\t\t\td\t\u0002\u00024A!\u0011QGA \u001b\t\t9D\u0003\u0003\u0002:\u0005m\u0012!C3yG\u0016\u0004H/[8o\u0015\r\tidG\u0001\tI\u0016\u0004Hn\\=ji&!\u0011\u0011IA\u001c\u0005Equ\u000e\u001e$pk:$W\t_2faRLwN\\\u0001\u0012G\u0006d7-\u001e7bi\u0016tUm^*uCR,G\u0003DA$\u0003\u001b\n\t&!\u0016\u0002Z\u0005u\u0003#\u0002\u0012\u0002JA\u000b\u0017bAA&G\t1A+\u001e9mKJBa!a\u0014\u000e\u0001\u0004\u0001\u0016\u0001D2veJ,g\u000e^\"pk:$\bBBA*\u001b\u0001\u0007\u0011-A\u0007dkJ\u0014XM\u001c;M_\u000e\\W\r\u001a\u0005\u0007\u0003/j\u0001\u0019A1\u0002\u0017MDw.\u001e7e%\u0016\u001cX\r\u001e\u0005\u0007\u00037j\u0001\u0019\u0001)\u0002!5\f\u0007PR1jY\u0016$\u0017\t\u001e;f[B$\b\"\u00028\u000e\u0001\u0004y\u0017a\u00047pON#\u0018\r^3DQ\u0006tw-Z:\u0015\u0019\u0005\r\u0014\u0011NA6\u0003[\ny'a\u001d\u0011\u0007\t\n)'C\u0002\u0002h\r\u0012A!\u00168ji\")aN\u0004a\u0001_\"1\u0011q\n\bA\u0002ACa!a\u0015\u000f\u0001\u0004\t\u0007BBA9\u001d\u0001\u0007\u0001+\u0001\u0005oK^\u001cu.\u001e8u\u0011\u0019\t)H\u0004a\u0001C\u0006Ia.Z<M_\u000e\\W\rZ\u0001\u0011g\"|W\u000f\u001c3TW&\u0004X\u000b\u001d3bi\u0016$r!YA>\u0003{\n9\n\u0003\u0004\u0002T=\u0001\r!\u0019\u0005\b\u0003\u007fz\u0001\u0019AAA\u00031a\u0017m\u001d;GC&dW\rZ!u!\u0015\u0011\u00131QAD\u0013\r\t)i\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005%\u00151S\u0007\u0003\u0003\u0017SA!!$\u0002\u0010\u0006!Q\u000f^5m\u0015\t\t\t*\u0001\u0003kCZ\f\u0017\u0002BAK\u0003\u0017\u0013A\u0001R1uK\"9\u0011\u0011T\bA\u0002\u0005\u001d\u0015aE;oY>\u001c7\u000e\u00165sKNDw\u000e\u001c3US6,\u0017aE4fi6Kg.\u001e;fgJ+W.Y5oS:<GCBAP\u0003K\u000b9\u000bE\u0002#\u0003CK1!a)$\u0005\u0011auN\\4\t\u000f\u0005}\u0004\u00031\u0001\u0002\b\"9\u0011\u0011\u0016\tA\u0002\u0005\u001d\u0015a\u00018po\u0006y\u0011n]!dG>,h\u000e\u001e'pG.,G\rF\u0002b\u0003_CQA\\\tA\u0002=\fAE]3tKR4\u0015-\u001b7fI\u0006#H/Z7qiN\fe\r^3s'V\u001c7-Z:t\u0019><\u0017N\u001c\u000b\u0005\u0003G\n)\fC\u0003o%\u0001\u0007q.A\u0013qk\nd\u0017n\u001d5BkRDWM\u001c;jG\u0006$\u0018n\u001c8GC&dWO]3M_\u000e\\WI^3oiR!\u00111MA^\u0011\u0015q7\u00031\u0001pQ\r\u0001\u0011q\u0018\t\u0005\u0003\u0003\f9-\u0004\u0002\u0002D*!\u0011QYA\u0002\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003\u0013\f\u0019MA\u0004TKJ4\u0018nY3")
public class AccountLockProtectionService
implements Logging {
    private final UserProfileService userProfileService;
    private final EventBus eventBus;
    private final Users usersRepository;
    private final int MaxFailedAttempts;
    private final FiniteDuration accountLockoutDuration;
    private final boolean accountLockoutEnabled;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        AccountLockProtectionService accountLockProtectionService = this;
        synchronized (accountLockProtectionService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private int MaxFailedAttempts() {
        return this.MaxFailedAttempts;
    }

    private FiniteDuration accountLockoutDuration() {
        return this.accountLockoutDuration;
    }

    private boolean accountLockoutEnabled() {
        return this.accountLockoutEnabled;
    }

    @Transactional(value="xlrRepositoryTransactionManager", propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, noRollbackFor={NotFoundException.class})
    public UserProfile recordFailedAttempt(String username) {
        Option lastFailedAt;
        Date now = new Date();
        Date unlockThresholdTime = new Date(now.getTime() - this.accountLockoutDuration().toMillis());
        UserProfile userProfile = this.userProfileService.findByUsernameForUpdate(username);
        if (userProfile == null) {
            this.logger().error((Function0 & Serializable)() -> "[AccountLockProtectionService][" + username + "]: User profile for [" + username + "] not found. Cannot record failed login attempt.");
            return null;
        }
        int currentCount = userProfile.getLastFailedLoginAttemptCount();
        boolean currentLocked = userProfile.isAccountLocked();
        if (this.shouldSkipUpdate(currentLocked, (Option<Date>)(lastFailedAt = Option$.MODULE$.apply((Object)userProfile.getLastFailedLoginAt())), unlockThresholdTime)) {
            long minutesRemaining = this.getMinutesRemaining((Date)lastFailedAt.get(), now);
            AutoLockThresholdNotReachedEvent event = new AutoLockThresholdNotReachedEvent(currentCount, minutesRemaining);
            event.user_$eq(username);
            this.eventBus.publish((XLReleaseEvent)event);
            return userProfile;
        }
        boolean shouldReset = lastFailedAt.isEmpty() || lastFailedAt.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.before(unlockThresholdTime)));
        this.logger().debug((Function0 & Serializable)() -> "[AccountLockProtectionService][" + username + "] - Calculating new state: currentCount=" + currentCount + ", currentLocked=" + currentLocked + ", shouldReset=" + shouldReset);
        Tuple2<Object, Object> tuple2 = this.calculateNewState(currentCount, currentLocked, shouldReset, this.MaxFailedAttempts(), username);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int newCount = tuple2._1$mcI$sp();
        boolean newLocked = tuple2._2$mcZ$sp();
        Tuple2.mcIZ.sp sp2 = new Tuple2.mcIZ.sp(newCount, newLocked);
        int newCount2 = sp2._1$mcI$sp();
        boolean newLocked2 = sp2._2$mcZ$sp();
        int rowsUpdated = this.userProfileService.updateFailedLoginAttempt(username, newCount2, Predef$.MODULE$.boolean2Boolean(newLocked2), now, Predef$.MODULE$.boolean2Boolean(true));
        if (rowsUpdated > 0) {
            userProfile.setLastFailedLoginAttemptCount(newCount2);
            userProfile.setAccountLocked(newLocked2);
            userProfile.setLastFailedLoginAt(now);
            this.logStateChanges(username, currentCount, currentLocked, newCount2, newLocked2);
        } else {
            this.logger().error((Function0 & Serializable)() -> "[AccountLockProtectionService][" + username + "]: Failed to update failed login attempt for user [" + username + "]. No rows affected.");
        }
        return userProfile;
    }

    private Tuple2<Object, Object> calculateNewState(int currentCount, boolean currentLocked, boolean shouldReset, int maxFailedAttempt, String username) {
        boolean shouldLock;
        if (currentLocked && shouldReset) {
            this.logger().debug((Function0 & Serializable)() -> "[AccountLockProtectionService][" + username + "]: Account locked and threshold passed. Unlocking and resetting counter to 1.");
            return new Tuple2.mcIZ.sp(1, false);
        }
        if (currentLocked) {
            this.logger().debug((Function0 & Serializable)() -> "[AccountLockProtectionService][" + username + "]: Account locked, threshold not passed. Freezing counter at " + currentCount + ".");
            return new Tuple2.mcIZ.sp(currentCount, true);
        }
        int incrementedCount = currentCount + 1;
        boolean bl = shouldLock = incrementedCount >= maxFailedAttempt;
        if (shouldLock) {
            this.logger().debug((Function0 & Serializable)() -> "[AccountLockProtectionService][" + username + "]: Incrementing counter to " + incrementedCount + " and locking account.");
            return new Tuple2.mcIZ.sp(incrementedCount, true);
        }
        this.logger().debug((Function0 & Serializable)() -> "[AccountLockProtectionService][" + username + "]: Incrementing counter to " + incrementedCount + ". Account remains unlocked.");
        return new Tuple2.mcIZ.sp(incrementedCount, false);
    }

    private void logStateChanges(String username, int currentCount, boolean currentLocked, int newCount, boolean newLocked) {
        if (!currentLocked && newLocked) {
            long autoUnlockMinutes = this.accountLockoutDuration().toMinutes();
            this.logger().warn((Function0 & Serializable)() -> "[AccountLockProtectionService][" + username + "]: Account locked for user [" + username + "] after reaching " + newCount + " failed attempts. Auto-unlock in " + autoUnlockMinutes + " minutes.");
            AccountLockedEvent event = new AccountLockedEvent(newCount, autoUnlockMinutes);
            event.user_$eq(username);
            this.eventBus.publish((XLReleaseEvent)event);
        }
        if (currentLocked && !newLocked) {
            AccountUnlockAndFailedAttemptsResetEvent event = new AccountUnlockAndFailedAttemptsResetEvent(newCount);
            event.user_$eq(username);
            this.eventBus.publish((XLReleaseEvent)event);
        }
        if (!currentLocked && !newLocked && newCount > currentCount) {
            FailedLoginAttemptEvent event = new FailedLoginAttemptEvent(newCount, this.MaxFailedAttempts());
            event.user_$eq(username);
            this.eventBus.publish((XLReleaseEvent)event);
            return;
        }
    }

    private boolean shouldSkipUpdate(boolean currentLocked, Option<Date> lastFailedAt, Date unlockThresholdTime) {
        return currentLocked && lastFailedAt.exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.after(unlockThresholdTime)));
    }

    private long getMinutesRemaining(Date lastFailedAt, Date now) {
        Date unlockTime = new Date(lastFailedAt.getTime() + this.accountLockoutDuration().toMillis());
        long remainingMillis = unlockTime.getTime() - now.getTime();
        return Math.max(0L, remainingMillis / 60000L);
    }

    public boolean isAccountLocked(String username) {
        Date unlockThresholdTime;
        if (!this.accountLockoutEnabled()) {
            this.logger().debug((Function0 & Serializable)() -> "[AccountLockProtectionService][" + username + "] - Account lockout not enabled.");
            return false;
        }
        UserProfile userProfile = this.userProfileService.findByUsername(username);
        if (userProfile == null || !userProfile.isAccountLocked()) {
            this.logger().debug((Function0 & Serializable)() -> "[AccountLockProtectionService][" + username + "] - User not found or Account not locked.");
            return false;
        }
        Date now = new Date();
        Option lastFailedAt = Option$.MODULE$.apply((Object)userProfile.getLastFailedLoginAt());
        boolean isLockedAndThresholdNotReached = lastFailedAt.exists(arg_0 -> AccountLockProtectionService.$anonfun$isAccountLocked$3$adapted(unlockThresholdTime = new Date(now.getTime() - this.accountLockoutDuration().toMillis()), arg_0));
        if (isLockedAndThresholdNotReached) {
            this.logger().debug((Function0 & Serializable)() -> "[AccountLockProtectionService][" + username + "] - Account locked: " + userProfile.isAccountLocked() + ", threshold NOT reached: " + isLockedAndThresholdNotReached + ". Returning true.");
        } else {
            this.logger().debug((Function0 & Serializable)() -> "[AccountLockProtectionService][" + username + "] - Account locked: " + userProfile.isAccountLocked() + ", threshold reached: " + !isLockedAndThresholdNotReached + ". Returning false.");
        }
        return isLockedAndThresholdNotReached;
    }

    public void resetFailedAttemptsAfterSuccessLogin(String username) {
        if (this.accountLockoutEnabled() && this.usersRepository.userExistsInRepository(username)) {
            UserProfile userProfile = this.userProfileService.findByUsername(username);
            if (userProfile.isAccountLocked() || userProfile.getLastFailedLoginAttemptCount() > 0) {
                int rowsUpdated = this.userProfileService.updateFailedLoginAttempt(username, 0, Predef$.MODULE$.boolean2Boolean(false), null, Predef$.MODULE$.boolean2Boolean(true));
                if (rowsUpdated > 0) {
                    this.logger().debug((Function0 & Serializable)() -> "[AccountLockProtectionService][" + username + "] - Reset failed login attempts and unlock account if locked.");
                    AccountUnlockedAfterSuccessfulLoginEvent event = new AccountUnlockedAfterSuccessfulLoginEvent();
                    event.user_$eq(username);
                    this.eventBus.publish((XLReleaseEvent)event);
                    return;
                }
                this.logger().error((Function0 & Serializable)() -> "[AccountLockProtectionService][" + username + "]: Failed to reset failed login attempts. No rows affected.");
                return;
            }
            this.logger().debug((Function0 & Serializable)() -> "[AccountLockProtectionService][" + username + "] - No reset needed. Account not locked and failed attempts is 0.");
            return;
        }
    }

    public void publishAuthenticationFailureLockEvent(String username) {
        AuthenticationFailureLockEvent event = new AuthenticationFailureLockEvent();
        event.user_$eq(username);
        this.eventBus.publish((XLReleaseEvent)event);
    }

    public AccountLockProtectionService(XlrConfig xlrConfig, UserProfileService userProfileService, EventBus eventBus, Users usersRepository) {
        this.userProfileService = userProfileService;
        this.eventBus = eventBus;
        this.usersRepository = usersRepository;
        Logging.$init$((Logging)this);
        this.MaxFailedAttempts = xlrConfig.maxFailedLoginAttempt();
        this.accountLockoutDuration = xlrConfig.accountLockoutDuration();
        this.accountLockoutEnabled = xlrConfig.isAccountLockoutEnabled();
    }

    public static final /* synthetic */ Object $anonfun$isAccountLocked$3$adapted(Date unlockThresholdTime$3, Date x$4) {
        return BoxesRunTime.boxToBoolean((boolean)x$4.after(unlockThresholdTime$3));
    }
}

