/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service.blackout;

import com.xebialabs.xlrelease.actors.ActorSystemHolder;
import com.xebialabs.xlrelease.actors.ExceptionTranslate;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.ReleaseExecutionActor;
import com.xebialabs.xlrelease.actors.ReleaseExecutionActorMessages;
import com.xebialabs.xlrelease.actors.extension.ActorExtensionHandlerFactory;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata$;
import com.xebialabs.xlrelease.domain.blackout.BlackoutPeriod;
import com.xebialabs.xlrelease.domain.events.BlackoutDeletedEvent;
import com.xebialabs.xlrelease.domain.events.BlackoutUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TaskUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.blackout.BlackoutReleaseExecutionActorMessages;
import com.xebialabs.xlrelease.service.blackout.BlackoutTaskEventHandler$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Date;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;

@Service
@ScalaSignature(bytes="\u0006\u0005\t\u001dc\u0001B\u000b\u0017\u0001\u0005B\u0001\u0002\u000f\u0001\u0003\u0006\u0004%\t!\u000f\u0005\t}\u0001\u0011\t\u0011)A\u0005u!Aq\b\u0001BC\u0002\u0013\u0005\u0001\t\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003B\u0011!A\u0005A!b\u0001\n\u0003I\u0005\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011\u0002&\t\u00119\u0003!Q1A\u0005\u0002=C\u0001B\u0016\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\u0006/\u0002!\t\u0001\u0017\u0005\u0006?\u0002!\t\u0001\u0019\u0005\u0006[\u0002!\t\u0001\u0019\u0005\u0006e\u0002!\ta\u001d\u0005\b\u00037\u0001A\u0011AA\u000f\u0011\u001d\tY\u0003\u0001C\u0005\u0003[Aq!a\u0013\u0001\t\u0013\ti\u0005C\u0004\u0002\f\u0002!\t%!$\t\u000f\u0005\u0015\b\u0001\"\u0003\u0002h\"9\u0011Q \u0001\u0005\n\u0005}\bb\u0002B\u0005\u0001\u0011%!1\u0002\u0005\b\u0005\u001f\u0001A\u0011\tB\t\u0005a\u0011E.Y2l_V$H+Y:l\u000bZ,g\u000e\u001e%b]\u0012dWM\u001d\u0006\u0003/a\t\u0001B\u00197bG.|W\u000f\u001e\u0006\u00033i\tqa]3sm&\u001cWM\u0003\u0002\u001c9\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003;y\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003}\t1aY8n\u0007\u0001\u0019B\u0001\u0001\u0012)aA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t1\u0011I\\=SK\u001a\u0004\"!\u000b\u0018\u000e\u0003)R!a\u000b\u0017\u0002\u0013\u0015DH/\u001a8tS>t'BA\u0017\u001b\u0003\u0019\t7\r^8sg&\u0011qF\u000b\u0002\u001d\u0003\u000e$xN]#yi\u0016t7/[8o\u0011\u0006tG\r\\3s\r\u0006\u001cGo\u001c:z!\t\td'D\u00013\u0015\t\u0019D'A\u0003tY\u001a$$NC\u00016\u0003!9'/\u001b>{Y\u0016$\u0017BA\u001c3\u0005\u001daunZ4j]\u001e\f\u0011#Y2u_J\u001c\u0016p\u001d;f[\"{G\u000eZ3s+\u0005Q\u0004CA\u001e=\u001b\u0005a\u0013BA\u001f-\u0005E\t5\r^8s'f\u001cH/Z7I_2$WM]\u0001\u0013C\u000e$xN]*zgR,W\u000eS8mI\u0016\u0014\b%\u0001\u0005fm\u0016tGOQ;t+\u0005\t\u0005C\u0001\"F\u001b\u0005\u0019%B\u0001#\u001b\u0003\u0019)g/\u001a8ug&\u0011ai\u0011\u0002\t\u000bZ,g\u000e\u001e\"vg\u0006IQM^3oi\n+8\u000fI\u0001\u0014e\u0016dW-Y:f\u0003\u000e$xN]*feZL7-Z\u000b\u0002\u0015B\u00111hS\u0005\u0003\u00192\u00121CU3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016\fAC]3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016\u0004\u0013A\u0004;bg.\u0014V\r]8tSR|'/_\u000b\u0002!B\u0011\u0011\u000bV\u0007\u0002%*\u00111KG\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA+S\u00059!\u0016m]6SKB|7/\u001b;pef\fq\u0002^1tWJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000be[F,\u00180\u0011\u0005i\u0003Q\"\u0001\f\t\u000baJ\u0001\u0019\u0001\u001e\t\u000b}J\u0001\u0019A!\t\u000b!K\u0001\u0019\u0001&\t\u000b9K\u0001\u0019\u0001)\u0002\u0011I,w-[:uKJ$\u0012!\u0019\t\u0003G\tL!a\u0019\u0013\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0015\u0015\u0004\"AZ6\u000e\u0003\u001dT!\u0001[5\u0002\u0015\u0005tgn\u001c;bi&|gNC\u0001k\u0003\u001dQ\u0017m[1si\u0006L!\u0001\\4\u0003\u001bA{7\u000f^\"p]N$(/^2u\u0003))hN]3hSN$XM\u001d\u0015\u0003\u0017=\u0004\"A\u001a9\n\u0005E<'A\u0003)sK\u0012+7\u000f\u001e:ps\u0006\trN\u001c\"mC\u000e\\w.\u001e;Va\u0012\fG/\u001a3\u0015\u0005\u0005$\b\"B;\r\u0001\u00041\u0018!B3wK:$\bCA<|\u001b\u0005A(B\u0001#z\u0015\tQ($\u0001\u0004e_6\f\u0017N\\\u0005\u0003yb\u0014AC\u00117bG.|W\u000f^+qI\u0006$X\rZ#wK:$\bF\u0001\u0007\u007f!\t\u0011u0C\u0002\u0002\u0002\r\u0013\u0011bU;cg\u000e\u0014\u0018NY3)\u00071\t)\u0001\u0005\u0003\u0002\b\u0005]QBAA\u0005\u0015\rA\u00171\u0002\u0006\u0005\u0003\u001b\ty!\u0001\u0003d_J,'\u0002BA\t\u0003'\t!\"\\5de>lW\r^3s\u0015\t\t)\"\u0001\u0002j_&!\u0011\u0011DA\u0005\u0005\u0015!\u0016.\\3e\u0003EygN\u00117bG.|W\u000f\u001e#fY\u0016$X\r\u001a\u000b\u0004C\u0006}\u0001BB;\u000e\u0001\u0004\t\t\u0003E\u0002x\u0003GI1!!\ny\u0005Q\u0011E.Y2l_V$H)\u001a7fi\u0016$WI^3oi\"\u0012QB \u0015\u0004\u001b\u0005\u0015\u0011\u0001E5t\u0003\u001a4Wm\u0019;j]\u001e$\u0016m]6t)\u0019\ty#!\u000e\u00028A\u00191%!\r\n\u0007\u0005MBEA\u0004C_>dW-\u00198\t\u000bUt\u0001\u0019\u0001<\t\u000f\u0005eb\u00021\u0001\u0002<\u0005\u0019an\\<\u0011\t\u0005u\u0012qI\u0007\u0003\u0003\u007fQA!!\u0011\u0002D\u0005!Q\u000f^5m\u0015\t\t)%\u0001\u0003kCZ\f\u0017\u0002BA%\u0003\u007f\u0011A\u0001R1uK\u0006\u00112o\u00195fIVdW\rV1tWV\u0003H-\u0019;f)\u0015\t\u0017qJA5\u0011\u001d\t\tf\u0004a\u0001\u0003'\na\u0001^1tW&#\u0007\u0003BA+\u0003GrA!a\u0016\u0002`A\u0019\u0011\u0011\f\u0013\u000e\u0005\u0005m#bAA/A\u00051AH]8pizJ1!!\u0019%\u0003\u0019\u0001&/\u001a3fM&!\u0011QMA4\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\r\u0013\t\u000f\u0005-t\u00021\u0001\u0002n\u000591m\\7nC:$\u0007\u0003BA8\u0003\u000bsA!!\u001d\u0002\u0002:!\u00111OA@\u001d\u0011\t)(! \u000f\t\u0005]\u00141\u0010\b\u0005\u00033\nI(C\u0001 \u0013\tib$\u0003\u0002\u001c9%\u0011QFG\u0005\u0004\u0003\u0007c\u0013!\b*fY\u0016\f7/Z#yK\u000e,H/[8o\u0003\u000e$xN]'fgN\fw-Z:\n\t\u0005\u001d\u0015\u0011\u0012\u0002\u0011\u000bb$XM\\:j_:\u001cu.\\7b]\u0012T1!a!-\u0003)9W\r\u001e%b]\u0012dWM\u001d\u000b\t\u0003\u001f\u000bi,!3\u0002TB!\u0011\u0011SA\\\u001d\u0011\t\u0019*!-\u000f\t\u0005U\u00151\u0016\b\u0005\u0003/\u000b)K\u0004\u0003\u0002\u001a\u0006}e\u0002BA-\u00037K!!!(\u0002\u0007=\u0014x-\u0003\u0003\u0002\"\u0006\r\u0016AB1qC\u000eDWM\u0003\u0002\u0002\u001e&!\u0011qUAU\u0003\u0015\u0001Xm[6p\u0015\u0011\t\t+a)\n\t\u00055\u0016qV\u0001\u0006C\u000e$xN\u001d\u0006\u0005\u0003O\u000bI+\u0003\u0003\u00024\u0006U\u0016!B!di>\u0014(\u0002BAW\u0003_KA!!/\u0002<\n9!+Z2fSZ,'\u0002BAZ\u0003kCq!a0\u0011\u0001\u0004\t\t-\u0001\u0003tK24\u0007\u0003BAb\u0003\u000bl!!!.\n\t\u0005\u001d\u0017Q\u0017\u0002\t\u0003\u000e$xN\u001d*fM\"9\u00111\u001a\tA\u0002\u00055\u0017AB:f]\u0012,'\u000fE\u0003$\u0003\u001f\f\t-C\u0002\u0002R\u0012\u0012\u0011BR;oGRLwN\u001c\u0019\t\u0011\u0005U\u0007\u0003\"a\u0001\u0003/\fqA]3mK\u0006\u001cX\rE\u0003$\u00033\fi.C\u0002\u0002\\\u0012\u0012\u0001\u0002\u00102z]\u0006lWM\u0010\t\u0005\u0003?\f\t/D\u0001z\u0013\r\t\u0019/\u001f\u0002\b%\u0016dW-Y:f\u00039)\b\u000fZ1uKR\u000b7o[,ji\"$B!!;\u0002|R\u0019\u0011-a;\t\u000f\u00055\u0018\u00031\u0001\u0002p\u00069Q\u000f\u001d3bi\u0016\u0014\bCB\u0012\u0002r\u0006U\u0018-C\u0002\u0002t\u0012\u0012\u0011BR;oGRLwN\\\u0019\u0011\t\u0005}\u0017q_\u0005\u0004\u0003sL(\u0001\u0002+bg.Dq!!\u0015\u0012\u0001\u0004\t\u0019&\u0001\rva\u0012\fG/Z*dQ\u0016$W\u000f\\3e'R\f'\u000f\u001e#bi\u0016$R!\u0019B\u0001\u0005\u000bAqAa\u0001\u0013\u0001\u0004\t)0\u0001\u0003uCN\\\u0007b\u0002B\u0004%\u0001\u0007\u00111H\u0001\u0016]\u0016<8k\u00195fIVdW\rZ*uCJ$H)\u0019;f\u0003]\u0011Xm]3u'\u000eDW\rZ;mK\u0012\u001cF/\u0019:u\t\u0006$X\rF\u0002b\u0005\u001bAqAa\u0001\u0014\u0001\u0004\t)0\u0001\u0005tkB\u0004xN\u001d;t)\u0011\tyCa\u0005\t\u000f\tUA\u00031\u0001\u0003\u0018\u0005)1\r\\1{uB\"!\u0011\u0004B\u0012!\u0019\t)Fa\u0007\u0003 %!!QDA4\u0005\u0015\u0019E.Y:t!\u0011\u0011\tCa\t\r\u0001\u0011a!Q\u0005B\n\u0003\u0003\u0005\tQ!\u0001\u0003(\t\u0019q\fJ\u0019\u0012\t\t%\"q\u0006\t\u0004G\t-\u0012b\u0001B\u0017I\t9aj\u001c;iS:<\u0007\u0003BAb\u0005cIAAa\r\u00026\n)\u0011i\u0019;pe\"\u001a\u0001Aa\u000e\u0011\t\te\"1I\u0007\u0003\u0005wQAA!\u0010\u0003@\u0005Q1\u000f^3sK>$\u0018\u0010]3\u000b\t\t\u0005\u00131U\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW&!!Q\tB\u001e\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class BlackoutTaskEventHandler
implements ActorExtensionHandlerFactory,
Logging {
    private final ActorSystemHolder actorSystemHolder;
    private final EventBus eventBus;
    private final ReleaseActorService releaseActorService;
    private final TaskRepository taskRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public ActorSystem actorSystem() {
        return ActorExtensionHandlerFactory.actorSystem$(this);
    }

    @Override
    public <T> void replyOrFail(Function0<ActorRef> sender, Function0<T> call) {
        ActorExtensionHandlerFactory.replyOrFail$(this, sender, call);
    }

    @Override
    public Throwable translate(Throwable ex) {
        return ExceptionTranslate.translate$(this, ex);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        BlackoutTaskEventHandler blackoutTaskEventHandler = this;
        synchronized (blackoutTaskEventHandler) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ActorSystemHolder actorSystemHolder() {
        return this.actorSystemHolder;
    }

    public EventBus eventBus() {
        return this.eventBus;
    }

    public ReleaseActorService releaseActorService() {
        return this.releaseActorService;
    }

    public TaskRepository taskRepository() {
        return this.taskRepository;
    }

    @PostConstruct
    public void register() {
        this.eventBus().register((Object)this);
        this.logger().debug((Function0 & Serializable)() -> "Blackout task event handler registered in event bus.");
    }

    @PreDestroy
    public void unregister() {
        this.eventBus().deregister((Object)this);
        this.logger().debug((Function0 & Serializable)() -> "Blackout task event handler de-registered from event bus.");
    }

    @Subscribe
    @Timed
    public void onBlackoutUpdated(BlackoutUpdatedEvent event) {
        Date now = new Date();
        if (this.isAffectingTasks(event, now)) {
            Buffer taskIds = CollectionConverters$.MODULE$.ListHasAsScala(this.taskRepository().findAffectedByBlackout(event.original())).asScala();
            this.logger().debug((Function0 & Serializable)() -> taskIds.length() + " taskIds to be updated after blackout " + event.original().getLabel() + " update.");
            BlackoutMetadata metadata = BlackoutMetadata$.MODULE$.apply((Seq)new .colon.colon((Object)new BlackoutPeriod(event.updated().getStartDate(), event.updated().getEndDate()), (List)Nil$.MODULE$));
            boolean isInBlackout = metadata.isInBlackout(now);
            Date newScheduledStartDate = metadata.getEndOfBlackout(now);
            taskIds.foreach((Function1 & Serializable)taskId -> {
                this.scheduleTaskUpdate(taskId, isInBlackout ? new BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate(taskId, newScheduledStartDate) : new BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate(taskId));
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Subscribe
    @Timed
    public void onBlackoutDeleted(BlackoutDeletedEvent event) {
        Buffer taskIds = CollectionConverters$.MODULE$.ListHasAsScala(this.taskRepository().findAffectedByBlackout(event.blackout())).asScala();
        this.logger().debug((Function0 & Serializable)() -> taskIds.length() + " taskIds to be started after blackout " + event.blackout().getLabel() + " removal.");
        taskIds.foreach((Function1 & Serializable)taskId -> {
            this.scheduleTaskUpdate(taskId, new BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate(taskId));
            return BoxedUnit.UNIT;
        });
    }

    private boolean isAffectingTasks(BlackoutUpdatedEvent event, Date now) {
        Date date = event.original().getEndDate();
        Date date2 = event.updated().getEndDate();
        boolean endDateChanged = date == null ? date2 != null : !((Object)date).equals(date2);
        boolean startDateMovedIntoFuture = now.after(event.original().getStartDate()) && now.before(event.updated().getStartDate());
        return endDateChanged || startDateMovedIntoFuture;
    }

    private void scheduleTaskUpdate(String taskId, ReleaseExecutionActorMessages.ExtensionCommand command) {
        this.releaseActorService().executeCommandAsync(taskId, command);
    }

    @Override
    public PartialFunction<Object, BoxedUnit> getHandler(ActorRef self, Function0<ActorRef> sender, Function0<Release> release) {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ BlackoutTaskEventHandler $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate) {
                    BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate updateScheduledStartDate = (BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate)A1;
                    String taskId = updateScheduledStartDate.taskId();
                    Date newScheduledStartDate = updateScheduledStartDate.newScheduledStartDate();
                    this.$outer.com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateTaskWith(taskId, (Function1<Task, BoxedUnit>)(Function1 & Serializable)x$1 -> {
                        $anonfun$getHandler$1.$anonfun$applyOrElse$1(this, newScheduledStartDate, x$1);
                        return BoxedUnit.UNIT;
                    });
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate) {
                    BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate resetScheduledStartDate = (BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate)A1;
                    String taskId = resetScheduledStartDate.taskId();
                    this.$outer.com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateTaskWith(taskId, (Function1<Task, BoxedUnit>)(Function1 & Serializable)task -> {
                        $anonfun$getHandler$1.$anonfun$applyOrElse$2(this, task);
                        return BoxedUnit.UNIT;
                    });
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                if (object instanceof BlackoutReleaseExecutionActorMessages.UpdateScheduledStartDate) {
                    return true;
                }
                return object instanceof BlackoutReleaseExecutionActorMessages.ResetScheduledStartDate;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$1($anonfun$getHandler$1 $this, Date newScheduledStartDate$2, Task x$1) {
                $this.$outer.com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateScheduledStartDate(x$1, newScheduledStartDate$2);
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$2($anonfun$getHandler$1 $this, Task task) {
                $this.$outer.com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$resetScheduledStartDate(task);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(com.xebialabs.xlrelease.service.blackout.BlackoutTaskEventHandler$$anonfun$getHandler$1 java.util.Date com.xebialabs.xlrelease.domain.Task ), $anonfun$applyOrElse$2$adapted(com.xebialabs.xlrelease.service.blackout.BlackoutTaskEventHandler$$anonfun$getHandler$1 com.xebialabs.xlrelease.domain.Task )}, serializedLambda);
            }
        };
    }

    public void com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateTaskWith(String taskId, Function1<Task, BoxedUnit> updater) {
        Object task = this.taskRepository().findById(taskId);
        Task original = (Task)CiCloneHelper.cloneCi(task);
        updater.apply(task);
        this.taskRepository().update((Task)task);
        this.eventBus().publish((XLReleaseEvent)new TaskUpdatedEvent(original, task));
    }

    public void com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$updateScheduledStartDate(Task task, Date newScheduledStartDate) {
        this.logger().debug((Function0 & Serializable)() -> "Updating task '" + task.getId() + "' scheduled start date due to new blackout end date '" + newScheduledStartDate + "'");
        Date originalScheduledStartDate = task.getOriginalScheduledStartDate();
        task.setScheduledStartDate(newScheduledStartDate);
        task.setPostponedDueToBlackout(true);
        task.setOriginalScheduledStartDate(originalScheduledStartDate);
    }

    public void com$xebialabs$xlrelease$service$blackout$BlackoutTaskEventHandler$$resetScheduledStartDate(Task task) {
        this.logger().debug((Function0 & Serializable)() -> "Resetting task '" + task.getId() + "' scheduled start date due to blackout not being applicable anymore.");
        task.setScheduledStartDate(task.getOriginalScheduledStartDate());
        task.setPostponedDueToBlackout(false);
    }

    @Override
    public boolean supports(Class<? extends Actor> clazz) {
        return ReleaseExecutionActor.class.isAssignableFrom(clazz);
    }

    public BlackoutTaskEventHandler(ActorSystemHolder actorSystemHolder, EventBus eventBus, ReleaseActorService releaseActorService, TaskRepository taskRepository) {
        this.actorSystemHolder = actorSystemHolder;
        this.eventBus = eventBus;
        this.releaseActorService = releaseActorService;
        this.taskRepository = taskRepository;
        ExceptionTranslate.$init$(this);
        ActorExtensionHandlerFactory.$init$(this);
        Logging.$init$((Logging)this);
    }
}

