/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security.authentication;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plumbing.authentication.InternalUser;
import com.xebialabs.deployit.security.User;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.authentication.AuthenticationFailureException;
import com.xebialabs.deployit.security.authentication.PersonalAuthenticationToken;
import com.xebialabs.xlrelease.domain.UserToken;
import com.xebialabs.xlrelease.features.PersonalAccessTokenFeature;
import com.xebialabs.xlrelease.principaldata.PrincipalDataProvider;
import com.xebialabs.xlrelease.principaldata.UserData;
import com.xebialabs.xlrelease.security.UserGroupService;
import com.xebialabs.xlrelease.security.authentication.OwnerAuthenticationToken;
import com.xebialabs.xlrelease.security.authentication.TokenExpiredException;
import com.xebialabs.xlrelease.service.UserLastActiveActorService;
import com.xebialabs.xlrelease.service.UserTokenService;
import com.xebialabs.xlrelease.service.accountlock.AccountLockProtectionService;
import com.xebialabs.xlrelease.support.pekko.spring.ScalaSpringAwareBean;
import com.xebialabs.xlrelease.support.pekko.spring.ScalaSpringSupport;
import com.xebialabs.xlrelease.utils.DateVariableUtils;
import com.xebialabs.xlrelease.utils.TokenGenerator$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.slf4j.Marker;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.NullAuthoritiesMapper;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component(value="xlAuthenticationProvider")
@ScalaSignature(bytes="\u0006\u0005\t=a\u0001\u0002\u000b\u0016\u0001\u0001BQ!\u0012\u0001\u0005\u0002\u0019C\u0001\"\u0013\u0001\t\u0006\u0004%IA\u0013\u0005\t%\u0002A)\u0019!C\u0005'\"A!\f\u0001EC\u0002\u0013%1\f\u0003\u0005`\u0001!\u0015\r\u0011\"\u0003a\u0011!)\u0007\u0001#b\u0001\n\u00131\u0007\u0002C7\u0001\u0011\u000b\u0007I\u0011\u00028\t\u0011U\u0004\u0001R1A\u0005\nYDq! \u0001A\u0002\u0013%a\u0010C\u0005\u0002\u0014\u0001\u0001\r\u0011\"\u0003\u0002\u0016!9\u0011q\u0005\u0001!B\u0013y\bbBA\u0015\u0001\u0011\u0005\u00131\u0006\u0005\b\u0003'\u0003A\u0011BAK\u0011\u001d\tI\n\u0001C\u0005\u00037Cq!!*\u0001\t\u0013\t9\u000bC\u0004\u0002.\u0002!I!a,\t\u000f\u0005E\u0007\u0001\"\u0011\u0002T\"1\u00111\u001f\u0001\u0005\u0002yDq!!>\u0001\t\u0003\t9PA\u000fSK2,\u0017m]3BkRDWM\u001c;jG\u0006$\u0018n\u001c8Qe>4\u0018\u000eZ3s\u0015\t1r#\u0001\bbkRDWM\u001c;jG\u0006$\u0018n\u001c8\u000b\u0005aI\u0012\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005iY\u0012!\u0003=me\u0016dW-Y:f\u0015\taR$A\u0005yK\nL\u0017\r\\1cg*\ta$A\u0002d_6\u001c\u0001aE\u0003\u0001C%\u001aT\b\u0005\u0002#O5\t1E\u0003\u0002%K\u0005!A.\u00198h\u0015\u00051\u0013\u0001\u00026bm\u0006L!\u0001K\u0012\u0003\r=\u0013'.Z2u!\tQ\u0013'D\u0001,\u0015\t1BF\u0003\u0002\u0019[)\u0011afL\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0001'A\u0002pe\u001eL!AM\u0016\u0003-\u0005+H\u000f[3oi&\u001c\u0017\r^5p]B\u0013xN^5eKJ\u0004\"\u0001N\u001e\u000e\u0003UR!AN\u001c\u0002\rM\u0004(/\u001b8h\u0015\tA\u0014(A\u0003qK.\\wN\u0003\u0002;3\u000591/\u001e9q_J$\u0018B\u0001\u001f6\u0005Q\u00196-\u00197b'B\u0014\u0018N\\4Bo\u0006\u0014XMQ3b]B\u0011ahQ\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u0006g24GG\u001b\u0006\u0002\u0005\u0006AqM]5{u2,G-\u0003\u0002E\u007f\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001H!\tA\u0005!D\u0001\u0016\u0003-)8/\u001a:TKJ4\u0018nY3\u0016\u0003-\u0003\"\u0001\u0014)\u000e\u00035S!\u0001\u0007(\u000b\u0005=[\u0012\u0001\u00033fa2|\u00170\u001b;\n\u0005Ek%aC+tKJ\u001cVM\u001d<jG\u0016\f\u0001#^:feR{7.\u001a8TKJ4\u0018nY3\u0016\u0003Q\u0003\"!\u0016-\u000e\u0003YS!aV\r\u0002\u000fM,'O^5dK&\u0011\u0011L\u0016\u0002\u0011+N,'\u000fV8lK:\u001cVM\u001d<jG\u0016\f!$^:fe2\u000b7\u000f^!di&4X-Q2u_J\u001cVM\u001d<jG\u0016,\u0012\u0001\u0018\t\u0003+vK!A\u0018,\u00035U\u001bXM\u001d'bgR\f5\r^5wK\u0006\u001bGo\u001c:TKJ4\u0018nY3\u0002!U\u001cXM]$s_V\u00048+\u001a:wS\u000e,W#A1\u0011\u0005\t\u001cW\"A\f\n\u0005\u0011<\"\u0001E+tKJ<%o\\;q'\u0016\u0014h/[2f\u0003U\u0001(/\u001b8dSB\fG\u000eR1uCB\u0013xN^5eKJ,\u0012a\u001a\t\u0003Q.l\u0011!\u001b\u0006\u0003Uf\tQ\u0002\u001d:j]\u000eL\u0007/\u00197eCR\f\u0017B\u00017j\u0005U\u0001&/\u001b8dSB\fG\u000eR1uCB\u0013xN^5eKJ\f!\u0004]3sg>t\u0017\r\\!dG\u0016\u001c8\u000fV8lK:4U-\u0019;ve\u0016,\u0012a\u001c\t\u0003aNl\u0011!\u001d\u0006\u0003ef\t\u0001BZ3biV\u0014Xm]\u0005\u0003iF\u0014!\u0004U3sg>t\u0017\r\\!dG\u0016\u001c8\u000fV8lK:4U-\u0019;ve\u0016\fA$Y2d_VtG\u000fT8dWB\u0013x\u000e^3di&|gnU3sm&\u001cW-F\u0001x!\tA80D\u0001z\u0015\tQh+A\u0006bG\u000e|WO\u001c;m_\u000e\\\u0017B\u0001?z\u0005q\t5mY8v]RdunY6Qe>$Xm\u0019;j_:\u001cVM\u001d<jG\u0016\f\u0011#Y;uQ>\u0014\u0018\u000e^5fg6\u000b\u0007\u000f]3s+\u0005y\b\u0003BA\u0001\u0003\u001fi!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\b[\u0006\u0004\b/\u001b8h\u0015\u0011\tI!a\u0003\u0002\u0013\u0005,H\u000f[8sSRL(bAA\u0007Y\u0005!1m\u001c:f\u0013\u0011\t\t\"a\u0001\u00031\u001d\u0013\u0018M\u001c;fI\u0006+H\u000f[8sSRLWm]'baB,'/A\u000bbkRDwN]5uS\u0016\u001cX*\u00199qKJ|F%Z9\u0015\t\u0005]\u00111\u0005\t\u0005\u00033\ty\"\u0004\u0002\u0002\u001c)\u0011\u0011QD\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003C\tYB\u0001\u0003V]&$\b\u0002CA\u0013\u0015\u0005\u0005\t\u0019A@\u0002\u0007a$\u0013'\u0001\nbkRDwN]5uS\u0016\u001cX*\u00199qKJ\u0004\u0013\u0001D1vi\",g\u000e^5dCR,G\u0003BA\u0017\u0003k\u0001B!a\f\u000225\u0011\u00111B\u0005\u0005\u0003g\tYA\u0001\bBkRDWM\u001c;jG\u0006$\u0018n\u001c8\t\u000f\u0005]B\u00021\u0001\u0002.\u0005)Ao\\6f]\"*A\"a\u000f\u0002HA1\u0011\u0011DA\u001f\u0003\u0003JA!a\u0010\u0002\u001c\t1A\u000f\u001b:poN\u0004B!a\f\u0002D%!\u0011QIA\u0006\u0005]\tU\u000f\u001e5f]RL7-\u0019;j_:,\u0005pY3qi&|g.M\u0004\u001f\u0003\u0013\ny&!%\u0011\t\u0005-\u0013\u0011\f\b\u0005\u0003\u001b\n)\u0006\u0005\u0003\u0002P\u0005mQBAA)\u0015\r\t\u0019fH\u0001\u0007yI|w\u000e\u001e \n\t\u0005]\u00131D\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0013Q\f\u0002\u0007'R\u0014\u0018N\\4\u000b\t\u0005]\u00131D\u0019\nG\u0005\u0005\u0014\u0011NAD\u0003W*B!a\u0019\u0002fU\u0011\u0011\u0011\n\u0003\b\u0003Oz\"\u0019AA9\u0005\u0005!\u0016\u0002BA6\u0003[\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n$\u0002BA8\u00037\ta\u0001\u001e5s_^\u001c\u0018\u0003BA:\u0003s\u0002B!!\u0007\u0002v%!\u0011qOA\u000e\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!a\u001f\u0002\u0002:!\u0011\u0011DA?\u0013\u0011\ty(a\u0007\u0002\u000fA\f7m[1hK&!\u00111QAC\u0005%!\u0006N]8xC\ndWM\u0003\u0003\u0002\u0000\u0005m\u0011'C\u0012\u0002\n\u0006-\u0015QRA8\u001d\u0011\tI\"a#\n\t\u0005=\u00141D\u0019\bE\u0005e\u00111DAH\u0005\u0015\u00198-\u00197bc\r1\u0013\u0011I\u0001\u001aCV$\b.\u001a8uS\u000e\fG/\u001a$s_6,6/\u001a:U_.,g\u000e\u0006\u0003\u0002.\u0005]\u0005bBA\u001c\u001b\u0001\u0007\u0011\u0011J\u0001\u001cCV$\b.\u001a8uS\u000e\fG/\u001a$s_6\u001c%/\u001a3f]RL\u0017\r\\:\u0015\r\u00055\u0012QTAQ\u0011\u001d\tyJ\u0004a\u0001\u0003\u0013\n\u0001\"^:fe:\fW.\u001a\u0005\b\u0003Gs\u0001\u0019AA%\u0003!\u0001\u0018m]:x_J$\u0017\u0001H1vi\",g\u000e^5dCR,gI]8n%\u0016dW-Y:f\u001f^tWM\u001d\u000b\u0005\u0003[\tI\u000bC\u0004\u0002,>\u0001\r!!\u0013\u0002\u000b=<h.\u001a:\u0002'\u00154\u0018\r\\;bi\u0016\fU\u000f\u001e5pe&$\u0018.Z:\u0015\t\u0005E\u0016q\u001a\u0019\u0005\u0003g\u000b\u0019\r\u0005\u0004\u00026\u0006m\u0016qX\u0007\u0003\u0003oS1!!/&\u0003\u0011)H/\u001b7\n\t\u0005u\u0016q\u0017\u0002\u000b\u0007>dG.Z2uS>t\u0007\u0003BAa\u0003\u0007d\u0001\u0001B\u0006\u0002FB\t\t\u0011!A\u0003\u0002\u0005\u001d'aA0%iE!\u00111OAe!\u0011\ty#a3\n\t\u00055\u00171\u0002\u0002\u0011\u000fJ\fg\u000e^3e\u0003V$\bn\u001c:jifDq!a(\u0011\u0001\u0004\tI%\u0001\u0005tkB\u0004xN\u001d;t)\u0011\t).a7\u0011\t\u0005e\u0011q[\u0005\u0005\u00033\fYBA\u0004C_>dW-\u00198\t\rY\t\u0002\u0019AAoa\u0011\ty.a:\u0011\r\u0005-\u0013\u0011]As\u0013\u0011\t\u0019/!\u0018\u0003\u000b\rc\u0017m]:\u0011\t\u0005\u0005\u0017q\u001d\u0003\r\u0003S\fY.!A\u0001\u0002\u000b\u0005\u00111\u001e\u0002\u0004?\u0012*\u0014\u0003BA:\u0003[\u0004B!!\u0007\u0002p&!\u0011\u0011_A\u000e\u0005\r\te._\u0001\u0015O\u0016$\u0018)\u001e;i_JLG/[3t\u001b\u0006\u0004\b/\u001a:\u0002)M,G/Q;uQ>\u0014\u0018\u000e^5fg6\u000b\u0007\u000f]3s)\u0011\t9\"!?\t\u000bu\u001c\u0002\u0019A@)\u000f\u0001\tiP!\u0003\u0003\fA!\u0011q B\u0003\u001b\t\u0011\tAC\u0002\u0003\u00045\n!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\u00119A!\u0001\u0003\u0013\r{W\u000e]8oK:$\u0018!\u0002<bYV,\u0017E\u0001B\u0007\u0003aAH.Q;uQ\u0016tG/[2bi&|g\u000e\u0015:pm&$WM\u001d")
public class ReleaseAuthenticationProvider
implements AuthenticationProvider,
ScalaSpringAwareBean,
Logging {
    private UserService userService;
    private UserTokenService userTokenService;
    private UserLastActiveActorService userLastActiveActorService;
    private UserGroupService userGroupService;
    private PrincipalDataProvider principalDataProvider;
    private PersonalAccessTokenFeature personalAccessTokenFeature;
    private AccountLockProtectionService accountLockProtectionService;
    private GrantedAuthoritiesMapper authoritiesMapper;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private transient ApplicationContext applicationContext;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public ApplicationContext getApplicationContext() {
        return ScalaSpringAwareBean.getApplicationContext$((ScalaSpringAwareBean)this);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ScalaSpringAwareBean.setApplicationContext$((ScalaSpringAwareBean)this, (ApplicationContext)applicationContext);
    }

    public <T> T springBean(ClassTag<T> evidence$1) {
        return (T)ScalaSpringSupport.springBean$((ScalaSpringSupport)this, evidence$1);
    }

    public <T> T springBean(String name, ClassTag<T> evidence$2) {
        return (T)ScalaSpringSupport.springBean$((ScalaSpringSupport)this, (String)name, evidence$2);
    }

    public <T> Map<String, T> springBeans(ClassTag<T> evidence$3) {
        return ScalaSpringSupport.springBeans$((ScalaSpringSupport)this, evidence$3);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReleaseAuthenticationProvider releaseAuthenticationProvider = this;
        synchronized (releaseAuthenticationProvider) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public ApplicationContext applicationContext() {
        return this.applicationContext;
    }

    public void applicationContext_$eq(ApplicationContext x$1) {
        this.applicationContext = x$1;
    }

    private UserService userService$lzycompute() {
        ReleaseAuthenticationProvider releaseAuthenticationProvider = this;
        synchronized (releaseAuthenticationProvider) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.userService = (UserService)this.springBean(ClassTag$.MODULE$.apply(UserService.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.userService;
    }

    private UserService userService() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.userService$lzycompute();
        }
        return this.userService;
    }

    private UserTokenService userTokenService$lzycompute() {
        ReleaseAuthenticationProvider releaseAuthenticationProvider = this;
        synchronized (releaseAuthenticationProvider) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.userTokenService = (UserTokenService)this.springBean(ClassTag$.MODULE$.apply(UserTokenService.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.userTokenService;
    }

    private UserTokenService userTokenService() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.userTokenService$lzycompute();
        }
        return this.userTokenService;
    }

    private UserLastActiveActorService userLastActiveActorService$lzycompute() {
        ReleaseAuthenticationProvider releaseAuthenticationProvider = this;
        synchronized (releaseAuthenticationProvider) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.userLastActiveActorService = (UserLastActiveActorService)this.springBean(ClassTag$.MODULE$.apply(UserLastActiveActorService.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.userLastActiveActorService;
    }

    private UserLastActiveActorService userLastActiveActorService() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.userLastActiveActorService$lzycompute();
        }
        return this.userLastActiveActorService;
    }

    private UserGroupService userGroupService$lzycompute() {
        ReleaseAuthenticationProvider releaseAuthenticationProvider = this;
        synchronized (releaseAuthenticationProvider) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.userGroupService = (UserGroupService)this.springBean(ClassTag$.MODULE$.apply(UserGroupService.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.userGroupService;
    }

    private UserGroupService userGroupService() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.userGroupService$lzycompute();
        }
        return this.userGroupService;
    }

    private PrincipalDataProvider principalDataProvider$lzycompute() {
        ReleaseAuthenticationProvider releaseAuthenticationProvider = this;
        synchronized (releaseAuthenticationProvider) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.principalDataProvider = (PrincipalDataProvider)this.springBean(ClassTag$.MODULE$.apply(PrincipalDataProvider.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.principalDataProvider;
    }

    private PrincipalDataProvider principalDataProvider() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.principalDataProvider$lzycompute();
        }
        return this.principalDataProvider;
    }

    private PersonalAccessTokenFeature personalAccessTokenFeature$lzycompute() {
        ReleaseAuthenticationProvider releaseAuthenticationProvider = this;
        synchronized (releaseAuthenticationProvider) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.personalAccessTokenFeature = (PersonalAccessTokenFeature)this.springBean(ClassTag$.MODULE$.apply(PersonalAccessTokenFeature.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.personalAccessTokenFeature;
    }

    private PersonalAccessTokenFeature personalAccessTokenFeature() {
        if ((byte)(this.bitmap$0 & 0x20) == 0) {
            return this.personalAccessTokenFeature$lzycompute();
        }
        return this.personalAccessTokenFeature;
    }

    private AccountLockProtectionService accountLockProtectionService$lzycompute() {
        ReleaseAuthenticationProvider releaseAuthenticationProvider = this;
        synchronized (releaseAuthenticationProvider) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                this.accountLockProtectionService = (AccountLockProtectionService)this.springBean(ClassTag$.MODULE$.apply(AccountLockProtectionService.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
        }
        return this.accountLockProtectionService;
    }

    private AccountLockProtectionService accountLockProtectionService() {
        if ((byte)(this.bitmap$0 & 0x40) == 0) {
            return this.accountLockProtectionService$lzycompute();
        }
        return this.accountLockProtectionService;
    }

    private GrantedAuthoritiesMapper authoritiesMapper() {
        return this.authoritiesMapper;
    }

    private void authoritiesMapper_$eq(GrantedAuthoritiesMapper x$1) {
        this.authoritiesMapper = x$1;
    }

    public Authentication authenticate(Authentication token) throws AuthenticationException {
        Authentication authentication;
        this.logger().debug((Function0 & Serializable)() -> "Authenticating for Digital.ai Release");
        try {
            Authentication authentication2 = token;
            authentication = authentication2 instanceof PersonalAuthenticationToken ? this.authenticateFromUserToken(token.getCredentials().toString()) : (authentication2 instanceof OwnerAuthenticationToken ? this.authenticateFromReleaseOwner(token.getPrincipal().toString()) : this.authenticateFromCredentials(token.getPrincipal().toString(), token.getCredentials().toString()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof AuthenticationFailureException ? true : throwable2 instanceof NotFoundException) {
                throw new BadCredentialsException(throwable2.getMessage(), throwable2);
            }
            throw throwable;
        }
        return authentication;
    }

    private Authentication authenticateFromUserToken(String token) {
        this.logger().trace((Function0 & Serializable)() -> "Authenticating using personal access token");
        String tokenHash = TokenGenerator$.MODULE$.hash(token);
        UserToken userToken = (UserToken)this.userTokenService().findByUserToken(tokenHash).getOrElse((Function0 & Serializable)() -> {
            throw new AuthenticationFailureException("Cannot authenticate with supplied personal access token");
        });
        if (userToken.isExpired()) {
            throw new TokenExpiredException("The token expired on " + DateVariableUtils.printDate((Date)userToken.expiryDate()));
        }
        this.userLastActiveActorService().updateTokenLastUsed(userToken.ciUid());
        Collection<? extends GrantedAuthority> mappedAuthorities = this.evaluateAuthorities(userToken.username());
        return new PersonalAuthenticationToken((Object)new InternalUser(userToken.username()), token, userToken.expiryDate(), mappedAuthorities, (Set)Option$.MODULE$.apply((Object)userToken.userTokenPermission()).map((Function1 & Serializable)x$1 -> x$1.globalPermissions()).getOrElse((Function0 & Serializable)() -> Collections.emptySet()), Collections.emptySet(), Collections.emptySet());
    }

    private Authentication authenticateFromCredentials(String username, String password) {
        this.logger().trace((Function0 & Serializable)() -> "Authenticating [" + username + "]");
        if (Strings.isBlank((String)username)) {
            throw new BadCredentialsException("Cannot authenticate with empty username");
        }
        if (this.accountLockProtectionService().isAccountLocked(username)) {
            throw new LockedException("This account is locked due to too many failed login attempts.");
        }
        this.userService().authenticate(username, password);
        Collection<? extends GrantedAuthority> mappedAuthorities = this.evaluateAuthorities(username);
        return new UsernamePasswordAuthenticationToken((Object)new InternalUser(username), (Object)password, mappedAuthorities);
    }

    private Authentication authenticateFromReleaseOwner(String owner) {
        this.logger().trace((Function0 & Serializable)() -> "Authenticating release owner: [" + owner + "]");
        if (Strings.isBlank((String)owner)) {
            throw new BadCredentialsException("Cannot authenticate with empty release owner");
        }
        Collection<? extends GrantedAuthority> mappedAuthorities = this.evaluateAuthorities(owner);
        return new OwnerAuthenticationToken(new InternalUser(owner), mappedAuthorities);
    }

    private Collection<? extends GrantedAuthority> evaluateAuthorities(String username) {
        ArrayList<SimpleGrantedAuthority> arrayList;
        UserData userData = this.principalDataProvider().getUserData(username);
        if (userData.isFound()) {
            return this.authoritiesMapper().mapAuthorities(this.principalDataProvider().getAuthorities(username));
        }
        try {
            User user = this.userService().read(username);
            ArrayList<SimpleGrantedAuthority> grantedAuthorities = new ArrayList<SimpleGrantedAuthority>();
            Object object = user.isAdmin() || "admin".equals(user.getUsername()) ? BoxesRunTime.boxToBoolean((boolean)grantedAuthorities.add(new SimpleGrantedAuthority("ROLE_ADMIN"))) : BoxedUnit.UNIT;
            arrayList = grantedAuthorities;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof NotFoundException && this.personalAccessTokenFeature().enabled()) {
                scala.collection.immutable.Set<String> userGroups = this.userGroupService().findGroupsForUser(username);
                ArrayList grantedAuthorities = new ArrayList();
                userGroups.foreach((Function1 & Serializable)group -> BoxesRunTime.boxToBoolean((boolean)grantedAuthorities.add(new SimpleGrantedAuthority(group))));
                arrayList = grantedAuthorities;
            }
            throw throwable;
        }
        ArrayList<SimpleGrantedAuthority> authorities = arrayList;
        return this.authoritiesMapper().mapAuthorities(authorities);
    }

    public boolean supports(Class<?> authentication) {
        return authentication.isAssignableFrom(UsernamePasswordAuthenticationToken.class) || authentication.isAssignableFrom(PersonalAuthenticationToken.class) || authentication.isAssignableFrom(OwnerAuthenticationToken.class);
    }

    public GrantedAuthoritiesMapper getAuthoritiesMapper() {
        return this.authoritiesMapper();
    }

    public void setAuthoritiesMapper(GrantedAuthoritiesMapper authoritiesMapper) {
        this.authoritiesMapper_$eq(authoritiesMapper);
    }

    public ReleaseAuthenticationProvider() {
        ScalaSpringSupport.$init$((ScalaSpringSupport)this);
        ScalaSpringAwareBean.$init$((ScalaSpringAwareBean)this);
        Logging.$init$((Logging)this);
        this.authoritiesMapper = new NullAuthoritiesMapper();
    }
}

