/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.authentication;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plumbing.authorization.LoginAuthorizationManager;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.security.authentication.policy.UserGroupMembershipCreationPolicy;
import com.xebialabs.xlrelease.security.authentication.policy.UserProfileCreationPolicy;
import com.xebialabs.xlrelease.service.accountlock.AccountLockProtectionService;
import java.io.Serializable;
import java.util.List;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Component
@ScalaSignature(bytes="\u0006\u0005a4A!\u0003\u0006\u0001'!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u0011!\u0019\u0005A!A!\u0002\u0013!\u0005\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u000bQ\u0003A\u0011A+\t\u000bq\u0003A\u0011I/\t\u000b\u0015\u0004A\u0011\u00024\t\u000b9\u0004A\u0011B8\u0003E\u0005+H\u000f[3oi&\u001c\u0017\r^5p]N+8mY3tg\u00163XM\u001c;MSN$XM\\3s\u0015\tYA\"\u0001\bbkRDWM\u001c;jG\u0006$\u0018n\u001c8\u000b\u00055q\u0011!\u0003=me\u0016dW-Y:f\u0015\ty\u0001#A\u0005yK\nL\u0017\r\\1cg*\t\u0011#A\u0002d_6\u001c\u0001aE\u0002\u0001)q\u0001\"!\u0006\u000e\u000e\u0003YQ!a\u0006\r\u0002\t1\fgn\u001a\u0006\u00023\u0005!!.\u0019<b\u0013\tYbC\u0001\u0004PE*,7\r\u001e\t\u0004;\u00112S\"\u0001\u0010\u000b\u0005}\u0001\u0013aB2p]R,\u0007\u0010\u001e\u0006\u0003C\t\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002G\u0005\u0019qN]4\n\u0005\u0015r\"aE!qa2L7-\u0019;j_:d\u0015n\u001d;f]\u0016\u0014\bCA\u0014.\u001b\u0005A#BA\u0015+\u0003\u0015)g/\u001a8u\u0015\tY1F\u0003\u0002-A\u0005A1/Z2ve&$\u00180\u0003\u0002/Q\tQ\u0012)\u001e;iK:$\u0018nY1uS>t7+^2dKN\u001cXI^3oi\u0006YRo]3s!J|g-\u001b7f\u0007J,\u0017\r^5p]B{G.[2jKN\u00042!\r\u001b7\u001b\u0005\u0011$BA\u001a\u0019\u0003\u0011)H/\u001b7\n\u0005U\u0012$\u0001\u0002'jgR\u0004\"a\u000e\u001f\u000e\u0003aR!!\u000f\u001e\u0002\rA|G.[2z\u0015\tY1H\u0003\u0002-\u0019%\u0011Q\b\u000f\u0002\u001a+N,'\u000f\u0015:pM&dWm\u0011:fCRLwN\u001c)pY&\u001c\u00170A\u0012vg\u0016\u0014xI]8va6+WNY3sg\"L\u0007o\u0011:fCRLwN\u001c)pY&\u001c\u0017.Z:\u0011\u0007E\"\u0004\t\u0005\u00028\u0003&\u0011!\t\u000f\u0002\"+N,'o\u0012:pkBlU-\u001c2feND\u0017\u000e]\"sK\u0006$\u0018n\u001c8Q_2L7-_\u0001\u0013a\u0016\u0014X.[:tS>tWI\u001c4pe\u000e,'\u000f\u0005\u0002F\u00136\taI\u0003\u0002-\u000f*\u0011\u0001JD\u0001\tI\u0016\u0004Hn\\=ji&\u0011!J\u0012\u0002\u0013!\u0016\u0014X.[:tS>tWI\u001c4pe\u000e,'/\u0001\u000fbG\u000e|WO\u001c;M_\u000e\\\u0007K]8uK\u000e$\u0018n\u001c8TKJ4\u0018nY3\u0011\u00055\u0013V\"\u0001(\u000b\u0005=\u0003\u0016aC1dG>,h\u000e\u001e7pG.T!!\u0015\u0007\u0002\u000fM,'O^5dK&\u00111K\u0014\u0002\u001d\u0003\u000e\u001cw.\u001e8u\u0019>\u001c7\u000e\u0015:pi\u0016\u001cG/[8o'\u0016\u0014h/[2f\u0003\u0019a\u0014N\\5u}Q)a\u000bW-[7B\u0011q\u000bA\u0007\u0002\u0015!)q&\u0002a\u0001a!)a(\u0002a\u0001\u007f!)1)\u0002a\u0001\t\")1*\u0002a\u0001\u0019\u0006\u0011rN\\!qa2L7-\u0019;j_:,e/\u001a8u)\tqF\r\u0005\u0002`E6\t\u0001MC\u0001b\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0007M\u0001\u0003V]&$\b\"B\u0015\u0007\u0001\u00041\u0013\u0001\t4j]\u0012\f\u0005\u000f\u001d7jG\u0006\u0014G.Z+tKJ\u001c%/Z1uS>t\u0007k\u001c7jGf$\"AN4\t\u000b-9\u0001\u0019\u00015\u0011\u0005%dW\"\u00016\u000b\u0005-\\\u0013\u0001B2pe\u0016L!!\u001c6\u0003\u001d\u0005+H\u000f[3oi&\u001c\u0017\r^5p]\u0006)c-\u001b8e\u0003B\u0004H.[2bE2,Wk]3s\u000fJ|W\u000f]\"sK\u0006$\u0018n\u001c8Q_2L7-\u001f\u000b\u0003\u0001BDQa\u0003\u0005A\u0002!D#\u0001\u0001:\u0011\u0005M4X\"\u0001;\u000b\u0005U\u0004\u0013AC:uKJ,w\u000e^=qK&\u0011q\u000f\u001e\u0002\n\u0007>l\u0007o\u001c8f]R\u0004")
public class AuthenticationSuccessEventListener
implements ApplicationListener<AuthenticationSuccessEvent> {
    private final List<UserProfileCreationPolicy> userProfileCreationPolicies;
    private final List<UserGroupMembershipCreationPolicy> userGroupMembershipCreationPolicies;
    private final PermissionEnforcer permissionEnforcer;
    private final AccountLockProtectionService accountLockProtectionService;

    public boolean supportsAsyncExecution() {
        return super.supportsAsyncExecution();
    }

    public void onApplicationEvent(AuthenticationSuccessEvent event) {
        Authentication authentication = LoginAuthorizationManager.addAuthenticatedUserAuthority(event.getAuthentication(), null);
        if (authentication != null && Strings.isNotEmpty((String)authentication.getName())) {
            boolean hasLoginPermission = this.permissionEnforcer.hasPermission(authentication, new Permission[]{PlatformPermissions.LOGIN});
            if (!hasLoginPermission) {
                throw new DisabledException("The user " + authentication.getName() + " or its group(s) do not have login permission");
            }
            UserProfileCreationPolicy creationPolicy = this.findApplicableUserCreationPolicy(authentication);
            creationPolicy.createProfile(authentication);
            UserGroupMembershipCreationPolicy ugCreationPolicy = this.findApplicableUserGroupCreationPolicy(authentication);
            ugCreationPolicy.updateUserGroupMembership(authentication);
            this.accountLockProtectionService.resetFailedAttemptsAfterSuccessLogin(authentication.getName());
            return;
        }
    }

    private UserProfileCreationPolicy findApplicableUserCreationPolicy(Authentication authentication) {
        return (UserProfileCreationPolicy)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.userProfileCreationPolicies).asScala().sortBy((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.order()), (Ordering)Ordering.Int$.MODULE$)).find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.policyApplies(authentication))).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("No UserProfile creation policy applicable for authentication [" + authentication + "]");
        });
    }

    private UserGroupMembershipCreationPolicy findApplicableUserGroupCreationPolicy(Authentication authentication) {
        return (UserGroupMembershipCreationPolicy)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.userGroupMembershipCreationPolicies).asScala().sortBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.order()), (Ordering)Ordering.Int$.MODULE$)).find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.policyApplies(authentication))).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("No UserGroupMembership creation policy applicable for authentication [" + authentication + "]");
        });
    }

    public AuthenticationSuccessEventListener(List<UserProfileCreationPolicy> userProfileCreationPolicies, List<UserGroupMembershipCreationPolicy> userGroupMembershipCreationPolicies, PermissionEnforcer permissionEnforcer, AccountLockProtectionService accountLockProtectionService) {
        this.userProfileCreationPolicies = userProfileCreationPolicies;
        this.userGroupMembershipCreationPolicies = userGroupMembershipCreationPolicies;
        this.permissionEnforcer = permissionEnforcer;
        this.accountLockProtectionService = accountLockProtectionService;
    }
}

