package com.xebialabs.xlrelease.script.builder

import com.xebialabs.xlrelease.domain.facet.Facet
import com.xebialabs.xlrelease.domain.{ScriptHelper, Task}
import com.xebialabs.xlrelease.script.{XlrScript, XlrScriptContext}

import javax.script.ScriptContext.ENGINE_SCOPE

class TaskFacetCheckScriptContextBuilder(task: Task, facet: Facet) extends ScriptContextBuilder {
  withScriptApi().withLogger().withExecutionId(task.getExecutionId)
  withPythonSugar().withPythonGlobals().withPythonReleaseApi().withPythonUtilities()

  override def doBuild(context: XlrScriptContext): Unit = {
    context.addDomainObjects(safe(task))
    context.setAttribute("currentFacet", facet, ENGINE_SCOPE)

    val scriptContent = ScriptHelper.getScript(facet)
    val script = XlrScript.byContent(s"<facet_check>${task.getType}[${task.getId}]", scriptContent, wrap = true, checkPermissions = true)
    context.addScript(script)
  }

}