/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.overthere.util.OverthereUtils;
import com.xebialabs.xlrelease.api.internal.converters.CustomLogoSettingsConverter;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.configuration.ArchivingSettings;
import com.xebialabs.xlrelease.configuration.CustomLogoContentType;
import com.xebialabs.xlrelease.configuration.CustomLogoSettings;
import com.xebialabs.xlrelease.configuration.FeatureSettings;
import com.xebialabs.xlrelease.configuration.PollingSettings;
import com.xebialabs.xlrelease.configuration.ReleasePasswordSettings;
import com.xebialabs.xlrelease.configuration.ReportsSettings;
import com.xebialabs.xlrelease.configuration.SystemMessageSettings;
import com.xebialabs.xlrelease.configuration.ThemeSettings;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.BaseSettings;
import com.xebialabs.xlrelease.domain.events.ConfigurationCreatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.ConfigurationService;
import com.xebialabs.xlrelease.service.DbCredentialsChangeResult;
import com.xebialabs.xlrelease.service.DbCredentialsService;
import com.xebialabs.xlrelease.views.ArchivingSettingsView;
import com.xebialabs.xlrelease.views.CustomLogoSettingsView;
import com.xebialabs.xlrelease.views.PollingSettingsView;
import com.xebialabs.xlrelease.views.ReleasePasswordSettingsView;
import com.xebialabs.xlrelease.views.ReportsSettingsView;
import com.xebialabs.xlrelease.views.UpdateDBCredentialsForm;
import io.micrometer.core.annotation.Timed;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.jdk.javaapi.CollectionConverters;

@Path(value="/settings")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class SettingsResource {
    private static final Logger logger = LoggerFactory.getLogger(SettingsResource.class);
    public static final String MESSAGE = "message";
    private final PermissionChecker permissions;
    private final ConfigurationRepository configurationRepository;
    private final ConfigurationService configurationService;
    private final CustomLogoSettingsConverter customLogoSettingsConverter;
    private final XLReleaseEventBus eventBus;
    private final XlrConfig xlrConfig;
    private final DbCredentialsService dbCredentialsService;

    @Autowired
    public SettingsResource(PermissionChecker permissionChecker, ConfigurationRepository configurationRepository, ConfigurationService configurationService, CustomLogoSettingsConverter customLogoSettingsConverter, XLReleaseEventBus eventBus, XlrConfig xlrConfig, DbCredentialsService dbCredentialsService) {
        this.permissions = permissionChecker;
        this.configurationRepository = configurationRepository;
        this.configurationService = configurationService;
        this.customLogoSettingsConverter = customLogoSettingsConverter;
        this.eventBus = eventBus;
        this.xlrConfig = xlrConfig;
        this.dbCredentialsService = dbCredentialsService;
    }

    @GET
    @Timed
    @Path(value="reports")
    public ReportsSettingsView getReportsSettings() {
        ReportsSettings reportsSettings = (ReportsSettings)this.configurationRepository.read("Configuration/settings/ReportsSettings");
        return new ReportsSettingsView(reportsSettings);
    }

    @GET
    @Timed
    @Path(value="polling-interval")
    public PollingSettingsView getPollingInterval() {
        PollingSettings pollingSettings = (PollingSettings)this.configurationRepository.read("Configuration/settings/PollingSettings");
        return new PollingSettingsView(pollingSettings);
    }

    @GET
    @Timed
    @Path(value="archiving-settings")
    public ArchivingSettingsView getArchivingSettings() {
        ArchivingSettings archivingSettings = (ArchivingSettings)this.configurationRepository.read("Configuration/settings/ArchivingSettings");
        return new ArchivingSettingsView(archivingSettings);
    }

    @GET
    @Timed
    @Path(value="release-password-settings")
    public ReleasePasswordSettingsView getReleasePasswordSettings() {
        ReleasePasswordSettings releasePasswordSettings = (ReleasePasswordSettings)this.configurationRepository.read("Configuration/settings/ReleasePasswordSettings");
        return new ReleasePasswordSettingsView(releasePasswordSettings);
    }

    @GET
    @Timed
    @Path(value="theme")
    public ThemeSettings getThemeSettings() {
        return this.configurationService.getThemeSettings();
    }

    @GET
    @Timed
    @Path(value="system-message")
    public SystemMessageSettings getSystemMessage() {
        if (XlrConfig.getInstance().maintenanceModeEnabled()) {
            SystemMessageSettings maintenanceModeMessage = new SystemMessageSettings();
            maintenanceModeMessage.setId("Configuration/settings/SystemMessageSettings");
            maintenanceModeMessage.setEnabled(true);
            maintenanceModeMessage.setMessage("Release server is running in Maintenance Mode");
            maintenanceModeMessage.setTitle("Default Maintenance Mode Message");
            return maintenanceModeMessage;
        }
        return (SystemMessageSettings)this.configurationRepository.read("Configuration/settings/SystemMessageSettings");
    }

    @GET
    @Timed
    @Path(value="upload")
    public Response getUploadAttachmentSettings() {
        return Response.ok(Map.of("fileTypes", CollectionConverters.asJava(this.xlrConfig.server().upload().allowedFileTypes()).keySet(), "maxSize", this.xlrConfig.server().upload().maxSize(), "enabled", this.xlrConfig.server().upload().shouldAnalyzeContent())).build();
    }

    @GET
    @Timed
    @Path(value="ci/{ID:Configuration.*}")
    public Response read(@PathParam(value="ID") String id) {
        this.permissions.check(PlatformPermissions.ADMIN);
        if (id.equals("Configuration/settings/ThemeSettings")) {
            ThemeSettings themeSettings = this.getThemeSettings();
            return Response.ok((Object)themeSettings).build();
        }
        try {
            Object configuration = this.configurationRepository.read(id);
            return Response.ok(configuration).build();
        }
        catch (NotFoundException e) {
            logger.debug(e.getMessage());
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @POST
    @Timed
    @Path(value="ci/{ID:Configuration.*}")
    public BaseConfiguration create(@PathParam(value="ID") String id, BaseConfiguration configurationItem) {
        this.permissions.check(PlatformPermissions.ADMIN);
        configurationItem.setId(id);
        this.fixSmtpAuthenticationProperties(configurationItem);
        this.configurationRepository.create(configurationItem);
        Object conf = this.configurationRepository.read(id);
        this.eventBus.publish((XLReleaseEvent)new ConfigurationCreatedEvent(conf));
        return conf;
    }

    @PUT
    @Timed
    @Path(value="ci/{ID:Configuration.*}")
    public BaseConfiguration update(@PathParam(value="ID") String id, BaseConfiguration configurationItem) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.fixSmtpAuthenticationProperties(configurationItem);
        return this.configurationService.createOrUpdate(id, configurationItem);
    }

    @DELETE
    @Timed
    @Path(value="ci/{ID:Configuration.*}")
    public void delete(@PathParam(value="ID") String id) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.configurationService.delete(id);
    }

    @GET
    @Path(value="content-type/image")
    public List<String> getCustomLogoContentTypes() {
        return CustomLogoContentType.getBrowserTypes();
    }

    @POST
    @Timed
    @Path(value="custom-logo/upload")
    @Consumes(value={"multipart/form-data"})
    public CustomLogoSettings setCustomLogo(@Context HttpServletRequest request) throws IOException {
        this.permissions.check(PlatformPermissions.ADMIN);
        try {
            Optional<Part> optionalPart = request.getParts().stream().filter(part -> part.getSubmittedFileName() != null && !part.getSubmittedFileName().isEmpty()).findFirst();
            if (optionalPart.isPresent()) {
                Part logoPart = optionalPart.get();
                return this.configurationService.saveCustomLogo(this.customLogoSettingsConverter.from(logoPart.getSubmittedFileName(), logoPart.getContentType(), logoPart.getInputStream()));
            }
            throw new BadRequestException("Expected logo file in request");
        }
        catch (ServletException e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof IllegalStateException) {
                IllegalStateException stateException = (IllegalStateException)rootCause;
                throw stateException;
            }
            logger.error("Unable to upload file", (Throwable)e);
            throw new BadRequestException("Expected multipart content");
        }
        catch (IllegalStateException e) {
            throw new BadRequestException("Unable to upload file", (Throwable)e);
        }
    }

    @GET
    @Path(value="custom-logo/download")
    public Response downloadCustomLogo() {
        try {
            CustomLogoSettings customLogoSettings = (CustomLogoSettings)this.configurationRepository.read("Configuration/settings/CustomLogoSettings");
            if (customLogoSettings.getContent() == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            CustomLogoSettingsView customLogoSettingsView = this.customLogoSettingsConverter.toView(customLogoSettings);
            StreamingOutput output = stream -> {
                ByteArrayInputStream is = new ByteArrayInputStream(customLogoSettingsView.getContent());
                OverthereUtils.write((InputStream)is, (OutputStream)stream);
            };
            return Response.ok((Object)output, (String)customLogoSettingsView.getContentType()).build();
        }
        catch (NotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @DELETE
    @Path(value="custom-logo")
    public Response deleteCustomLogo() {
        try {
            CustomLogoSettings customLogoSettings = (CustomLogoSettings)this.configurationRepository.read("Configuration/settings/CustomLogoSettings");
            customLogoSettings.setContent(null);
            customLogoSettings.setContentType(null);
            customLogoSettings.setFilename(null);
            this.configurationService.saveCustomLogo(customLogoSettings);
            return Response.ok().build();
        }
        catch (NotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @GET
    public List<BaseSettings> getSystemSettings() {
        return this.configurationService.getSystemSettings();
    }

    @PUT
    @Timed
    public List<BaseSettings> updateSettings(List<BaseSettings> settings) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.configurationService.saveSettings(settings);
        return this.configurationService.getSystemSettings();
    }

    @GET
    @Path(value="features")
    public List<FeatureSettings> getFeatureSettings() {
        return this.configurationService.getFeatureSettings();
    }

    @GET
    @Path(value="features/{type}")
    public FeatureSettings getFeatureSetting(@PathParam(value="type") String type) {
        return this.configurationService.getFeatureSettings(type);
    }

    @PUT
    @Timed
    @Path(value="features")
    public List<FeatureSettings> updateFeatureSettings(List<FeatureSettings> features) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.configurationService.saveFeatureSettings(features);
        return this.configurationService.getFeatureSettings();
    }

    @PUT
    @Path(value="/reloadDbConfig")
    public Response reloadDbConfig(UpdateDBCredentialsForm form) {
        this.permissions.check(PlatformPermissions.ADMIN);
        String database = form.getDatabase();
        String username = form.getDbUsername();
        String password = form.getDbPassword();
        if (this.xlrConfig.isLiveDbCredentialUpdateEnabled()) {
            DbCredentialsChangeResult result = this.dbCredentialsService.validateAndPublishCredentialsChangeRequest(username, password, database);
            if (result.success()) {
                return Response.ok(Map.of(MESSAGE, result.message())).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(Map.of(MESSAGE, result.message())).build();
        }
        return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity(Map.of(MESSAGE, "This feature is currently disabled")).build();
    }

    private void fixSmtpAuthenticationProperties(BaseConfiguration baseConfiguration) {
        BaseConfigurationItem authentication;
        if (baseConfiguration.getType().equals((Object)Type.valueOf((String)"xlrelease.SmtpServer")) && baseConfiguration.hasProperty("authentication") && (authentication = (BaseConfigurationItem)baseConfiguration.getProperty("authentication")) != null && authentication.getType().equals((Object)Type.valueOf((String)"xlrelease.OAuth2SmtpAuthentication"))) {
            if (authentication.hasProperty("accessToken")) {
                authentication.setProperty("accessToken", null);
            }
            if (authentication.hasProperty("expiresAt")) {
                authentication.setProperty("expiresAt", null);
            }
        }
    }
}

