/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.google.common.base.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemConflictException;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.api.v1.ConfigurationApi;
import com.xebialabs.xlrelease.api.v1.VariableComponent;
import com.xebialabs.xlrelease.api.v1.forms.Variable;
import com.xebialabs.xlrelease.configuration.SystemMessageSettings;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.runner.RemoteJobRunner;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ExternalVariableService;
import com.xebialabs.xlrelease.service.SharedConfigurationService;
import com.xebialabs.xlrelease.service.SharedConfigurationStatusService;
import com.xebialabs.xlrelease.service.VariableService;
import com.xebialabs.xlrelease.utils.CiHelper;
import com.xebialabs.xlrelease.variable.VariableHelper;
import com.xebialabs.xlrelease.views.ConfigurationView;
import com.xebialabs.xlrelease.views.SharedConfigurationStatusResponse;
import com.xebialabs.xlrelease.views.converters.ConfigurationItemViewConverter;
import io.micrometer.core.annotation.Timed;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class ConfigurationApiImpl
implements ConfigurationApi {
    private SharedConfigurationService sharedConfigurationService;
    private PermissionChecker permissions;
    private VariableService variableService;
    private ConfigurationRepository configurationRepository;
    private ConfigurationItemViewConverter configurationViewConverter;
    private SharedConfigurationStatusService sharedConfigurationStatusService;
    private ExternalVariableService externalVariableService;
    private VariableComponent variableComponent;

    @Autowired
    public ConfigurationApiImpl(PermissionChecker permissions, VariableService variableService, SharedConfigurationService sharedConfigurationService, ConfigurationRepository configurationRepository, ConfigurationItemViewConverter configurationViewConverter, SharedConfigurationStatusService sharedConfigurationStatusService, ExternalVariableService externalVariableService, VariableComponent variableComponent) {
        this.permissions = permissions;
        this.variableService = variableService;
        this.sharedConfigurationService = sharedConfigurationService;
        this.configurationRepository = configurationRepository;
        this.configurationViewConverter = configurationViewConverter;
        this.sharedConfigurationStatusService = sharedConfigurationStatusService;
        this.externalVariableService = externalVariableService;
        this.variableComponent = variableComponent;
    }

    public ConfigurationApiImpl() {
    }

    @Timed
    public List<com.xebialabs.xlrelease.domain.variables.Variable> getGlobalVariables() {
        return this.variableService.findGlobalVariablesOrEmpty().getVariables();
    }

    @Timed
    public Map<String, String> getGlobalVariableValues() {
        return VariableHelper.getVariableValuesAsStrings((List)this.variableService.findGlobalVariablesOrEmpty().getVariables());
    }

    @Timed
    public com.xebialabs.xlrelease.domain.variables.Variable getGlobalVariable(String variableId) {
        return this.variableService.findById(variableId);
    }

    @Timed
    public com.xebialabs.xlrelease.domain.variables.Variable addGlobalVariable(Variable variable) {
        this.permissions.check(XLReleasePermissions.EDIT_GLOBAL_VARIABLES);
        Checks.checkArgument((!Strings.isNullOrEmpty((String)variable.getKey()) ? 1 : 0) != 0, (String)"Variable must have a 'key' field", (Object[])new Object[0]);
        this.externalVariableService.checkExistsAndCorrectType(variable.getExternalVariableValue());
        if (this.variableService.findGlobalVariablesOrEmpty().getVariablesByKeys().containsKey(variable.getKey())) {
            throw new ItemConflictException("A global variable already exists by key [%s]", new Object[]{variable.getKey()});
        }
        return this.variableService.addGlobalVariable(variable.toReleaseVariable());
    }

    @Timed
    public com.xebialabs.xlrelease.domain.variables.Variable updateGlobalVariable(String variableId, com.xebialabs.xlrelease.domain.variables.Variable variable) {
        variable.setId(variableId);
        if (!VariableHelper.isGlobalVariableId((String)variable.getId())) {
            throw new ItemConflictException("Variable id [%s] doesn't belong to the global variable", new Object[]{variable.getId()});
        }
        this.permissions.check(XLReleasePermissions.EDIT_GLOBAL_VARIABLES);
        return this.variableService.updateGlobalVariable(variable);
    }

    @Timed
    public com.xebialabs.xlrelease.domain.variables.Variable updateGlobalVariable(com.xebialabs.xlrelease.domain.variables.Variable variable) {
        return this.updateGlobalVariable(variable.getId(), variable);
    }

    @Timed
    public void deleteGlobalVariable(String variableId) {
        this.permissions.check(XLReleasePermissions.EDIT_GLOBAL_VARIABLES);
        this.variableService.findById(variableId);
        this.variableService.deleteGlobalVariable(variableId);
    }

    @Timed
    public Collection<Object> getGlobalVariablePossibleValues(String variableId) {
        return this.variableComponent.getVariablePossibleValues(this.getGlobalVariable(variableId));
    }

    @Timed
    public List<? extends ConfigurationItem> searchByTypeAndTitle(String configurationType, String title) {
        return this.searchByTypeAndTitle(configurationType, title, null, false);
    }

    @Timed
    public List<? extends ConfigurationItem> searchByTypeAndTitle(String configurationType, String title, String folderId) {
        return this.searchByTypeAndTitle(configurationType, title, folderId, false);
    }

    @Timed
    public List<Configuration> searchByTypeAndTitle(String configurationType, String title, String folderId, boolean folderOnly) {
        List<Configuration> items = this.sharedConfigurationService.searchByTypeAndTitle(Type.valueOf((String)configurationType), title, folderId, folderOnly);
        items.forEach(item -> CiHelper.forFields((ConfigurationItem)item, PropertyDescriptor::isPassword, (ci, pd) -> pd.set(ci, null)));
        return items;
    }

    @Timed
    public List<Configuration> getConfigurations(List<String> configurationIds) {
        return this.sharedConfigurationService.findByIds(configurationIds);
    }

    @Timed
    public Configuration getConfiguration(String configurationId) {
        return this.sharedConfigurationService.findById(configurationId);
    }

    @Timed
    public Configuration addConfiguration(Configuration configuration) {
        this.checkEditConfigurationPermissions(configuration);
        return this.sharedConfigurationService.create(configuration);
    }

    @Timed
    public Configuration updateConfiguration(String configurationId, Configuration configuration) {
        this.checkEditConfigurationPermissions(configurationId);
        return this.sharedConfigurationService.update(configurationId, configuration);
    }

    @Timed
    public Configuration updateConfiguration(Configuration configuration) {
        return this.updateConfiguration(configuration.getId(), configuration);
    }

    @Timed
    public void deleteConfiguration(String configurationId) {
        this.checkEditConfigurationPermissions(configurationId);
        this.sharedConfigurationService.delete(configurationId);
    }

    private void checkEditConfigurationPermissions(String configurationId) {
        Configuration configuration = this.sharedConfigurationService.findById(configurationId);
        this.checkEditConfigurationPermissions(configuration);
    }

    private void checkEditConfigurationPermissions(Configuration configuration) {
        if (configuration.getFolderId() == null) {
            if (configuration.getType().instanceOf(Type.valueOf(RemoteJobRunner.class))) {
                this.permissions.check(XLReleasePermissions.EDIT_RUNNER);
            } else {
                this.permissions.check(PlatformPermissions.ADMIN);
            }
        } else {
            this.permissions.check(XLReleasePermissions.EDIT_FOLDER_CONFIGURATION, configuration.getFolderId());
        }
    }

    @Timed
    public SystemMessageSettings getSystemMessage() {
        return (SystemMessageSettings)this.configurationRepository.read("Configuration/settings/SystemMessageSettings");
    }

    @Timed
    public SystemMessageSettings updateSystemMessage(SystemMessageSettings systemMessageSettings) {
        this.permissions.check(PlatformPermissions.ADMIN);
        return this.configurationRepository.update(systemMessageSettings);
    }

    @Timed
    public SharedConfigurationStatusResponse checkStatus(ConfigurationView configurationView) {
        Configuration configuration = this.configurationViewConverter.fromView(configurationView);
        this.checkEditConfigurationPermissions(configuration);
        return this.sharedConfigurationStatusService.checkStatus(configuration);
    }

    @Timed
    public SharedConfigurationStatusResponse checkStatus(String configurationId) {
        Configuration configuration = this.sharedConfigurationService.findById(configurationId);
        this.checkEditConfigurationPermissions(configuration);
        return this.sharedConfigurationStatusService.checkStatus(configuration);
    }
}

