package com.xebialabs.xlrelease.utils

import scala.jdk.CollectionConverters._

object QueryParamUtils {

  val MAX_IN_CLAUSE_SIZE: Int = 900

  def getRoleIdParams(roleIds: Iterable[String]): Map[String, Any] = {
    var queryParams: Map[String, Any] = Map()
    val rolesGrouped = roleIds.grouped(MAX_IN_CLAUSE_SIZE).toSeq
    for (w <- rolesGrouped.indices) {
      queryParams += s"roleIds$w" -> rolesGrouped(w).toList.asJava
    }
    queryParams
  }

}
