package com.xebialabs.xlrelease.script.builder

import com.xebialabs.xlrelease.configuration.TaskTimeoutSettings
import com.xebialabs.xlrelease.domain.Task
import com.xebialabs.xlrelease.script.{ScriptTimeoutContext, XlrScript, XlrScriptContext}

import java.time.Duration
import java.util.concurrent.ScheduledExecutorService

class FailureHandlerScriptContextBuilder(task: Task,
                                         timeoutExecutor: ScheduledExecutorService,
                                         timeoutSettings: TaskTimeoutSettings
                                        ) extends ScriptContextBuilder {
  withScriptApi().withLogger().withExecutionId(task.getExecutionId)
  withPythonSugar().withPythonGlobals().withPythonReleaseApi().withPythonUtilities()
  val timeoutEnabled = true
  val timeout = Duration.ofSeconds(timeoutSettings.getFailureHandlerTimeout.toLong)
  withTimeoutContext(new ScriptTimeoutContext(timeoutEnabled, timeoutExecutor, timeout, "Failure handler script timed out."))

  override def doBuild(context: XlrScriptContext): Unit = {
    context.addDomainObjects(safe(task))

    val script = XlrScript.byContent(s"<failure_handler>${task.getType}[${task.getId}]", task.getFailureHandler, wrap = true, checkPermissions = true)
    context.addScript(script)
  }

}