package com.xebialabs.xlrelease.variable

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.xlrelease.api.v1.forms.VariableOrValue
import com.xebialabs.xlrelease.domain.VisitableItem
import com.xebialabs.xlrelease.domain.variables.reference.{VariableCollectingVisitor, VariableReference}
import com.xebialabs.xlrelease.domain.variables.{StringVariable, Variable}
import com.xebialabs.xlrelease.variable.VariableHelper.withoutVariableSyntax

import scala.jdk.CollectionConverters._

object VariableResolver {
  def resolve(item: VisitableItem, variables: Seq[Variable]): (Set[String], Set[ConfigurationItem]) = {
    val resolved = VariablesGraphResolver.resolve(variables.toSet)
    val variableKeysInNonInterpolatableVars = variables.filter(v => v.isInstanceOf[StringVariable] && v.asInstanceOf[StringVariable].isPreventInterpolation)
      .map(v => VariableHelper.collectVariables(v.getValue)).flatMap(_.asScala.toSeq).toSet
    val updatedCis: Set[ConfigurationItem] = for {
      ref <- VariableCollectingVisitor.collectFrom(item).asScala.toSet[VariableReference]
      key = withoutVariableSyntax(ref.getKey)
      v <- resolved.get(key).toSet
      if v.resolved
      up <- ref.getUsagePoints.asScala
      u <- up.replaceVariable(v.variable, new VariableOrValue(null, v.value)).asScala
    } yield u

    val unresolvedVariables = VariableCollectingVisitor.collectFrom(item)
      .asScala.toSet[VariableReference].map(_.getKey) diff variableKeysInNonInterpolatableVars

    (unresolvedVariables, updatedCis)
  }
}
