package com.xebialabs.xlrelease.repository

import com.xebialabs.xlrelease.domain.UserProfile
import com.xebialabs.xlrelease.views.users.UserFilters
import org.springframework.data.domain.{Pageable, Page => SPage}

import java.util.{Date, List => JList}
import scala.jdk.CollectionConverters._
import scala.util.Try

trait UserProfileRepository {

  def create(userProfile: UserProfile): Unit

  def update(userProfile: JList[UserProfile]): List[Try[UserProfile]]

  def updateLastActive(canonicalId: String, lastActive: Date, evictCache: Boolean): Boolean

  def updateLastActiveBatch(entries: Map[String, Date]): Int

  def updateLastActiveBatch(entries: java.util.Map[String, Date]): Int =
    updateLastActiveBatch(entries.asScala.toMap)

  def delete(userProfileId: String): Unit

  def findById(canonicalId: String): Option[UserProfile]

  def findByIdBypassCache(canonicalId: String): Option[UserProfile]

  def findAll(fullProfile: Boolean = false): JList[UserProfile]

  def exists(canonicalId: String): Boolean

  def customSearch(email: String, fullName: String, loginAllowed: java.lang.Boolean,
                   lastActiveAfter: Date, lastActiveBefore: Date,
                   page: Option[Long], resultsPerPage: Option[Long]): JList[UserProfile]

  def countUserWithLoginAllowed(): Int

  def searchUserProfiles(userFilters: UserFilters, pageable: Pageable): SPage[UserProfile]

  def findByUsernameForUpdate(canonicalId: String): Option[UserProfile]

  def updateFailedLoginAttempt(canonicalId: String, newCount: Int, newLocked: Boolean, lastFailedAttemptAt: Date, evictCache: Boolean): Int

}
