package com.xebialabs.deployit.plumbing

import com.xebialabs.deployit.server.api.upgrade.Version.VERSION_0
import org.springframework.core.io.ClassPathResource

import java.io.IOException
import java.util.Properties

object CurrentVersion {
  private val RELEASE_PROPERTIES = "com/xebialabs/deployit/release.properties"
  private val VERSION_PROPERTY = "version"

  private lazy val version = {
    val resource = new ClassPathResource(RELEASE_PROPERTIES)
    val properties = new Properties
    try {
      properties.load(resource.getInputStream)
    } catch {
      case ioe: IOException =>
        throw new RuntimeException(ioe)
    }
    val property = properties.getProperty(VERSION_PROPERTY)
    if ("@project.version@".equalsIgnoreCase(property)) {
      VERSION_0
    }
    else {
      property
    }
  }

  def get: String = version

  def getNoSnapshot = {
    var version = get
    if (version != null) version = version.replace("-SNAPSHOT", "")
    version
  }
}