package com.xebialabs.xlrelease.upgrade.common;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.server.api.upgrade.RepositoryInitialization;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.xlrelease.domain.BaseConfiguration;

/**
 * An {@link Upgrade} which is also a {@link RepositoryInitialization}. So it will be run
 * both on an empty repository as well as when upgrading to a specific version of a product or plugin.
 */
public abstract class BaseInitializingUpgrade extends Upgrade implements RepositoryInitialization {

    @Override
    public final void doInitialize() {
        doUpgrade();
    }

    @Override
    public final String getComponent() {
        return upgradeVersion().getComponent();
    }

    /**
     * Creates a new configuration instance using the descriptor registry.
     *
     * @param id The unique identifier for the configuration
     * @param type The class type of the configuration to create
     * @param <C> The configuration type, must extend BaseConfiguration
     * @return A new instance of the specified configuration type
     */
    protected <C extends BaseConfiguration> C createConfiguration(String id, Class<C> type) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor(Type.valueOf(type));
        return descriptor.newInstance(id);
    }
}
