/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.typesafe.config.Config;
import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.plumbing.CurrentVersion$;
import com.xebialabs.plugin.manager.cli.PluginManagerCli;
import com.xebialabs.plugin.manager.cli.PluginManagerCliLaunchOptions;
import com.xebialabs.plugin.manager.cli.PluginManagerCliLaunchOptions$;
import com.xebialabs.plugin.manager.config.PluginManagerProperties;
import com.xebialabs.plugin.manager.metadata.XLProduct;
import com.xebialabs.plugin.manager.repository.sql.SqlPluginRepository;
import com.xebialabs.xlrelease.ReleaseServer;
import com.xebialabs.xlrelease.XLReleaseBootstrapper$;
import com.xebialabs.xlrelease.XLReleaseServerLaunchOptions;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.config.XlrConfig$;
import com.xebialabs.xlrelease.pluginmanager.XlrPluginManagerProps;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.ResourceUtils;
import scala.Predef$;

public final class PluginManagerCliBootstrapper$ {
    public static final PluginManagerCliBootstrapper$ MODULE$ = new PluginManagerCliBootstrapper$();

    public void main(String[] args) {
        PluginManagerCliLaunchOptions cliLaunchOptions = PluginManagerCliLaunchOptions$.MODULE$.parseCommandLine(args);
        if (cliLaunchOptions == null) {
            System.exit(0);
        }
        XLReleaseServerLaunchOptions serverLaunchOptions = new XLReleaseServerLaunchOptions();
        File serverConfFile = ResourceUtils.getFile((String)XlrConfig$.MODULE$.bootConfig().confFile_location());
        ServerConfigFile confFile = new ServerConfigFile(serverConfFile);
        XLReleaseBootstrapper$.MODULE$.releaseServer_$eq(new ReleaseServer(serverLaunchOptions, confFile));
        XLReleaseBootstrapper$.MODULE$.releaseServer().prepareConfigs();
        this.runPluginManagerCli(cliLaunchOptions);
        System.exit(0);
    }

    public void runPluginManagerCli(PluginManagerCliLaunchOptions options) {
        HikariDataSource ds = this.dataSource();
        SqlPluginRepository repository = this.sqlPluginRepository(ds);
        XlrPluginManagerProps xlrPluginManagerProps = this.getXlrPluginManagerProps();
        PluginManagerCli cli = this.pluginManagerCli(xlrPluginManagerProps, repository);
        StringBuffer output = cli.run(options);
        Predef$.MODULE$.println((Object)output);
        ds.close();
    }

    public HikariDataSource dataSource() {
        XlrConfig xlrConfig = XlrConfig$.MODULE$.getInstance();
        HikariConfig cfg = new HikariConfig();
        cfg.setDriverClassName(xlrConfig.xlrRepositoryDriver());
        cfg.setJdbcUrl(xlrConfig.xlrRepositoryJdbcUrl());
        cfg.setUsername(xlrConfig.xlrRepositoryUsername());
        cfg.setPassword(xlrConfig.xlrRepositoryPassword());
        return new HikariDataSource(cfg);
    }

    private XlrPluginManagerProps getXlrPluginManagerProps() {
        XlrConfig xlrConfig = XlrConfig$.MODULE$.getInstance();
        Config repository = xlrConfig.getXl().getConfig("features").getConfig("plugins").getConfig("repositories").getConfig("xlr-official");
        Config servers = xlrConfig.getXl().getConfig("features").getConfig("plugins").getConfig("servers").getConfig("xebialabs-plugins");
        Config proxyConfig = servers.hasPath("proxy") ? servers.getConfig("proxy") : null;
        String proxyHost = proxyConfig != null && proxyConfig.hasPath("host") ? proxyConfig.getString("host") : "";
        int proxyPort = proxyConfig != null && proxyConfig.hasPath("port") ? proxyConfig.getInt("port") : 0;
        String proxyUsername = proxyConfig != null && proxyConfig.hasPath("credentials") ? proxyConfig.getConfig("credentials").getString("username") : "";
        String proxyPassword = proxyConfig != null && proxyConfig.hasPath("credentials") ? proxyConfig.getConfig("credentials").getString("password") : "";
        XlrPluginManagerProps xlrPluginManagerProps = new XlrPluginManagerProps(servers.getString("server-type"), servers.getString("url"), servers.getConfig("credentials").getString("username"), servers.getConfig("credentials").getString("password"), proxyHost, Predef$.MODULE$.int2Integer(proxyPort), proxyUsername, proxyPassword, repository.getString("repository-type"), repository.getString("server-ref"), repository.getString("nexus-repository-id"), repository.getString("nexus-group-id"), repository.getConfig("nexus-metadata-artifact").getString("group-id"), repository.getConfig("nexus-metadata-artifact").getString("artifact-id"), repository.getString("xl-component"), repository.getString("enabled"));
        return xlrPluginManagerProps;
    }

    public SqlPluginRepository sqlPluginRepository(HikariDataSource dataSource) {
        return new SqlPluginRepository(new JdbcTemplate((DataSource)dataSource));
    }

    public PluginManagerCli pluginManagerCli(PluginManagerProperties pluginManagerProperties, SqlPluginRepository sqlPluginRepository) {
        return new PluginManagerCli(pluginManagerProperties, sqlPluginRepository, (XLProduct)XLProduct.XLRelease$.MODULE$, CurrentVersion$.MODULE$.get(), XlrConfig$.MODULE$.getInstance().features().plugins().checkJdk17CompatibilityOnPluginInstall());
    }

    private PluginManagerCliBootstrapper$() {
    }
}

