/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.deployit.core.api.dto.RolePermissions;
import com.xebialabs.deployit.core.rest.api.SecurityResource;
import com.xebialabs.deployit.engine.api.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.domain.events.GlobalRolesOrPermissionsUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.views.RolePermissionsView;
import com.xebialabs.xlrelease.views.RolesPermissionsView;
import io.micrometer.core.annotation.Timed;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/roles/permissions")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class RolePermissionsResource {
    private final RoleService roleService;
    private final SecurityResource securityResource;
    private final PermissionChecker permissionChecker;
    private final XLReleaseEventBus xlReleaseEventBus;

    @Autowired
    public RolePermissionsResource(RoleService roleService, SecurityResource securityResource, PermissionChecker permissionChecker, XLReleaseEventBus xlReleaseEventBus) {
        this.roleService = roleService;
        this.securityResource = securityResource;
        this.permissionChecker = permissionChecker;
        this.xlReleaseEventBus = xlReleaseEventBus;
    }

    @GET
    @Timed
    @Path(value="global")
    public RolesPermissionsView getGlobalRolePermissions() {
        this.permissionChecker.check(PlatformPermissions.EDIT_SECURITY);
        List permissions = this.securityResource.readRolePermissions(PermissionChecker.GLOBAL_SECURITY_ALIAS(), null, null, null);
        Map<String, List<RolePermissions>> permissionLookup = permissions.stream().collect(Collectors.groupingBy(role -> role.getRole().getId()));
        List roles = this.roleService.getRoles();
        ArrayList<RolePermissions> rolePermissions = new ArrayList<RolePermissions>();
        for (com.xebialabs.deployit.security.Role securityRole : roles) {
            if (permissionLookup.containsKey(securityRole.getId())) {
                rolePermissions.addAll((Collection<RolePermissions>)permissionLookup.get(securityRole.getId()));
                continue;
            }
            rolePermissions.add(new RolePermissions(new Role(securityRole.getId(), securityRole.getName()), new ArrayList()));
        }
        return new RolesPermissionsView(rolePermissions, XLReleasePermissions.getGlobalPermissions());
    }

    @PUT
    @Timed
    @Path(value="global")
    public void setGlobalRolePermissions(List<RolePermissionsView> rolePermissionsViews) {
        this.permissionChecker.check(PlatformPermissions.EDIT_SECURITY);
        this.validateAdminPermissionAssignment(rolePermissionsViews);
        List permissions = rolePermissionsViews.stream().map(RolePermissionsView::toRolePermissions).collect(Collectors.toList());
        this.securityResource.writeRolePermissions(PermissionChecker.GLOBAL_SECURITY_ALIAS(), permissions);
        this.xlReleaseEventBus.publish((XLReleaseEvent)GlobalRolesOrPermissionsUpdatedEvent.apply());
    }

    private void validateAdminPermissionAssignment(List<RolePermissionsView> rolePermissionsViews) {
        boolean assigningAdminPermission = this.isAssigningAdminPermission(rolePermissionsViews);
        boolean removingAdminPermission = this.isRemovingAdminPermission(rolePermissionsViews);
        if (assigningAdminPermission || removingAdminPermission) {
            this.permissionChecker.check(PlatformPermissions.ADMIN);
        }
    }

    private boolean isAssigningAdminPermission(List<RolePermissionsView> rolePermissionsViews) {
        return rolePermissionsViews.stream().anyMatch(view -> view.getPermissions() != null && view.getPermissions().contains(PlatformPermissions.ADMIN.getPermissionName()));
    }

    private boolean isRemovingAdminPermission(List<RolePermissionsView> rolePermissionsViews) {
        Map<String, List<String>> currentPermissionsMap = this.getCurrentPermissionsMap();
        return rolePermissionsViews.stream().anyMatch(view -> this.isAdminPermissionRemovedFromRole((RolePermissionsView)view, currentPermissionsMap));
    }

    private Map<String, List<String>> getCurrentPermissionsMap() {
        List currentPermissions = this.securityResource.readRolePermissions(PermissionChecker.GLOBAL_SECURITY_ALIAS(), null, null, null);
        return currentPermissions.stream().collect(Collectors.toMap(rp -> rp.getRole().getId(), RolePermissions::getPermissions));
    }

    private boolean isAdminPermissionRemovedFromRole(RolePermissionsView view, Map<String, List<String>> currentPermissionsMap) {
        String roleId;
        String string = roleId = view.getRole() != null ? view.getRole().getId() : null;
        if (roleId == null || !currentPermissionsMap.containsKey(roleId)) {
            return false;
        }
        List<String> currentPerms = currentPermissionsMap.get(roleId);
        ArrayList newPerms = view.getPermissions() != null ? view.getPermissions() : new ArrayList();
        return currentPerms.contains(PlatformPermissions.ADMIN.getPermissionName()) && !newPerms.contains(PlatformPermissions.ADMIN.getPermissionName());
    }
}

