package com.xebialabs.xlrelease.script.el

import com.xebialabs.xlrelease.script.el.MethodAccessCheck.AccessDenied
import org.springframework.core.convert.TypeDescriptor
import org.springframework.expression.spel.support.ReflectiveMethodResolver
import org.springframework.expression.{EvaluationContext, MethodExecutor}

import java.lang.reflect.{Method, Modifier}
import java.util

class ElMethodResolver(methodAccessCheck: MethodAccessCheck) extends ReflectiveMethodResolver {

  override def resolve(context: EvaluationContext, targetObject: Any, name: String, argumentTypes: util.List[TypeDescriptor]): MethodExecutor = {
    // Check if this is a blocked method call
    methodAccessCheck.checkAccess(targetObject, name) match {
      case MethodAccessCheck.AccessAllowed =>
        super.resolve(context, targetObject, name, argumentTypes)
      case MethodAccessCheck.AccessDenied(msg) =>
        throw new IllegalArgumentException(msg)
    }
  }

  override def isCandidateForInvocation(method: Method, targetClass: Class[_]): Boolean = {
    // Check if class is fully accessor-protected and this is a getter/setter
    val isBlockedAccessor = methodAccessCheck.checkAccess(targetClass.getName, method.getName).isInstanceOf[AccessDenied]

    if (isBlockedAccessor) {
      false
    } else if (Modifier.isStatic(method.getModifiers)) {
      false
    } else {
      val clazz = method.getDeclaringClass
      (clazz != classOf[Object]) && (clazz != classOf[Class[_]]) && !classOf[ClassLoader].isAssignableFrom(targetClass)
    }
  }
}
